@extends('layouts.dashboard.app')

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12 mb-2">
                <div class="page-title-box">
                    @can('create', App\Models\Facture::class)
                        <div class="page-title-right">
                            <a href="{{ route('Facture.create', $id) }}" class="btn btn-outline-primary">Créer Une Facture</a>
                        </div>
                    @endcan
                    <div class="page-title-left ">
                        <a href="{{ route('Dossier.show', $id) }}" class="mt-2 btn btn-outline-dark">Dossier</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="table-responsive">
            <table class="table table-stripped" id="myTable">
                <thead class="table-light">
                    <tr>

                        <th>Id</th>
                        <th>Dossier</th>
                        <th>Montant Facture</th>
                        <th>Type Facture</th>
                        <th>Status</th>
                        @can('view', App\Models\Facture::class)
                            <th style="width: 125px;">Afficher</th>
                        @endcan
                        @can('delete', App\Models\Facture::class)
                            <th> Action</th>
                        @endcan
                    </tr>
                </thead>
                <tbody>
                    @foreach ($factures as $facture)
                        <tr>

                            <td style="color: black; font-weight:bold">
                                {{ $facture->id ?? null }}
                            </td>
                            <td>
                                {{ $facture->dossier->ref ?? null }}
                            </td>
                            <td>
                                {{ $facture->montant_facture ?? null }} DH
                            </td>
                            <td>
                                {{ $facture->typefacture->type ?? null }}
                            </td>
                            <td>
                                <span
                                    class="badge bg-{{ $facture->status->color ?? null }} fs-5">{{ $facture->status->status ?? null }}
                                </span>
                            </td>

                            @can('view', App\Models\Facture::class)
                                <td>
                                    <a href="{{ route('Facture.show', $facture->id) }}" class="action-icon text-success"> <i
                                            class="mdi mdi-eye"></i></a>
                                </td>
                            @endcan
                            @can('delete', App\Models\Facture::class)
                                @if ($facture->devis_status_id == 4 || $facture->devis_status_id == 9)
                                    <td>
                                        <form action="{{ route('Facture.destroy', $facture->id) }}" method="post">
                                            @csrf
                                            @method('DELETE')
                                            <button class="btn btn-sm btn-danger rounded-pill" type="submit">
                                                <i class="uil uil-trash fs-5"></i>
                                            </button>
                                        </form>

                                    </td>
                                @endif
                            @endcan

                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div> <!-- end card-body-->
    </div> <!-- end card-->
    </div> <!-- end col -->
    </div>

    </div>

    </div>



    </div>

    </div>
@endsection
