@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4 ">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body mt-1">
                        <form action="{{ route('Ticket.store') }}" method="post">
                            @csrf

                            <div class="form-group mb-1">
                                <label for="r">Ref</label>
                                <input type="text" name="" readonly value="{{ $dossier->ref }}"
                                    class="form-select">
                            </div>
                            <input type="hidden" name="dossier_id" readonly value="{{ $dossier->id }}"
                                class="form-select">

                            <div class="form-group mb-1">
                                <label for="user">users</label>
                                <select class="form-select " name="user_id" id="user_id">
                                    @foreach ($users as $user)
                                        <option value="{{ $user->id }}">{{ $user->name }}</option>
                                    @endforeach
                                </select>
                                @error('user_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="form-group mb-1">
                                <label for="type"> Motif :</label>

                                <textarea name="motif" id="" class="form-control @error('motif') is-invalid @enderror" cols="30"
                                    rows="10">{{ old('motif') }}</textarea>
                                @error('motif')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Créer</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
