@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4 ">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body mt-1">
                        <form action="{{ route('SMS.store') }}" method="post">
                            @csrf
                            <div class="col-6">
                                <div class="form-group mb-1">
                                    <label for="step">Etape :</label>
                                    <select class="form-select @error('content') is-invalid @enderror" name="step"
                                        id="step">
                                        @foreach ($steps as $step)
                                            <option value="{{ $step->id }}">{{ $step->step }}</option>
                                        @endforeach
                                    </select>
                                    @error('step')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-group mb-1">
                                    <label for="message">Contenu :</label>
                                    <input type="text" name="message" value="{{ old('message') }}" required
                                        class="form-control @error('message') is-invalid @enderror">
                                    @error('message')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary">Créer</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
