@if (Auth::user()->role_id == 4)
    <?php
    $notifications = App\Models\Notification::with('user')
        ->whereDate('created_at', '=', Carbon\Carbon::today()->toDateString())
        ->latest()
        ->get();
    ?>
@else
    <?php
    $dossiers = App\Models\Dossier::user()->get();
    $array = [];
    foreach ($dossiers as $dossier) {
        array_push($array, $dossier->id);
    }
    $notifications = App\Models\Notification::whereIn('dossier_id', $array)
        ->whereDate('created_at', '=', Carbon\Carbon::today()->toDateString())
        ->latest()
        ->get();
    ?>
@endif

<style>
/* ============================================
   TOPBAR REDESIGN - Modern Style
   ============================================ */

/* Reset any inherited margins/paddings */
.navbar-custom {
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
    height: 70px;
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 0 15px !important;
    box-shadow: 0 2px 15px rgba(0, 0, 0, 0.1);
    position: relative;
    z-index: 1000;
    box-sizing: border-box;
    /* Exact negative margins to match .content-page padding: 70px 12px 65px */
    margin-top: -70px !important;
    margin-left: -12px !important;
    margin-right: -12px !important;
    margin-bottom: 20px !important;
    width: calc(100% + 24px) !important;
    max-width: calc(100% + 24px) !important;
}

/* Menu Toggle Button */
.button-menu-mobile {
    background: rgba(255, 255, 255, 0.1);
    border: none;
    color: #fff;
    width: 40px;
    height: 40px;
    min-width: 40px;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.2s ease;
    margin-right: 15px;
    flex-shrink: 0;
}

.button-menu-mobile:hover {
    background: rgba(255, 255, 255, 0.2);
}

.button-menu-mobile i {
    font-size: 24px;
}

/* Search Bar */
.topbar-search {
    flex: 1;
    max-width: 500px;
    margin: 0 15px;
}

.topbar-search .search-form {
    display: flex;
    align-items: center;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 10px;
    overflow: hidden;
    border: 1px solid rgba(255, 255, 255, 0.1);
    transition: all 0.2s ease;
}

.topbar-search .search-form:focus-within {
    background: rgba(255, 255, 255, 0.15);
    border-color: rgba(16, 185, 129, 0.5);
}

.topbar-search select {
    background: transparent;
    border: none;
    color: #fff;
    padding: 10px 15px;
    font-size: 13px;
    min-width: 110px;
    cursor: pointer;
    outline: none;
    -webkit-appearance: none;
    -moz-appearance: none;
    appearance: none;
}

.topbar-search select option {
    background: #1a1a2e;
    color: #fff;
}

.topbar-search .search-divider {
    width: 1px;
    height: 25px;
    background: rgba(255, 255, 255, 0.2);
    flex-shrink: 0;
}

.topbar-search input[type="search"] {
    flex: 1;
    background: transparent;
    border: none;
    color: #fff;
    padding: 10px 15px;
    font-size: 14px;
    outline: none;
    min-width: 100px;
}

.topbar-search input[type="search"]::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.topbar-search .search-btn {
    background: #10b981;
    border: none;
    color: #fff;
    padding: 10px 18px;
    cursor: pointer;
    transition: all 0.2s ease;
    flex-shrink: 0;
}

.topbar-search .search-btn:hover {
    background: #059669;
}

.topbar-search .search-btn i {
    font-size: 18px;
}

/* Right Menu */
.topbar-menu {
    display: flex;
    align-items: center;
    list-style: none;
    margin: 0 !important;
    padding: 0 !important;
    gap: 8px;
    flex-shrink: 0;
}

/* Notification Dropdown */
.notification-list {
    position: relative;
}

.notification-list > a {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 42px;
    height: 42px;
    min-width: 42px;
    border-radius: 10px;
    background: rgba(255, 255, 255, 0.1);
    color: #fff !important;
    transition: all 0.2s ease;
    position: relative;
}

.notification-list > a:hover {
    background: rgba(255, 255, 255, 0.2);
}

.notification-list .noti-icon {
    font-size: 20px;
}

.notification-list .noti-icon-badge {
    position: absolute;
    top: 8px;
    right: 8px;
    width: 8px;
    height: 8px;
    background: #ef4444;
    border-radius: 50%;
    border: 2px solid #1a1a2e;
}

/* Notification Dropdown Menu */
.notification-list .dropdown-menu {
    background: #fff;
    border: none;
    border-radius: 12px;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.15);
    padding: 0;
    min-width: 320px;
    max-width: 360px;
}

.notification-list .noti-title {
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
    color: #fff !important;
    border-radius: 12px 12px 0 0;
    padding: 15px 20px !important;
}

.notification-list .noti-title h5 {
    color: #fff !important;
    margin: 0;
    font-size: 16px;
    font-weight: 600;
}

.notification-list .notify-item {
    padding: 12px 15px;
    border-bottom: 1px solid #f1f5f9;
    transition: all 0.2s ease;
}

.notification-list .notify-item:hover {
    background: #f8fafc;
}

.notification-list .notify-item.card {
    border: none;
    margin: 8px 0;
    border-radius: 8px;
    background: #f8fafc;
}

.notification-list .notify-item .card-body {
    padding: 10px 12px;
}

.notification-list .noti-item-title {
    font-size: 13px;
    color: #1e293b;
    margin-bottom: 4px;
}

.notification-list .noti-item-subtitle {
    font-size: 12px;
    color: #64748b;
}

.notification-list .dropdown-menu .text-center {
    padding: 15px;
    border-top: 1px solid #f1f5f9;
}

/* User Profile Dropdown - IMPROVED RESPONSIVENESS */
.nav-user {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 6px 12px !important;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 10px;
    transition: all 0.2s ease;
    color: #fff !important;
    text-decoration: none !important;
    max-width: 200px;
    flex-shrink: 0;
}

.nav-user:hover {
    background: rgba(255, 255, 255, 0.2);
}

.nav-user .account-user-avatar {
    flex-shrink: 0;
}

.nav-user .account-user-avatar img {
    width: 36px;
    height: 36px;
    min-width: 36px;
    border-radius: 8px;
    border: 2px solid rgba(255, 255, 255, 0.2);
    object-fit: cover;
}

.nav-user > span:last-child {
    overflow: hidden;
    min-width: 0;
}

.nav-user .account-user-name {
    display: block;
    font-size: 13px;
    font-weight: 600;
    color: #fff;
    line-height: 1.2;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    max-width: 120px;
}

.nav-user .account-position {
    display: block;
    font-size: 11px;
    color: rgba(255, 255, 255, 0.6);
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    max-width: 120px;
}

/* User Dropdown Menu */
.profile-dropdown {
    background: #fff;
    border: none;
    border-radius: 12px;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.15);
    padding: 8px;
    min-width: 180px;
}

.profile-dropdown .dropdown-item {
    padding: 10px 15px;
    border-radius: 8px;
    font-size: 13px;
    color: #1e293b;
    transition: all 0.2s ease;
}

.profile-dropdown .dropdown-item:hover {
    background: #f1f5f9;
    color: #10b981;
}

.profile-dropdown .dropdown-item i {
    margin-right: 8px;
    font-size: 16px;
}

/* ============================================
   RESPONSIVE BREAKPOINTS
   ============================================ */

/* Large screens */
@media (max-width: 1199px) {
    .topbar-search {
        max-width: 400px;
    }
    
    .nav-user .account-user-name,
    .nav-user .account-position {
        max-width: 100px;
    }
}

/* Medium screens - tablets */
@media (max-width: 991px) {
    .topbar-search {
        display: none !important;
    }
    
    .nav-user > span:last-child {
        display: none !important;
    }
    
    .nav-user {
        padding: 6px !important;
        max-width: none;
        gap: 0;
    }
    
    .navbar-custom {
        padding: 0 10px !important;
        margin-top: -70px !important;
        margin-left: -12px !important;
        margin-right: -12px !important;
        width: calc(100% + 24px) !important;
        max-width: calc(100% + 24px) !important;
    }
}

/* Small screens - mobile */
@media (max-width: 767px) {
    .navbar-custom {
        padding: 0 8px !important;
        height: 60px;
    }
    
    .notification-list .dropdown-menu {
        min-width: 280px;
        position: fixed !important;
        right: 10px !important;
        left: auto !important;
        top: 65px !important;
        transform: none !important;
    }
    
    .profile-dropdown {
        position: fixed !important;
        right: 10px !important;
        left: auto !important;
        top: 65px !important;
        transform: none !important;
    }
    
    .topbar-menu {
        gap: 5px;
    }
    
    .button-menu-mobile {
        width: 36px;
        height: 36px;
        min-width: 36px;
        margin-right: 10px;
    }
    
    .notification-list > a {
        width: 38px;
        height: 38px;
        min-width: 38px;
    }
    
    .nav-user .account-user-avatar img {
        width: 32px;
        height: 32px;
        min-width: 32px;
    }
}

/* ============================================
   SIDEBAR MOBILE TOGGLE
   ============================================ */
@media (max-width: 991px) {
    /* Hide sidebar by default on mobile */
    .leftside-menu {
        transform: translateX(-100%);
        transition: transform 0.3s ease;
        position: fixed !important;
        left: 0;
        top: 0;
        z-index: 1050;
    }
    
    /* Show sidebar when body has 'sidebar-open' class */
    body.sidebar-open .leftside-menu {
        transform: translateX(0);
    }
    
    /* Overlay when sidebar is open */
    body.sidebar-open::before {
        content: '';
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0, 0, 0, 0.5);
        z-index: 1040;
        animation: fadeIn 0.3s ease;
    }
    
    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }
}
</style>

<div class="navbar-custom">
    <!-- Menu Toggle Button -->
    <button class="button-menu-mobile" id="sidebarToggle">
        <i class="mdi mdi-menu"></i>
    </button>

    <!-- Search Bar -->
    <div class="topbar-search d-none d-lg-block">
        <form class="search-form" action="{{ route('Dossier.archiveSearch') }}" method="POST">
            @csrf
            <select name="type">
                <option value="1">Matricule</option>
                <option value="2">Nom</option>
                <option value="3">Réference</option>
                <option value="4">N° Sinistre</option>
            </select>
            <div class="search-divider"></div>
            <input type="search" name="search" placeholder="Rechercher un dossier..." value="">
            <button type="submit" class="search-btn">
                <i class="uil uil-search"></i>
            </button>
        </form>
    </div>

    <!-- Right Menu -->
    <ul class="list-unstyled topbar-menu float-end mb-0">
        <!-- Notifications -->
        <li class="dropdown notification-list">
            <a class="nav-link dropdown-toggle arrow-none" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                <i class="dripicons-bell noti-icon"></i>
                @if(count($notifications) > 0)
                <span class="noti-icon-badge"></span>
                @endif
            </a>

            <div class="dropdown-menu dropdown-menu-end dropdown-menu-animated">
                <!-- Header -->
                <div class="dropdown-item noti-title">
                    <h5>
                        Notifications
                        @if(count($notifications) > 0)
                        <span class="badge bg-success float-end">{{ count($notifications) }}</span>
                        @endif
                    </h5>
                </div>
                
                <!-- Notifications List -->
                <div class="px-3 py-2" style="max-height: 350px; overflow-y: auto;" data-simplebar>
                    @if(count($notifications) > 0)
                    <small class="text-muted text-uppercase fw-semibold">Aujourd'hui</small>
                    @endif
                    
                    @forelse ($notifications as $notification)
                    <a href="{{ route('Dossier.show', $notification->dossier_id) }}" class="dropdown-item notify-item card">
                        <div class="card-body">
                            <div class="d-flex align-items-start">
                                <div class="flex-shrink-0">
                                    <div style="width: 36px; height: 36px; background: linear-gradient(135deg, #10b981, #059669); border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                                        <i class="uil uil-bell text-white"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="noti-item-title mb-1">
                                        {{ $notification->user->name }}
                                        <small class="text-muted fw-normal">{{ $notification->created_at->diffForHumans() }}</small>
                                    </h6>
                                    <p class="noti-item-subtitle mb-0">{{ Str::limit($notification->body, 60) }}</p>
                                </div>
                            </div>
                        </div>
                    </a>
                    @empty
                    <div class="text-center py-4">
                        <i class="uil uil-bell-slash text-muted" style="font-size: 40px;"></i>
                        <p class="text-muted mt-2 mb-0">Aucune notification</p>
                    </div>
                    @endforelse
                </div>

                <!-- View All Link -->
                <a href="{{ route('notification.index') }}" class="dropdown-item text-center notify-item border-top py-2">
                    <span class="text-primary fw-semibold">Voir toutes les notifications</span>
                </a>
            </div>
        </li>

        <!-- User Profile -->
        <li class="dropdown notification-list">
            <a class="nav-link dropdown-toggle nav-user arrow-none me-0" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                <span class="account-user-avatar">
                    <img src="https://www.w3schools.com/howto/img_avatar.png" alt="{{ auth()->user()->name }}">
                </span>
                <span>
                    <span class="account-user-name">{{ auth()->user()->name }}</span>
                    <span class="account-position">{{ auth()->user()->role->role }}</span>
                </span>
            </a>
            
            <div class="dropdown-menu dropdown-menu-end dropdown-menu-animated profile-dropdown">
                <a href="{{ route('user.profile') }}" class="dropdown-item">
                    <i class="uil uil-user"></i>
                    <span>Mon Profil</span>
                </a>
                <a href="{{ route('logout') }}" class="dropdown-item text-danger" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                    <i class="uil uil-sign-out-alt"></i>
                    <span>Déconnexion</span>
                </a>
                <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                    @csrf
                </form>
            </div>
        </li>
    </ul>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    var sidebarToggle = document.getElementById('sidebarToggle');
    var body = document.body;
    
    if (sidebarToggle) {
        sidebarToggle.addEventListener('click', function(e) {
            e.preventDefault();
            body.classList.toggle('sidebar-open');
        });
    }
    
    // Close sidebar when clicking overlay (on mobile)
    document.addEventListener('click', function(e) {
        if (body.classList.contains('sidebar-open')) {
            var sidebar = document.querySelector('.leftside-menu');
            var toggle = document.getElementById('sidebarToggle');
            
            if (sidebar && !sidebar.contains(e.target) && !toggle.contains(e.target)) {
                body.classList.remove('sidebar-open');
            }
        }
    });
    
    // Close sidebar on window resize to desktop
    window.addEventListener('resize', function() {
        if (window.innerWidth > 991) {
            body.classList.remove('sidebar-open');
        }
    });
});
</script>