@extends('layouts.dashboard.app')

@section('content')
    <div class="container-fluid ">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <h4 class="page-title" style="font-size: 25px">Liste des experts</h4>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="d-flex ">
                                <div class="col-md-6">
                                    <a style="float: left" href="{{ route('Expert.create') }}"
                                        class="btn btn-primary rounded-pill"> Créer </a>
                                </div>
                            </div>
                        </div>
                        <div class="table-responsive">
                        <table class="table table-striped" id="myTable">
                            <thead>
                                <tr>
                                    <th>Id</th>
                                    <th>Nom</th>
                                    <th>Email</th>
                                    <th>Adresse</th>
                                    <th>Telephone</th>
                                    {{-- <th>Afficher</th> --}}
                                    <th>Modifier</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($experts as $expert)
                                    <tr>
                                        <td>{{ $expert->id }}</td>
                                        <td>{{ $expert->name }}</td>
                                        <td>{{ $expert->email ?? null}}</td>
                                        <td>{{ $expert->adress ?? null }}</td>
                                        <td>{{ $expert->tel ?? null }}</td>
                                        {{-- @can('view', $expert)
                                        <td> <a class="btn btn-sm btn-info rounded-pill" href="{{ route('expert.show', [$expert->id]) }}"><i class="uil uil-eye fs-5"></i></a></td>
                                        @endcan --}}
                                        @can('update', $expert)
                                        <td> <a class="btn btn-sm btn-info rounded-pill" href="{{ route('Expert.edit', [$expert->id]) }}"><i class="uil uil-pen fs-5"></i></a></td>
                                        @endcan
                                    </tr>
                                    @empty
                                    <h3>Tableau Vide</h3>
                                @endforelse
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection

