@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Type Dossier</th>
                                        <th>Restaurer</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($TypeDossiers as $Typedossier)
                                        <tr>
                                            <td>{{ $Typedossier->id }}</td>
                                            <td>{{ $Typedossier->type }}</td>
                                            <td>
                                                <form action="{{ route('TypeDossier.restore', [$Typedossier->id]) }}"
                                                    method="post">
                                                    @csrf
                                                    <button class="btn btn-sm btn-warning rounded-pill" type="submit">
                                                        Restaurer
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
