@extends('layouts.auth')

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xxl-4 col-lg-5">
                <div class="card">

                    <!-- Logo -->
                    <div class="pt-4 text-center">
                        <a href="{{ route('login') }}">
                                <img class="img-fluid"  src="{{ asset('img/png.png') }}" alt="" width="390" height="170">
                        </a>
                    </div>

                    <div class="card-body p-4">

                        <form method="POST" action="{{ route('login') }}">

                            @csrf
                            <div class="mb-3">
                                <label for="email" class="form-label">Adresse Email</label>
                                <input class="form-control @error('email') is-invalid @enderror" type="email"
                                    id="email" name="email" value="{{ old('email') }}" required
                                    placeholder="Saisissez votre Email...">

                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="password" class="form-label">Mot de passe</label>

                                <input type="password" id="password" name="password"
                                    class="form-control  @error('password') is-invalid @enderror"
                                    placeholder="Saisissez votre mot de passe...">

                                @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="mb-3 mb-0 text-center">
                                <button class="btn btn-primary" type="submit"> Se connecter </button>
                            </div>

                        </form>
                    </div> <!-- end card-body -->
                </div>
                <!-- end card -->
            </div> <!-- end col -->
        </div>
        <!-- end row -->
    </div>
@endsection
