<div align="center">
	<p><img  src="art/header.jpg" alt="PowerGrid Logo"></p>
</div>

------

# How to contribute with ⚡ PowerGrid ⚡

Thank you for your interesting in contributing with PowerGrid.

If you have any questions, do not hesitate to reach the community in the repository [Discussions](https://github.com/Power-Components/livewire-powergrid/discussions) tab.

## Steps

1 .**Fork**

```shell
git clone https://github.com/Power-Components/livewire-powergrid.git && cd livewire-powergrid
```

Install all dependencies with composer and NPM.

```shell
composer install
```

Then run:

```shell
npm install
```

<br/>

2. **Create a new branch**

Create a new branch specifying `feature`, `fix`, `enhancement`.

```shell
git checkout -b feature/my-new-feature
```

<br/>

3. **Code and check your work**

Write your code and, when you are done, run the CS Fix:

```Shell
composer fix
```

Run tests and static analysis:

```Shell
composer check
```

<br/>

4. **Build Assets**

If you have updated or added JavaScript code, you need to recompile the assets and include it in your commit.

```Shell
npm run build
```

<br/>

5. **Tests**

Including tests is not mandatory, but if you can write tests, please consider doing it.

Besides all technical benefits, tests also help to prove your concept and make the maintainers' job easier. PowerGrid is developed entirely by volunteers.

<br/>


6. **Commit**

Please send clean and descriptive commits.

<br/>


7. **Pull Request**

Open a Pull Request (PR) and use the template for detailing your changes and motivations. Please make only one change per Pull Request.

If you never wrote a PR before, see this excellent [example](https://github.com/Power-Components/livewire-powergrid/pull/149) by [@vs0uz4](https://github.com/vs0uz4) for inspiration.

<br/>

 💓  Thank you for contributing!
