@extends('layouts.dashboard.app')
@section('style')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.4.0/min/dropzone.min.css">
    <link rel="stylesheet" href="{{ asset('css/viewer.css') }}">
    <style>
        * {
            box-sizing: border-box;
        }

        li {
            text-decoration: none;
        }

        /* Position the image container (needed to position the left and right arrows) */
        .container {
            position: relative;
        }

        /* Hide the images by default */
        .mySlides {
            display: none;
        }

        /* Add a pointer when hovering over the thumbnail images */
        .cursor {
            cursor: pointer;
        }

        /* Next & previous buttons */
        .prev,
        .next {
            cursor: pointer;
            position: absolute;
            top: 40%;
            width: auto;
            padding: 16px;
            margin-top: -50px;
            color: white;
            font-weight: bold;
            font-size: 20px;
            border-radius: 0 3px 3px 0;
            user-select: none;
            -webkit-user-select: none;
        }

        /* Position the "next button" to the right */
        .next {
            right: 0;
            border-radius: 3px 0 0 3px;
        }

        /* On hover, add a black background color with a little bit see-through */
        .prev:hover,
        .next:hover {
            background-color: rgba(0, 0, 0, 0.8);
        }

        /* Number text (1/3 etc) */
        .numbertext {
            color: #f2f2f2;
            font-size: 12px;
            padding: 8px 12px;
            position: absolute;
            top: 0;
        }

        /* Container for image text */
        .caption-container {
            text-align: center;
            background-color: #222;
            padding: 2px 16px;
            color: white;
        }

        .row:after {
            content: "";
            display: table;
            clear: both;
        }

        /* Six columns side by side */
        .column {
            float: left;
            width: 16.66%;
        }

        /* Add a transparency effect for thumnbail images */
        .demo {
            opacity: 0.6;
        }

        .active,
        .demo:hover {
            opacity: 1;
        }

        .container {
            position: relative;
            width: 33%;
        }

        .image {
            opacity: 1;
            display: block;
            width: 100%;
            height: auto;
            transition: .5s ease;
            backface-visibility: hidden;
        }

        .middle {
            transition: .5s ease;
            opacity: 0;
            position: absolute;
            top: 28%;
            left: 82%;
            transform: translate(-50%, -50%);
            -ms-transform: translate(-50%, -50%);
            text-align: center;
        }

        .container:hover .image {
            opacity: 0.8;
        }

        .container:hover .middle {
            opacity: 1;
        }

        .text {
            color: rgb(0, 0, 0);
            font-size: 16px;
        }
    </style>
@endsection
@section('content')
    <div class="container-fluid">
        <div class="row mt-2 mb-1">
            <div class="d-flex">
                <div class="col-md-6">
                    <h4 style="float: left" class="page-title">Dossier Details @if ($dossier->dossier_status_id === 1)
                            <span class="badge bg-danger">Anomalie</span>
                        @endif
                    </h4>
                </div>
                <div class="col-md-6">
                    <span style="float: right" class="badge bg-warning fs-5"> {{ $time->d }}j : {{ $time->h }}h
                    </span>
                    @if ($dossier->dossier_status_id != 3)
                        <span style="float: right" class="badge bg-danger fs-5">
                            {{ $timeleft }}H
                        </span>
                    @endif


                </div>
            </div>
        </div>
        <!-- end page title -->

        @include('dossiers.buttons')
        {{-- @include('document.modal') --}}


        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title text-dark mb-3">Réference Dossier {{ $dossier->ref }}
                            @if ($dossier->sinistre_douteux)
                                <span class="badge bg-warning">Sinistre Douteux</span>
                            @endif
                        </h4>
                        <h4 class="header-title text-info mb-3">
                            <span
                                class="badge bg-{{ $dossier->status->color ?? null }}">{{ $dossier->status->status ?? null }}</span>
                            @if ($dossier->dossier_status_id == 3)
                                <span class="badge bg-warning">Facturé</span>
                                <span class="badge bg-primary">{{ $dossier->date_facturation }}</span>
                            @endif
                        </h4>
                        <div class="table-responsive">
                            <table class="table mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Matricule </th>
                                        <th>Matricule WW</th>
                                        <th>Date Sinistre</th>
                                        <th>Compagnie</th>
                                        <th>Garantie</th>
                                        <th>Type de Dossier</th>
                                        <th>Mode</th>
                                        <th>Etape Courante </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <input type="hidden" value="{{ $dossier->id }}" id="id">
                                        <td class="text-dark">{{ $dossier->matricule ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->new_matricule ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->date_sinistre ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->company->company ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->guarantee->guarantee ?? null }}</td>
                                        <td> <span
                                                class="badge badge-primary-lighten">{{ $dossier->typeexpertise->type ?? null }}</span>
                                        </td>
                                        <td> <span
                                                class="badge badge-dark-lighten">{{ $dossier->mode->mode ?? null }}</span>
                                        </td>

                                        <td>
                                            <span class="badge bg-success">
                                                {{ $dossier->currentStep->step ?? null }}
                                            </span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <!-- end table-responsive -->
                    </div>
                </div>
            </div> <!-- end col -->


        </div>
        <!-- end row -->
        <div class="row mt-3">
            {{-- <div class="col-6">
                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title  text-dark mb-3">Assuré</h4>
                        <div class="table-responsive">
                            <table class="table mb-0 ">
                                <thead class="table-light">
                                    <tr>
                                        <th>Civilité</th>
                                        <th>Nom </th>
                                        <th>Telephone</th>
                                        <th>Garage</th>
                                        <th>Vehicule</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>{{ $dossier->insured->civility ?? null }}</td>
                                        <td>{{ $dossier->insured->name ?? null }}</td>
                                        <td>{{ $dossier->insured->telephone ?? null }}</td>
                                        <td>{{ $dossier->garage->libelle ?? null }}</td>
                                        <td>{{ $dossier->typevehicule->type ?? null }}/{{ $dossier->vehiculemodel->name ?? null }}/{{ $dossier->vehiculemodel->brand->brand ?? null }}
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <!-- end table-responsive -->
                        <!-- end col -->
                    </div>
                </div>
            </div> --}}
            <div class="col-md-6">
                {{-- <h2>Key-Value Table using Bootstrap</h2> --}}
                <div class="card">
                    <div class="card-body">
                        <h3 class="header-title  text-primary mb-3">Détail :</h3>

                        <table class="table table-bordered">
                            {{-- <thead>
                                <tr>
                                    Assuré
                                </tr>
                            </thead> --}}
                            <tbody>
                                <tr>
                                    <td class="text-dark">Nom :</td>
                                    <td class="text-dark">{{ $dossier->insured->civility ?? null }} :
                                        {{ $dossier->insured->name ?? null }}</td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Telephone :</td>
                                    <td class="text-dark">{{ $dossier->insured->telephone ?? null }}</td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Vehicule :</td>
                                    <td class="text-dark">
                                        {{ $dossier->typevehicule->type ?? null }}/{{ $dossier->vehiculemodel->name ?? null }}/{{ $dossier->vehiculemodel->brand->brand ?? null }}
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Intermidiaire :</td>
                                    <td class="text-dark">{{ $dossier->intermidiaire->company ?? null }}</td>
                                </tr>
                                {{-- <tr>
                                    <td class="text-dark">Date Sinistre :</td>
                                    <td class="text-dark">{{ $dossier->date_sinistre ?? null }}</td>

                                </tr> --}}
                                <tr>
                                    <td class="text-dark">Numero Sinistre :</td>
                                    <td class="text-dark">{{ $dossier->numero_sinistre ?? null }}</td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Numero chassis :</td>
                                    <td class="text-dark">{{ $dossier->numero_chassis ?? null }}</td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Numero Police :</td>
                                    <td class="text-dark">{{ $dossier->numero_police ?? null }}</td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Numero Attestation :</td>
                                    <td class="text-dark">{{ $dossier->numero_attestation ?? null }}</td>
                                </tr>
                                <tr>
                                    <td class="text-dark">DMC :</td>
                                    <td class="text-dark">{{ $dossier->date_circulation ?? null }}</td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Ville :</td>
                                    <td class="text-dark">{{ $dossier->city->city ?? null }}</td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Devise :</td>
                                    <td class="text-dark">{{ $dossier->currency->name ?? null }}</td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Garage :</td>
                                    <td class="text-dark">{{ $dossier->garage->libelle ?? null }}</td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Kilométrage :</td>
                                    <td class="text-dark">{{ $dossier->kilometrage ?? null }}</td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Puissance Fiscale :</td>
                                    <td class="text-dark">{{ $dossier->puissance_fiscale ?? null }}</td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Carburant :</td>
                                    <td class="text-dark">{{ $dossier->carburant->name ?? null }}</td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Date Réception</td>
                                    <td class="text-dark">{{ $dossier->date_reception ?? null }}</td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Date Creation</td>
                                    <td class="text-dark">{{ $dossier->created_at->format('Y-m-d') ?? null }}</td>
                                </tr>

                                <tr>
                                    <td class="text-dark">Montant Accord Adverse</td>
                                    <td class="text-dark">{{ $dossier->montant_accord_adverse ?? 0 }}
                                        {{ $dossier->currency->symbole ?? null }}</td>                                </tr>
                                <!-- Add more rows as needed -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- end col -->
            @include('dossiers.box')
        </div>
        <div class="row">

            <div class="col-lg-6">
                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title text-dark mb-3">Adversaire</h4>
                        <div class="table-responsive">
                            <table class="table mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Civilité</th>
                                        <th>Nom Complet</th>
                                        <th>Matricule</th>
                                        <th>Telephone</th>
                                        <th>Marque && Vehicule</th>
                                        <th>Compagnie</th>
                                        <th>Numero Police</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>{{ $dossier->opponent->civility ?? null }}</td>
                                        <td>{{ $dossier->opponent->name ?? null }}</td>
                                        <td>{{ $dossier->opponent->matricule ?? null }}</td>
                                        <td>{{ $dossier->opponent->telephone ?? null }}</td>
                                        <td>{{ $dossier->opponent->vehiculemodel->brand->brand ?? null }}{{ $dossier->opponent->vehiculemodel->name ?? null }}
                                        </td>
                                        <td>{{ $dossier->opponent->company->company ?? null }}</td>
                                        <td>
                                            {{ $dossier->opponent->numero_attestation ?? null }}
                                        </td>
                                    </tr>
                                    </form>
                                </tbody>

                            </table>

                        </div>
                    </div>
                </div>
            </div> <!-- end col -->
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title text-dark mb-3">Valeurs :</h4>
                        <div class="table-responsive">
                            <table class="table mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Type</th>
                                        <th>Valeur A Neuf</th>
                                        <th>Hors Sinistre</th>
                                        <th>Valeur Définitive </th>
                                        <th>Valeur Epave</th>
                                        <th>Valeur Vénale</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>HT</td>
                                        <td>{{ $dossier->valeurneuf ?? 0 }} {{ $dossier->currency->symbole ?? null }}</td>
                                        <td>{{ $dossier->horssinistre ?? 0 }} {{ $dossier->currency->symbole ?? null }}
                                        </td>
                                        <td>{{ $dossier->valeuradire ?? 0 }} {{ $dossier->currency->symbole ?? null }}
                                        </td>
                                        <td>{{ $dossier->valeurepave ?? 0 }} {{ $dossier->currency->symbole ?? null }}
                                        </td>
                                        <td>{{ $dossier->valeurvenale ?? 0 }} {{ $dossier->currency->symbole ?? null }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>TTC</td>
                                        <td>{{ $dossier->valeurneuf_ttc ?? 0 }} {{ $dossier->currency->symbole ?? null }}
                                        </td>
                                        <td>{{ $dossier->horssinistre_ttc ?? 0 }}
                                            {{ $dossier->currency->symbole ?? null }}
                                        </td>
                                        <td>{{ $dossier->valeuradire_ttc ?? 0 }} {{ $dossier->currency->symbole ?? null }}
                                        </td>
                                        <td>{{ $dossier->valeurepave_ttc ?? 0 }} {{ $dossier->currency->symbole ?? null }}
                                        </td>
                                        <td>{{ $dossier->valeurvenale_ttc ?? 0 }}
                                            {{ $dossier->currency->symbole ?? null }}
                                        </td>
                                    </tr>
                                    </form>
                                </tbody>

                            </table>

                        </div>
                    </div>
                </div>
            </div>

        </div>

        {{-- <div class="row">
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Devise</th>
                                        <th>Ville</th>
                                        <th>DMC</th>
                                        <th>Num Sinistre </th>
                                        <th>Num Chassis</th>
                                        <th>Num Attestation</th>
                                        <th>Num Police</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td class="text-dark">{{ $dossier->currency->name ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->city->city ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->date_circulation ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->numero_sinistre ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->numero_chassis ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->numero_attestation ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->numero_police ?? null }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <!-- end table-responsive -->
                    </div>
                </div>
            </div> <!-- end col -->


        </div> --}}

        {{-- <div class="row mt-3">

        </div> --}}
        <div class="row mt-3">
            <!-- end col -->
        </div>
        @if ($montant)
            <div class="row mt-2">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="header-title mb-3 text-dark">Montant</h4>
                            <div class="table-responsive">
                                <table class="table mb-0">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Montant Devis</th>
                                            <th>Montant Accord</th>
                                            <th>Montant Facture</th>
                                            <th>Montant Rapport</th>
                                            @if (Auth::user()->role_id == 4)
                                                <th>Modifier</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>{{ $montant->devis->montant_devis ?? 0 }}
                                                {{ $dossier->currency->symbole ?? null }}</td>
                                            <td>{{ $montant->montant_accord ?? 0 }}
                                                {{ $dossier->currency->symbole ?? null }}</td>
                                            <td>{{ $montant->facture->montant_facture ?? 0 }}
                                                {{ $dossier->currency->symbole ?? null }}</td>
                                            <td>{{ $montant->montant_rapport ?? 0 }}
                                                {{ $dossier->currency->symbole ?? null }}</td>

                                            @if (Auth::user()->role_id == 4)
                                                <td>
                                                    <a href="{{ route('Montant.edit', $montant->id) }}"
                                                        class="action-icon text-primary">
                                                        <i class="mdi mdi-square-edit-outline"></i>
                                                    </a>
                                                </td>
                                            @endif
                                        </tr>
                                    </tbody>

                                </table>

                            </div>
                        </div>
                    </div> <!-- end col -->
                </div>
            </div>
        @endif
        <div class="row mt-2">
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-body">
                        <form method="POST" action="{{ route('Observation.store') }}">
                            @csrf
                            <h4 class="header-title mb-3" style="color: black">Observation</h4>
                            @if ($observations)
                                <div class="accordion" id="">
                                    @foreach ($observations as $key => $observation)
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingOne" style="margin-top: unset;">
                                                <button class="accordion-button collapsed" type="button"
                                                    data-bs-toggle="collapse"
                                                    data-bs-target="#collapse-{{ $key }}" aria-expanded="false"
                                                    aria-controls="">
                                                    {{ $observation->user->name }}
                                                </button>
                                            </h2>
                                            <div id="collapse-{{ $key }}" class="accordion-collapse collapse "
                                                aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                                <div class="accordion-body">
                                                    <strong class="text-dark">{{ $observation->observation }}.</strong>
                                                    <span>{{ $observation->created_at }}</span>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif

                            <div class="col-md-12 mt-1 ml-3">
                                <input type="hidden" name="dossier_id" value="{{ $dossier->id }}">
                                <textarea name="observation" class="form-control @error('observation') is-invalid @enderror mb-2" id="observation"
                                    cols="30" rows="10"></textarea>
                                @error('observation')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                                <button class="mt-2 btn btn-info">Créer</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>


            <div class="col-lg-6">
                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title mb-3" style="color: black">Point de chock</h4>
                        @forelse ($dossier->shockpoint as $point)
                            <span class="fs-5 badge  bg-warning">{{ $point->point }}</span>
                        @empty
                            @can('update', $dossier)
                                <a href="{{ route('ShockPoint.create', $dossier->id) }}" class="btn btn-danger">Créer</a>
                            @endcan
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
        @if ($historiques)
            <div class="row mt-2">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="header-title mb-3 text-dark">Historique Vehicule</h4>
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Ref</th>
                                            <th>Compagnie</th>
                                            <th>Matricule WW</th>
                                            <th>Matricule</th>
                                            <th>Assuré</th>
                                            <th>Date sinistre</th>
                                            <th>Status</th>
                                            <th>Detail</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($historiques as $dossier)
                                            <tr>
                                                <td>{{ $dossier->ref ?? null }}</td>
                                                <td>{{ $dossier->company->company ?? null }}</td>
                                                <td>{{ $dossier->new_matricule ?? null }}</td>
                                                <td>{{ $dossier->matricule ?? null }}</td>
                                                <td>{{ $dossier->insured->name ?? null }}</td>
                                                <td>{{ $dossier->date_sinistre ?? null }}</td>

                                                <td>
                                                    <span class="badge bg-{{ $dossier->status->color ?? null }}">
                                                        {{ $dossier->status->status ?? null }}</span>
                                                </td>
                                                <td>
                                                    <a href="{{ route('Dossier.show', $dossier->id) }}">
                                                        <i class="mdi mdi-eye"></i></a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>
    </div>

    </div>
    @include('document.modal')
@endsection
