@extends('layouts.dashboard.app')

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <h4 class="page-title text-dark">Dossier </h4>
                </div>
            </div>
        </div>

        <div class="row m-1">
            <div class="col-12">
                <form action="{{ route('Dossier.archiveSearch') }}" method="post">
                    @csrf
                    <div class="row no-gutters">
                        <div class="col-sm-3 col-md-3 col-sm-12 p-0">
                            <select name="type" class="form-control" id="exampleFormControlSelect1">
                                <option value="1">Matricule</option>
                                <option value="2">Nom</option>
                                <option value="3">Réference</option>
                                <option value="4">N Sinistre</option>

                            </select>
                        </div>
                        <div class="col-sm-8 col-md-6 col-sm-12 p-0">
                            <input type="text" placeholder="Search..." class="form-control" id="search"
                                name="search">
                        </div>
                        <div class="col-sm-1 col-md-3 col-sm-12 p-0">
                            <button type="submit" class="btn btn-sm btn-primary">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                    fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round" class="feather feather-search">
                                    <circle cx="11" cy="11" r="8"></circle>
                                    <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
                                </svg>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div class="table-responsive">

            <table class="table table-stripped" id="myTable">
                <thead class="table-light">
                    <tr>
                        
                        <th>Reference Dossier</th>
                        <th>Compagnie</th>
                        <th>Assuré</th>
                        <th>Matricule</th>
                        <th>Nature De Dossier</th>
                        <th>Date de Sinistre</th>
                        <th>Etape</th>
                        <th>Status</th>

                        <th style="width: 125px;">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($dossiers as $dossier)
                        <tr>
                            
                        
                            <td style="color: black; font-weight:bold">
                                {{ $dossier->ref }}
                            </td>
                            <td>
                                {{ $dossier->company->company ?? null }}
                            </td>

                            <td>
                                <h5>
                                    {{ $dossier->insured->name ?? null }}
                                </h5>
                            </td>
                            <td>
                                {{ $dossier->matricule ?? null }}
                            </td>
                            <td>
                                <span class="badge bg-info fs-5">{{ $dossier->typeexpertise->type ?? '' }}</span>
                            </td>
                            <td>
                                {{ $dossier->date_sinistre ?? null }}
                            </td>
                            <td>
                                <span class="badge bg-dark">
                                    {{ $dossier->currentStep->step }}
                                </span>
                            </td>
                            <td>
                                <span class="badge bg-{{ $dossier->status->color }}">
                                    {{ $dossier->status->status }}
                                </span>
                            </td>
                            <td>
                                @can('view', $dossier)
                                    <a href="{{ route('Dossier.show', $dossier->id) }}" class="action-icon text-dark"> <i
                                            class="mdi mdi-eye"></i></a>
                                @endcan
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

           
        </div>
        <br>
    </div> <!-- end card-body-->
@endsection
