@extends('layouts.dashboard.app')

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12 mb-2">
                <div class="page-title-box">
                    @can('create', App\Models\Devis::class)
                        <div class="page-title-right">
                            <a href="{{ route('Devis.create', $id) }}" class="btn btn-outline-primary">Créer Un Devis</a>
                        </div>
                    @endcan

                    <div class="page-title-left ">
                        <a href="{{ route('Dossier.show', $id) }}" class="mt-2 btn btn-outline-dark">Dossier</a>
                    </div>

                </div>
            </div>
        </div>
        <div class="table-responsive">
            <table class="table table-stripped" id="myTable">
                <thead class="table-light">
                    <tr>
                        <th style="width: 20px;">
                            <div class="form-check">
                                <input type="checkbox" class="form-check-input" id="customCheck1">
                                <label class="form-check-label" for="customCheck1">&nbsp;</label>
                            </div>
                        </th>
                        <th>Id</th>
                        <th>Dossier</th>
                        <th>Montant Devis</th>
                        <th>Status</th>
                        <th>Document</th>
                        @can('view', App\Models\Devis::class)
                            <th style="width: 125px;">Afficher</th>
                        @endcan
                        @can('delete', App\Models\Devis::class)
                            <th> Action</th>
                        @endcan

                    </tr>
                </thead>
                <tbody>
                    @foreach ($deviss as $devis)
                        <tr>
                            <td>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" id="customCheck2">
                                    <label class="form-check-label" for="customCheck2">&nbsp;</label>
                                </div>
                            </td>
                            <td style="color: black; font-weight:bold">
                                {{ $devis->id ?? null }}
                            </td>
                            <td>
                                {{ $devis->dossier->ref ?? null }}
                            </td>
                            <td>
                                {{ $devis->montant_devis ?? null }}
                            </td>
                            <td>
                                <span class="badge bg-{{ $devis->status->color }} fs-5">{{ $devis->status->status }}</span>
                            </td>
                            @if ($devis->devis_status_id == 2 || $devis->devis_status_id == 7)
                                <td>
                                    <a href="{{ route('pdf.accord', $devis->id) }}" target="_blank" class="btn btn-outline-primary">Accord Devis
                                    </a>
                                </td>
                            @endif
                            @can('view', App\Models\Devis::class)
                                <td>
                                    <a href="{{ route('Devis.show', $devis->id) }}" class="action-icon text-success"> <i
                                            class="mdi mdi-eye"></i></a>
                                </td>
                            @endcan
                            @can('delete', App\Models\Devis::class)
                                @if ($devis->devis_status_id == 4 || $devis->devis_status_id == 9)
                                    <td>
                                        <form action="{{ route('Devis.destroy', $devis->id) }}" method="post">
                                            @csrf
                                            @method('DELETE')
                                            <button class="btn btn-sm btn-danger rounded-pill" type="submit">
                                                <i class="uil uil-trash fs-5"></i>
                                            </button>
                                        </form>

                                    </td>
                                @endif
                            @endcan

                        </tr>
                    @endforeach

                </tbody>
            </table>
        </div>
    </div> <!-- end card-body-->
    </div> <!-- end card-->
    </div> <!-- end col -->
    </div>

    </div>

    </div>



    </div>

    </div>
@endsection
