<html>

<head>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-rbsA2VBKQhggwzxH7pPCaAqO46MgnOM80zW1RWuH61DGLwZJEdK2Kadq2F9CUG65" crossorigin="anonymous">
    <title> OpenTok Getting Started </title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <style>
        body,
        html {
            background-color: gray;
            height: 100%;
        }

        #videos {
            position: relative;
            width: 100%;
            height: 100%;
            margin-left: auto;
            margin-right: auto;
            padding-bottom: 20px
        }

        #subscriber {
            position: absolute;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            z-index: 10;
        }



        #publisher {
            position: absolute;
            width: 360px;
            height: 240px;
            bottom: 10px;
            left: 10px;
            z-index: 100;
            border: 3px solid white;
            border-radius: 3px;
        }
    </style>
    <script src="https://static.opentok.com/v2/js/opentok.min.js"></script>
</head>

<body>

    <?php if(auth()->guard()->check()): ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('screen', App\Models\Call::class)): ?>
            <div class="row">
                <div class="col-6">
                    <button type="button" id="capture" class="btn btn-success">Screen</button>
                </div>
                <div class="col-6">
                    <form method="POST" enctype="multipart/form-data" action="<?php echo e(route('call.screen',$dossier_id)); ?>" id="myForm">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="img" id="img_val" value="" />
                        <button style="float: right" id="btn" class="btn btn-danger mr-2">Leave Call</button>
                    </form>
                </div>
            </div>
        <?php endif; ?>
    <?php endif; ?>
    <input type="hidden" name="" id="dossier_id" value="<?php echo e($dossier_id); ?>">
    <div id="videos">
        
        <div id="subscriber"></div>
        <div id="publisher"></div>
    </div>
    <?php if(auth()->guard()->check()): ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', App\Models\Call::class)): ?>
            <button id="btnStart">START RECORDING</button>
            <br />
            <button id="btnStop">STOP RECORDING</button></p>
        <?php endif; ?>
        <input id="file" type="hidden" name="video">
        <div class="recorded-video-wrap">
            <video style="display: none" id="video" controls></video>
            <video style="display: none" src="" id="recorded-video" controls></video>
        <?php endif; ?>

        <script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.5/jquery.min.js"></script>
        <script type="text/javascript" src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>

        <script type="text/javascript">
            var session;
            var connectionCount = 0;
            var apiKey = "<?php echo e(env('VONAGE_API_KEY')); ?>";
            var sessionId = "<?php echo e($sessionId); ?>";
            var token = "<?php echo e($token); ?>";
            var publisher;

            function disconnect() {
                session.forceDisconnect(connection);

            }

            function connect() {
                // Replace apiKey and sessionId with your own values:
                session = OT.initSession(apiKey, sessionId);
                session.on("streamCreated", function(event) {
                    console.log("New stream in the session: " + event.stream.streamId);
                    session.subscribe(event.stream, 'subscriber', {
                        insertMode: 'append',
                        width: '100%',
                        height: '100%'
                    });
                });
                session.on({
                    connectionCreated: function(event) {
                        connectionCount++;
                        // alert(connectionCount + ' connections.');
                    },
                    connectionDestroyed: function(event) {
                        connectionCount--;
                        // alert(connectionCount + ' connections.');
                    },
                    sessionDisconnected: function sessionDisconnectHandler(event) {
                        // The event is defined by the SessionDisconnectEvent class
                        alert('Disconnected from the session.');
                        document.getElementById('disconnectBtn').style.display = 'none';
                        if (event.reason == 'networkDisconnected') {
                            alert('Your network connection terminated.')
                        }
                    }
                });
                var publisher = OT.initPublisher('publisher', {
                    insertMode: 'append',
                    width: '100%',
                    height: '100%'
                }, error => {
                    if (error) {
                        alert(error.message);
                    }
                });

                // Replace token with your own value:
                session.connect(token, function(error) {
                    if (error) {
                        alert('Unable to connect: ', error.message);
                    } else {
                        // document.getElementById('disconnectBtn').style.display = 'block';
                        // alert('Connected to the session.');
                        connectionCount = 1;
                        if (session.capabilities.publish == 1) {
                            session.publish(publisher);
                        } else {
                            alert("You cannot publish an audio-video stream.");
                        }
                    }
                });
            }

            connect();
            let stream = null,
                audio = null,
                mixedStream = null,
                chunks = [],
                recorder = null
            startButton = null,
                stopButton = null,
                downloadButton = null,
                input = null,
                recordedVideo = null;

            async function setupStream() {
                try {
                    stream = await navigator.mediaDevices.getDisplayMedia({
                        video: true
                    });

                    audio = await navigator.mediaDevices.getUserMedia({
                        audio: {
                            echoCancellation: true,
                            noiseSuppression: true,
                            sampleRate: 44100,
                        },
                    });

                    setupVideoFeedback();
                } catch (err) {
                    console.error(err)
                }
            }

            function setupVideoFeedback() {
                if (stream) {
                    const video = document.querySelector('#video');

                    video.srcObject = stream;
                    video.play();
                } else {
                    console.warn('No stream available');
                }
            }
            function Toggle(){
                publisher.cycleVideo().then(console.log);

            }

            async function startRecording() {
                await setupStream();

                if (stream && audio) {
                    mixedStream = new MediaStream([...stream.getTracks(), ...audio.getTracks()]);
                    recorder = new MediaRecorder(mixedStream);
                    recorder.ondataavailable = handleDataAvailable;
                    recorder.onstop = handleStop;
                    recorder.start(1000);

                    startButton.disabled = true;
                    stopButton.disabled = false;

                    console.log('Recording started');
                } else {
                    console.warn('No stream available.');
                }
            }

            function stopRecording() {
                recorder.stop();

                startButton.disabled = false;
                stopButton.disabled = true;
            }

            function handleDataAvailable(e) {
                chunks.push(e.data);
            }

            function handleStop(e) {
                const blob = new Blob(chunks, {
                    'type': 'video/mp4'
                });
                chunks = [];
                console.log(recordedVideo.src);

                recordedVideo.src = URL.createObjectURL(blob);
                recordedVideo.load();
                const formData = new FormData();
                var dossier_id = document.getElementById('dossier_id').value;
                console.log(dossier_id);

                formData.append('video', blob);
                fetch('http://127.0.0.1:8000/Call/store/'+dossier_id, {

                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        body: formData
                    })
                    .then(response => {
                        console.log('upload success');
                    })
                    .catch(error => {
                        console.log('error');
                    });
                recordedVideo.onloadeddata = function() {
                    const rc = document.querySelector(".recorded-video-wrap");
                    rc.classList.remove("hidden");
                    rc.scrollIntoView({
                        behavior: "smooth",
                        block: "start"
                    });
                    recordedVideo.play();
                }

                stream.getTracks().forEach((track) => track.stop());
                audio.getTracks().forEach((track) => track.stop());

                console.log('Recording stopped');
            }

            window.addEventListener('load', () => {
                startButton = document.querySelector('#btnStart');
                stopButton = document.querySelector('#btnStop');
                input = document.querySelector('#file');
                recordedVideo = document.querySelector('#recorded-video');

                startButton.addEventListener('click', startRecording);
                stopButton.addEventListener('click', stopRecording);
            })
        </script>
               <script type="text/javascript">
                var items = [];
                $('#capture').click(function() {
                    const screenshotTarget = document.getElementById('videos');
                    html2canvas(screenshotTarget).then(canvas => {

                        //Set hidden field's value to image data (base-64 string)
                        // fill a input array

                        var item = canvas.toDataURL("image/png", 1)
                        items.push(item);
                        $('#img_val').val(items);
                        console.log(items);
                        console.log($('#img_val').val());

                        //Submit the form manually

                    });
                });
                $('#btn').click(function() {
                    document.getElementById("myForm").submit();
                });
            </script>
</body>

</html>
<?php /**PATH C:\laragon\www\AMEA\resources\views/call/class.blade.php ENDPATH**/ ?>