
<?php $__env->startSection('style'); ?>
    <style>
        #description {
            font-family: Roboto;
            font-size: 15px;
            font-weight: 300;
        }

        #infowindow-content .title {
            font-weight: bold;
        }

        #infowindow-content {
            display: none;
        }

        #map #infowindow-content {
            display: inline;
        }

        .pac-card {
            background-color: #fff;
            border: 0;
            border-radius: 2px;
            box-shadow: 0 1px 4px -1px rgba(0, 0, 0, 0.3);
            margin: 10px;
            padding: 0 0.5em;
            font: 400 18px Roboto, Arial, sans-serif;
            overflow: hidden;
            font-family: Roboto;
            padding: 0;
        }

        #pac-container {
            padding-bottom: 12px;
            margin-right: 12px;
        }

        .pac-controls {
            display: inline-block;
            padding: 5px 11px;
        }

        .pac-controls label {
            font-family: Roboto;
            font-size: 13px;
            font-weight: 300;
        }

        #pac-input {
            background-color: #fff;
            font-family: Roboto;
            font-size: 15px;
            font-weight: 300;
            margin-left: 12px;
            padding: 0 11px 0 13px;
            text-overflow: ellipsis;
            width: 400px;
        }

        #pac-input:focus {
            border-color: #4d90fe;
        }

        #title {
            color: #fff;
            background-color: #4d90fe;
            font-size: 25px;
            font-weight: 500;
            padding: 6px 12px;
        }

        #target {
            width: 345px;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-md-12 ">
                <h3>Localisation :</h3>
                <hr>
                <input id="pac-input" class="controls" type="text" placeholder="Search Box" />
                <div id="map" class="gmaps" style="height: 100vh">
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="https://maps.googleapis.com/maps/api/js?key=<?php echo e(env('GOOGLE_MAP_KEY')); ?>&callback=initAutocomplete" async
        defer></script>
    <script>
        function initAutocomplete() {
            const map = new google.maps.Map(document.getElementById("map"), {
                center: {
                    lat: 33.37562245379103,
                    lng: -7.579586521130635
                },
                zoom: 13,
                mapTypeId: "roadmap",
            });
            const uluru = {
                lat: 33.37562245379103,
                lng: -7.579586521130635
            };
            let marker = new google.maps.Marker({
                position: uluru,
                map: map,
                draggable: true
            });
            // google.maps.event.addListener(marker, 'position_changed',
            //     function() {
            //         let lat = marker.position.lat()
            //         let lng = marker.position.lng()
            //         $('#lat').val(lat)
            //         $('#lng').val(lng)
            //     })

            // google.maps.event.addListener(map, 'click',
            //     function(event) {
            //         pos = event.latLng
            //         marker.setPosition(pos)
            //     })
            // // Create the search box and link it to the UI element.
            // const input = document.getElementById("pac-input");
            // const searchBox = new google.maps.places.SearchBox(input);

            // map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);
            // // Bias the SearchBox results towards current map's viewport.
            // map.addListener("bounds_changed", () => {
            //     searchBox.setBounds(map.getBounds());
            // });

            let markers = [];

            // Listen for the event fired when the user selects a prediction and retrieve
            // more details for that place.
            // searchBox.addListener("places_changed", () => {
            //     const places = searchBox.getPlaces();

            //     if (places.length == 0) {
            //         return;
            //     }

            //     // Clear out the old markers.
            //     markers.forEach((marker) => {
            //         marker.setMap(null);
            //     });
            //     markers = [];

            //     // For each place, get the icon, name and location.
            //     const bounds = new google.maps.LatLngBounds();

            //     places.forEach((place) => {
            //         if (!place.geometry || !place.geometry.location) {
            //             console.log("Returned place contains no geometry");
            //             return;
            //         }

            //         const icon = {
            //             url: place.icon,
            //             size: new google.maps.Size(71, 71),
            //             origin: new google.maps.Point(0, 0),
            //             anchor: new google.maps.Point(17, 34),
            //             scaledSize: new google.maps.Size(25, 25),
            //         };


            //         // Create a marker for each place.
            //         markers.push(
            //             new google.maps.Marker({
            //                 map,
            //                 icon,
            //                 title: place.name,
            //                 position: place.geometry.location,
            //             })
            //         );
            //         if (place.geometry.viewport) {
            //             // Only geocodes have viewport.
            //             bounds.union(place.geometry.viewport);
            //         } else {
            //             bounds.extend(place.geometry.location);
            //         }
            //     });
            //     map.fitBounds(bounds);

            // });
            setMarkers(map);
            setMarkers2(map);
        }

        window.initAutocomplete = initAutocomplete;

        const locations = <?php print json_encode($markers); ?>;
        const image1 = "<?php print asset('img/car.png'); ?>";
         console.log(locations);
        function setMarkers(map) {

            for (let i = 0; i < locations.length; i++) {
                const location = locations[i];

                new google.maps.Marker({
                    position: {
                        lat: parseFloat(location.lat),
                        lng: parseFloat(location.lng)
                    },
                    label: {
                        color: 'black',
                        fontWeight: 'bold',
                        text: location.libelle,
                    },
                    icon: {
                        url: image1,
                        size: new google.maps.Size(36, 50),
                        scaledSize: new google.maps.Size(36, 50),
                        anchor: new google.maps.Point(0, 50),
                        labelOrigin: new google.maps.Point(9, 8)

                    },
                    map,
                    title: location.libelle,
                    zIndex: location.lng,
                });

                // console.log(locations[i]);
            }
        }
        const Alocations = <?php print json_encode($agents); ?>;
        console.log(Alocations);
        const image =
            "https://upload.wikimedia.org/wikipedia/commons/thumb/5/59/User-avatar.svg/1200px-User-avatar.svg.png";

        function setMarkers2(map) {

            for (let i = 0; i < Alocations.length; i++) {
                const location = Alocations[i];

                new google.maps.Marker({
                    position: {
                        lat: parseFloat(location.lat),
                        lng: parseFloat(location.lng)
                    },
                    label: {
                        color: 'black',
                        fontWeight: 'bold',
                        text: location.user.name,

                    },
                    icon: {
                        url: image,
                        size: new google.maps.Size(36, 50),
                        scaledSize: new google.maps.Size(36, 50),
                        anchor: new google.maps.Point(0, 50),
                        labelOrigin: new google.maps.Point(9, 8)

                    },
                    map,
                    zIndex: location.lng,
                });

                //console.log(locations[i]);
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/admin/public_html/engi.ameamaroc.ma/resources/views/configuration/location/index.blade.php ENDPATH**/ ?>