<html>

<head>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-rbsA2VBKQhggwzxH7pPCaAqO46MgnOM80zW1RWuH61DGLwZJEdK2Kadq2F9CUG65" crossorigin="anonymous">
    <title> OpenTok Getting Started </title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <style>
        body,
        html {
            background-color: gray;
            height: 100%;
        }

        #videos {
            position: relative;
            width: 100%;
            height: 100%;
            margin-left: auto;
            margin-right: auto;
            padding-bottom: 20px
        }

        #subscriber {
            position: absolute;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            z-index: 10;
        }



        #publisher {
            position: absolute;
            width: 360px;
            height: 240px;
            bottom: 10px;
            left: 10px;
            z-index: 100;
            border: 3px solid white;
            border-radius: 3px;
        }
    </style>
    
</head>

<body>

    <?php if(auth()->guard()->check()): ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('screen', App\Models\Call::class)): ?>
            <div class="row">
                <div class="col-6">
                    <button type="button" id="capture" class="btn btn-success">Screen</button>
                </div>
                <div class="col-6">
                    <form method="POST" enctype="multipart/form-data" action="<?php echo e(route('call.screen', $dossier_id)); ?>"
                        id="myForm">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="img" id="img_val" value="" />
                        <button style="float: right" id="btn" class="btn btn-danger mr-2">Leave Call</button>
                    </form>
                </div>
            </div>
        <?php endif; ?>
    <?php endif; ?>


    <iframe width="1000" height="700"
        src="https://engi.whereby.com/1022ebdd-df66-4a34-ad9f-54a95f646942?roomKey=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJtZWV0aW5nSWQiOiI3OTA0NjI4OCIsInJvb21SZWZlcmVuY2UiOnsicm9vbU5hbWUiOiIvMTAyMmViZGQtZGY2Ni00YTM0LWFkOWYtNTRhOTVmNjQ2OTQyIiwib3JnYW5pemF0aW9uSWQiOiIxOTY2MzIifSwiaXNzIjoiaHR0cHM6Ly9hY2NvdW50cy5zcnYud2hlcmVieS5jb20iLCJpYXQiOjE2OTgxMzkwNDQsInJvb21LZXlUeXBlIjoibWVldGluZ0hvc3QifQ.A87RJy29FSd9ITnEoWqDgvaktmdGJvCemAaHgyEJfZ4"
        allow="camera; microphone; fullscreen; speaker; display-capture; autoplay; compute-pressure"></iframe>
    
    
    <?php if(auth()->guard()->check()): ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', App\Models\Call::class)): ?>
            <button id="btnStart">START RECORDING</button>
            <br />
            <button id="btnStop">STOP RECORDING</button></p>
        <?php endif; ?>
        <input id="file" type="hidden" name="video">
        <div class="recorded-video-wrap">
            <video style="display: none" id="video" controls></video>
            <video style="display: none" src="" id="recorded-video" controls></video>
        </div>
    <?php endif; ?>

    <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.5/jquery.min.js"></script>
    <script type="text/javascript" src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>
    
    <script type="text/javascript">
        window.addEventListener('load', () => {
            startButton = document.querySelector('#btnStart');
            stopButton = document.querySelector('#btnStop');
            input = document.querySelector('#file');
            recordedVideo = document.querySelector('#recorded-video');

            startButton.addEventListener('click', startRecording);
            stopButton.addEventListener('click', stopRecording);
        })

        async function startRecording() {
            await setupStream();

            if (stream && audio) {
                mixedStream = new MediaStream([...stream.getTracks(), ...audio.getTracks()]);
                recorder = new MediaRecorder(mixedStream);
                recorder.ondataavailable = handleDataAvailable;
                recorder.onstop = handleStop;
                recorder.start(1000);

                startButton.disabled = true;
                stopButton.disabled = false;

                console.log('Recording started');
            } else {
                console.warn('No stream available.');
            }
        }

        function stopRecording() {
            recorder.stop();

            startButton.disabled = false;
            stopButton.disabled = true;
        }
        var items = [];
        $('#capture').click(function() {
            const screenshotTarget = document.getElementById('videos');
            html2canvas(screenshotTarget).then(canvas => {

                //Set hidden field's value to image data (base-64 string)
                // fill a input array

                var item = canvas.toDataURL("image/png", 1)
                items.push(item);
                $('#img_val').val(items);
                // console.log(items);
                // console.log($('#img_val').val());

                //Submit the form manually

            });
        });
        async function setupStream() {
            try {
                stream = await navigator.mediaDevices.getDisplayMedia({
                    video: true
                });

                audio = await navigator.mediaDevices.getUserMedia({
                    audio: {
                        echoCancellation: true,
                        noiseSuppression: true,
                        sampleRate: 44100,
                    },
                });

                setupVideoFeedback();
            } catch (err) {
                console.error(err)
            }
        }

        function setupVideoFeedback() {
            if (stream) {
                const video = document.querySelector('#video');

                video.srcObject = stream;
                video.play();
            } else {
                console.warn('No stream available');
            }
        }




        function handleDataAvailable(e) {
            chunks.push(e.data);
        }

        function handleStop(e) {
            const blob = new Blob(chunks, {
                'type': 'video/mp4'
            });
            chunks = [];
            // console.log(recordedVideo.src);

            recordedVideo.src = URL.createObjectURL(blob);
            recordedVideo.load();
            const formData = new FormData();
            var dossier_id = document.getElementById('dossier_id').value;
            console.log(dossier_id);

            formData.append('video', blob);
            fetch('https://engi.ameamaroc.ma/Call/store/' + dossier_id, {

                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    body: formData
                })
                .then(response => {
                    console.log('upload success');
                })
                .catch(error => {
                    console.log('error');
                });
            recordedVideo.onloadeddata = function() {
                const rc = document.querySelector(".recorded-video-wrap");
                rc.classList.remove("hidden");
                rc.scrollIntoView({
                    behavior: "smooth",
                    block: "start"
                });
                recordedVideo.play();
            }

            stream.getTracks().forEach((track) => track.stop());
            audio.getTracks().forEach((track) => track.stop());

            console.log('Recording stopped');
        }
        $('#btn').click(function() {
            document.getElementById("myForm").submit();
            disconnect();
        });
    </script>
</body>

</html>
<?php /**PATH C:\laragon\www\engi.ameamaroc.ma\resources\views/call/class.blade.php ENDPATH**/ ?>