<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="menuitem-active">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

    <link rel="shortcut icon" href="<?php echo e(asset('img/icon.png')); ?>" type="image/png">
    <title><?php echo e(config('app.name', 'AMEA')); ?></title>


    
    

    
    
    

    <link rel="stylesheet" href="<?php echo e(asset('css/dataTables/dataTables.bootstrap.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('css/icons.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/app.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/search.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/viewer.css')); ?>">
    <style>
        .scrollable-container {
            overflow: auto;
            /* or overflow: scroll; */
        }
    </style>
    <?php echo $__env->yieldContent('style'); ?>
    <?php echo \Livewire\Livewire::styles(); ?>



</head>

<body id="body" data-layout-color="light" data-layout-mode="fluid" data-rightbar-onstart="true"
    data-leftbar-theme="dark" style="">
    



    <div class="wrapper" id="content">
        <?php echo $__env->make('layouts.dashboard.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="content-page">
            <div class="content">
                <?php echo $__env->make('layouts.config_dashboard.partials.topbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="container-fluid m-0 p-0 mt-1 ">

                    <?php echo $__env->make('errors.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>

            <footer class="footer mt-3">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-6">
                            ©Amea - Powered by IS-TECH
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>

    <!-- Scripts -->

    <script src="<?php echo e(asset('js/vendor.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.js')); ?>" defer></script>
    

    <script src="<?php echo e(asset('js/dataTables.js/dataTables.js')); ?>"></script>
    <script src="<?php echo e(asset('js/viewer.js')); ?>"></script>

    

    <script>
        $(document).ready(function() {
            var allTables = $('table.dataTable').DataTable();
            allTables.column(0).search('mySearchTerm').draw();
            $('#myTable').DataTable({
                language: {
                    url: "https://cdn.datatables.net/plug-ins/1.12.1/i18n/fr-FR.json"
                },
                // dom: 'Bfrtip',
                // buttons: [
                //     'copy', 'csv', 'excel', 'pdf', 'print'
                // ],
                // pagingType: "numbers"
            });
            $('#myTable2').DataTable({
                language: {
                    url: "https://cdn.datatables.net/plug-ins/1.12.1/i18n/fr-FR.json"
                } //,
                // pagingType: "numbers"
            });
            $('#myTable3').DataTable();

        });
    </script>
    <?php echo \Livewire\Livewire::scripts(); ?>

    <?php echo $__env->yieldContent('script'); ?>
    <script>
        var $mediaElements = $('.media');

        $('.link').click(function(e) {
            e.preventDefault();

            var filterVal = $(this).data('filter');

            if (filterVal === 'ALL') {
                $mediaElements.show();
            } else {
                // Enclose filterVal in quotes to handle spaces
                $mediaElements.hide().filter('.' + CSS.escape(filterVal)).show();
            }
        });

    </script>

    <script>
        window.addEventListener('load', function() {
            console.log('DOM fully loaded and parsed');
            var galley = document.getElementById('galley');
            var maxOffsetPercentage = 0.9;
            var viewer = new Viewer(galley, {
                url: 'data-original',
                backdrop: 'static',
                move: function(event) {
                    var viewerData = viewer.viewerData;
                    var imageData = viewer.imageData;
                    var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                    var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                    var detail = event.detail;
                    var left = detail.x;
                    var top = detail.y;
                    var right = viewerData.width - (left + imageData.width);
                    var bottom = viewerData.height - (top + imageData.height);
                    if (
                        // Move left
                        (detail.x < detail.oldX && right > 0 && right > maxOffsetHorizontal)
                        // Move right
                        ||
                        (detail.x > detail.oldX && left > 0 && left > maxOffsetHorizontal)
                        // Move up
                        ||
                        (detail.y < detail.oldY && bottom > 0 && bottom > maxOffsetVertical)
                        // Move down
                        ||
                        (detail.y > detail.oldY && top > 0 && top > maxOffsetVertical)
                    ) {
                        event.preventDefault();
                    }
                },
                zoomed: function(event) {
                    var detail = event.detail;
                    // Zoom out
                    if (detail.ratio < detail.oldRatio) {
                        var viewerData = viewer.viewerData;
                        var imageData = viewer.imageData;
                        var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                        var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                        var left = imageData.x;
                        var top = imageData.y;
                        var right = viewerData.width - (left + imageData.width);
                        var bottom = viewerData.height - (top + imageData.height);
                        var x = 0;
                        var y = 0;
                        if (right > 0 && right > maxOffsetHorizontal) {
                            x = maxOffsetHorizontal - right;
                        }
                        if (left > 0 && left > maxOffsetHorizontal) {
                            x = maxOffsetHorizontal - left;
                        }

                        if (bottom > 0 && bottom > maxOffsetVertical) {
                            y = bottom - maxOffsetVertical;
                        }

                        if (top > 0 && top > maxOffsetVertical) {
                            y = top - maxOffsetVertical;
                        }

                        // Move the image into view if it is invisible
                        if (x !== 0 || y !== 0) {
                            viewer.move(x, y);
                        }
                    }
                },
            });
        });
        var links = document.getElementsByClassName('link');
        for (var i = 0; i < links.length; i++) {

            links[i].addEventListener('click', function() {
                console.log('clcl');
                var galley = document.getElementById('galley');
                var maxOffsetPercentage = 0.9;
                var viewer = new Viewer(galley, {
                    url: 'data-original',
                    backdrop: 'static',
                    move: function(event) {
                        var viewerData = viewer.viewerData;
                        var imageData = viewer.imageData;
                        var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                        var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                        var detail = event.detail;
                        var left = detail.x;
                        var top = detail.y;
                        var right = viewerData.width - (left + imageData.width);
                        var bottom = viewerData.height - (top + imageData.height);
                        if (
                            // Move left
                            (detail.x < detail.oldX && right > 0 && right > maxOffsetHorizontal)
                            // Move right
                            ||
                            (detail.x > detail.oldX && left > 0 && left > maxOffsetHorizontal)
                            // Move up
                            ||
                            (detail.y < detail.oldY && bottom > 0 && bottom > maxOffsetVertical)
                            // Move down
                            ||
                            (detail.y > detail.oldY && top > 0 && top > maxOffsetVertical)
                        ) {
                            event.preventDefault();
                        }
                    },
                    zoomed: function(event) {
                        var detail = event.detail;
                        // Zoom out
                        if (detail.ratio < detail.oldRatio) {
                            var viewerData = viewer.viewerData;
                            var imageData = viewer.imageData;
                            var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                            var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                            var left = imageData.x;
                            var top = imageData.y;
                            var right = viewerData.width - (left + imageData.width);
                            var bottom = viewerData.height - (top + imageData.height);
                            var x = 0;
                            var y = 0;
                            if (right > 0 && right > maxOffsetHorizontal) {
                                x = maxOffsetHorizontal - right;
                            }
                            if (left > 0 && left > maxOffsetHorizontal) {
                                x = maxOffsetHorizontal - left;
                            }

                            if (bottom > 0 && bottom > maxOffsetVertical) {
                                y = bottom - maxOffsetVertical;
                            }

                            if (top > 0 && top > maxOffsetVertical) {
                                y = top - maxOffsetVertical;
                            }

                            // Move the image into view if it is invisible
                            if (x !== 0 || y !== 0) {
                                viewer.move(x, y);
                            }
                        }
                    },
                });
            });
        }
    </script>


</body>

</html>
<?php /**PATH /home/admin/public_html/engi.ameamaroc.ma/resources/views/layouts/dashboard/app.blade.php ENDPATH**/ ?>