<?php

namespace App\Policies;

use App\Models\User;
use App\Models\PieceType;
use Illuminate\Support\Facades\Auth;
use Illuminate\Auth\Access\HandlesAuthorization;

class PieceTypePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user)
    {
        $user = User::findOrFail(Auth::user()->id);
        if( $user->role_id === 4 || $user->hasPermission('naviguer_pieces') || $user->hasRolePermission('naviguer_pieces') ){
            return true;
        }
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\PieceType  $pieceType
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function view(User $user, PieceType $pieceType)
    {
        $user = User::whereId(Auth::user()->id)->first();
        if( $user->role_id === 4  ||  $user->hasPermission('view_pieces') || $user->hasRolePermission('view_pieces')){
            return true;
        }
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user)
    {
        $user = User::findOrFail(Auth::user()->id);
        if($user->hasPermission('ajouter_pieces') || $user->hasRolePermission('ajouter_pieces') || $user->role_id === 4 ){
            return true;
        }
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\PieceType  $pieceType
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user, PieceType $pieceType)
    {
        $user = User::findOrFail(Auth::user()->id);
        if( $user->role_id === 4 || $user->hasPermission('modifier_pieces') || $user->hasRolePermission('modifier_pieces')  ){
            return true;
        }
    }

    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\PieceType  $pieceType
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function delete(User $user, PieceType $pieceType)
    {
        //
    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\PieceType  $pieceType
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function restore(User $user, PieceType $pieceType)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\PieceType  $pieceType
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function forceDelete(User $user, PieceType $pieceType)
    {
        //
    }
}
