<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Montant extends Model
{
    use HasFactory;

    protected $fillable = ['montant_accord','dossier_id','montant_rapport','devis_id','facture_id'];

    public function devis()
    {
        return $this->belongsTo(Devis::class,'devis_id');
    }
    public function facture()
    {
        return $this->belongsTo(Facture::class);
    }
    public function dossier()
    {
        return $this->belongsTo(Dossier::class);
    }
}
