<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Garage extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['libelle', 'email', 'tel','adress', 'lat', 'lng', 'city_id', 'user_id','url','verified'];

    public function city()
    {
        return $this->belongsTo(City::class)->withTrashed();
    }

    public function user()
    {
        return $this->belongsTo(User::class)->withTrashed();
    }

    public function meeting()
    {
        return $this->hasMany(Meeting::class)->withTrashed();
    }
    public function dossier()
    {
        return $this->hasMany(Dossier::class)->withTrashed();
    }
    public function garageservice()
    {
        return $this->belongsToMany(GarageService::class ,'garageservice_garage');
    }

    public function company()
    {
        return $this->belongsToMany(Company::class ,'garage_company')->withTimestamps();
    }

    public function manyuser()
    {
        return $this->belongsToMany(User::class ,'user_garage')->withTimestamps();
    }

    public function hasService($service)
    {
        return $this->garageservice->contains('service', $service);
    }

    public function hasCompany($company)
    {
        return $this->company->contains('company', $company);
    }
}
