<?php

namespace App\Http\Controllers;

use App\Models\Demande;
use App\Models\Dossier;
use App\Models\Notification;
use App\Models\Observation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DemandeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('viewAny', Demande::class);

        if (Auth::user()->role_id == 4) {
            $demandes = Demande::with('status','user')->where('status_rendezvous_id',2)->get();
        }
        else {
            $demandes = Demande::where('user_id', Auth::user()->id)->with('status')->get();
        }
        return view('configuration.demande.index', compact('demandes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($dossier_id)
    {
        $this->authorize('create', Demande::class);
        //dd($dossier_id);
        $dossier = Dossier::whereId($dossier_id)->first();

        return view('configuration.demande.create',compact('dossier_id'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->authorize('create', Demande::class);
        $request->validate([
            'motif' => 'required',
        ]);

        Demande::create([
            'user_id' => Auth::user()->id,
            'motif' => $request->motif,
            'status_rendezvous_id' => 2,
            'dossier_id'=> $request->dossier_id
        ]);
        $dossier = Dossier::whereId($request->dossier_id)->first();
        $body = "A Créer une Demander Dossier:" . $dossier->ref;
        Notification::create([
            'user_id' => Auth::user()->id,
            'dossier_id' => $dossier->id,
            'body' => $body
        ]);

        return redirect()->route('home');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Demande  $demande
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        // $this->authorize('view', Demande::class);
        // $demande = Demande::whereId($id)->firstOrFail();
        // return redirect()->route('Dossier.show', $demande->dossier_id);

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Demande  $demande
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $this->authorize('update', Demande::class);
        $demande = Demande::whereId($id)->firstOrFail();
        return view('configuration.demande.edit', compact('demande'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Demande  $demande
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $this->authorize('update', Demande::class);
        $demande = Demande::whereId($id)->firstOrFail();
        $dossier = Dossier::whereId($demande->dossier_id)->first();

        if ($demande->status_rendezvous_id == 2) {
            if ($request->input('action') == "terminer") {

                $demande->status_rendezvous_id = 3;
                $demande->update();
                $body = "A Accepter votre Demande:" . $dossier->ref;
                Notification::create([
                    'user_id' => Auth::user()->id,
                    'dossier_id' => $dossier->id,
                    'body' => $body
                ]);
            } else if ($request->input('action') == "annuler") {
                $request->validate([
                    'observation'=>'required'
                ]);
                Observation::create([
                    'observation' => $request->observation,
                    'dossier_id' => $dossier->id,
                    'user_id' => Auth::user()->id
                ]);
                $demande->status_rendezvous_id = 1;
                $demande->update();
                $body = "A Refuser votre Demande :" . $dossier->ref;
                Notification::create([
                    'user_id' => Auth::user()->id,
                    'dossier_id' => $dossier->id,
                    'body' => $body
                ]);
            }
        }
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Demande  $demande
     * @return \Illuminate\Http\Response
     */
    public function destroy(Demande $demande)
    {
        //
    }

    public function dossier($id)
    {
        $this->authorize('viewAny', Demande::class);

       $demandes =  Demande::where('dossier_id',$id)->latest()->get();
       return view('configuration.demande.list',compact('demandes'));
    }

}
