<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tickets', function (Blueprint $table) {
            $table->id();

            $table->foreignId('dossier_id')->nullable()->constrained()->onDelete(null);
            $table->foreignId('user_id')->nullable()->constrained()->onDelete(null);
            $table->foreignId('creator_id')->nullable()->onDelete(null);
            $table->foreignId('status_rendezvous_id')->constrained()->onDelete(null);
            $table->dateTime('answer_at')->nullable();
            $table->text('answer')->nullable();
            $table->text('motif');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tickets');
    }
};
