<?php

use App\Models\Email;
use App\Models\TypeDocument;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('typedocument_email', function (Blueprint $table) {
            $table->id();
            $table->foreignId('typedocument_id')->onDelete(null);
            $table->foreignId('email_id')->constrained()->onDelete(null);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('typedocument_email');
    }
};
