<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('settlements', function (Blueprint $table) {
            $table->id();
            $table->string('numero_facture');
            $table->string('banque');
            $table->decimal('montant',10,2);
            $table->decimal('reste',10,2)->default(0);
            $table->string('mode_paiement');
            $table->foreignId('company_id')->constrained()->onDelete(null);
            $table->date('date_facture');
            $table->date('date_paiement');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('settlements');
    }
};
