<?php

use App\Http\Controllers\BrandController;
use App\Http\Controllers\ChartController;
use App\Http\Controllers\CityController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\ConfigurationController;
use App\Http\Controllers\CurrencyController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\DemandeController;
use App\Http\Controllers\DeviceController;
use App\Http\Controllers\DevisController;
use App\Http\Controllers\DocumentController;
use App\Http\Controllers\DossierController;
use App\Http\Controllers\EmailController;
use App\Http\Controllers\ExpertController;
use App\Http\Controllers\FactureController;
use App\Http\Controllers\GarageController;
use App\Http\Controllers\GarageServiceController;
use App\Http\Controllers\GuaranteeController;
use App\Http\Controllers\IntermidiaireController;
use App\Http\Controllers\IpController;
use App\Http\Controllers\MarketvalueController;
use App\Http\Controllers\MeetingController;
use App\Http\Controllers\ModeController;
use App\Http\Controllers\NoteHonoraireController;
use App\Http\Controllers\ObservationController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\OperationController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\PieceController;
use App\Http\Controllers\PieceTypeController;
use App\Http\Controllers\RendezvousController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\SettlementController;
use App\Http\Controllers\SeuilController;
use App\Http\Controllers\ShockPointController;
use App\Http\Controllers\SignatureController;
use App\Http\Controllers\SmsController;
use App\Http\Controllers\StepController;
use App\Http\Controllers\SubstituteController;
use App\Http\Controllers\TauxController;
use App\Http\Controllers\TicketController;
use App\Http\Controllers\TypeDocumentController;
use App\Http\Controllers\TypeDossierController;
use App\Http\Controllers\TypeExpertiseController;
use App\Http\Controllers\TypeIngredientController;
use App\Http\Controllers\TypeRendezvousController;
use App\Http\Controllers\TypeReparationController;
use App\Http\Controllers\TypeVehiculeController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\VehiculeModelController;
use App\Models\Operation;
use App\Models\TypeVehicule;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/



Auth::routes();

// SIgned URLS
Route::get('Dossier/{dossier_id}/{token}/Carence', [App\Http\Controllers\CarenceController::class, 'create'])->name('Carence.create')->middleware('signed');
Route::post('Dossier/Carence', [App\Http\Controllers\CarenceController::class, 'store'])->name('Carence.store');

Route::middleware('auth', 'Ip', 'PreventBackHistory')->group(function () {


    Route::post('/update/token', [NotificationController::class, 'updatedevicetoken'])->name('updatetoken');
    Route::get('Dossier/{dossier_id}/URL', [App\Http\Controllers\DossierController::class, 'url'])->name('Dossier.url');
    //Paramétrage
    Route::resource('/Signature', SignatureController::class)->except(['show']);
    Route::resource('/Intermidiaire', IntermidiaireController::class);
    Route::get('/Guarantee/Deleted', [App\Http\Controllers\GuaranteeController::class, 'deleted'])->name('Guarantee.deleted');
    Route::resource('/Company', CompanyController::class);
    Route::post('/Company/attach/{id}', [App\Http\Controllers\CompanyController::class, 'attach'])->name('Company.attach');
    Route::post('/Company/restore/{id}', [App\Http\Controllers\CompanyController::class, 'restore'])->name('Company.restore');
    Route::get('/Company/Deleted', [App\Http\Controllers\CompanyController::class, 'deleted'])->name('Company.deleted');

    Route::resource('/Role', RoleController::class);
    Route::resource('/Seuil', SeuilController::class);
    Route::get('/Seuil/Detail/{id}', [App\Http\Controllers\SeuilController::class, 'detail'])->name('Seuil.detail');

    Route::resource('/Step', StepController::class)->only('index', 'update', 'edit');
    Route::resource('/Device', DeviceController::class)->except('show');

    Route::get('/Garage/Deleted', [App\Http\Controllers\GarageController::class, 'deleted'])->name('Garage.deleted');
    Route::resource('/Garage', GarageController::class);
    Route::post('/Garage/restore/{id}', [App\Http\Controllers\GarageController::class, 'restore'])->name('Garage.restore');
    Route::resource('/Brand', BrandController::class)->except('show');
    Route::resource('/TypeVehicule', TypeVehiculeController::class)->except('show');


    Route::resource('/Piece', PieceController::class)->except('show');
    Route::post('/Piece/store', [App\Http\Controllers\PieceController::class, 'storefromrapport'])->name('Piece.rapport');
    Route::post('/Piece/devis', [App\Http\Controllers\PieceController::class, 'storefromdevis'])->name('Piece.devis');
    Route::get('/TypePiece/{id}', [App\Http\Controllers\PieceTypeController::class, 'filter'])->name('Piece.filter');

    Route::post('/Piece/restore/{id}', [App\Http\Controllers\PieceController::class, 'restore'])->name('Piece.restore');
    Route::get('/Piece/Deleted', [App\Http\Controllers\PieceController::class, 'deleted'])->name('Piece.deleted');
    Route::resource('/Modele', VehiculeModelController::class)->except('show');
    Route::post('/Modele/restore/{id}', [App\Http\Controllers\VehiculeModelController::class, 'restore'])->name('Modele.restore');
    Route::get('/Modele/Deleted', [App\Http\Controllers\VehiculeModelController::class, 'deleted'])->name('Modele.deleted');

    Route::post('/Brand/restore/{id}', [App\Http\Controllers\BrandController::class, 'restore'])->name('Brand.restore');
    Route::get('/Brand/Deleted', [App\Http\Controllers\BrandController::class, 'deleted'])->name('Brand.deleted');
    Route::resource('/City', CityController::class)->except('show');
    Route::post('/City/restore/{id}', [App\Http\Controllers\CityController::class, 'restore'])->name('City.restore');
    Route::get('/City/Deleted', [App\Http\Controllers\CityController::class, 'deleted'])->name('City.deleted');

    Route::resource('GarageService', GarageServiceController::class)->except('show');
    Route::post('/Garage/Service/{id}', [App\Http\Controllers\GarageServiceController::class, 'asign'])->name('GarageService.asign');
    Route::post('/Garage/Company/{id}', [App\Http\Controllers\CompanyController::class, 'company'])->name('GarageCompany.asign');

    Route::resource('/Guarantee', GuaranteeController::class);
    Route::post('/Guarantee/restore/{id}', [App\Http\Controllers\GuaranteeController::class, 'restore'])->name('Guarantee.restore');
    Route::resource('/user', UserController::class);
    Route::get('/User/Deleted', [App\Http\Controllers\UserController::class, 'trash'])->name('user.trash');
    Route::post('/user/restore/{id}', [App\Http\Controllers\UserController::class, 'restore'])->name('user.restore');
    Route::post('/user/assign/{id}', [App\Http\Controllers\UserController::class, 'typedocument'])->name('user.assign');
    Route::get('/User/Profile', [App\Http\Controllers\UserController::class, 'profile'])->name('user.profile');
    Route::put('/User/Password', [App\Http\Controllers\UserController::class, 'password'])->name('user.password');




    //PDF
    Route::get('Dossier/Preliminaire/{id}', [App\Http\Controllers\PdfController::class, 'preliminaire'])->name('pdf.preliminaire');

    Route::get('Dossier/Forfait/{id}', [App\Http\Controllers\PdfController::class, 'forfaitaire'])->name('pdf.forfait');
    Route::get('/Pdf/Normal/{id}', [App\Http\Controllers\PdfController::class, 'normal'])->name('pdf.normal');
    Route::get('/Pdf/AvisDommage/{id}', [App\Http\Controllers\PdfController::class, 'avisdommage'])->name('pdf.avis');
    Route::get('/Pdf/Reforme/{id}', [App\Http\Controllers\PdfController::class, 'reforme'])->name('pdf.reforme');
    Route::get('/Pdf/FFT/{id}', [App\Http\Controllers\PdfController::class, 'fft'])->name('pdf.fft');
    Route::get('/Pdf/canevas/{id}', [App\Http\Controllers\PdfController::class, 'canevas'])->name('pdf.canevas');
    Route::get('/Pdf/Requete/{id}', [App\Http\Controllers\PdfController::class, 'req'])->name('pdf.req');
    Route::get('/Dossier/{id}/ReformTechnique', [App\Http\Controllers\DossierController::class, 'reformeTechnique'])->name('dossier.technique');
    Route::post('/Pdf/ReformeTechnique/{id}', [App\Http\Controllers\PdfController::class, 'reformeTechnique'])->name('pdf.technique');
    Route::get('/Dossier/{id}/ReformTechnique/Pdf', [App\Http\Controllers\DossierController::class, 'pdf'])->name('dossier.ref');
    Route::get('/Pdf/Accord/devis/{id}', [App\Http\Controllers\PdfController::class, 'accord'])->name('pdf.accord');

    //NOTEHONORAIRE
    Route::resource('/NoteHonoraire', NoteHonoraireController::class)->except('show');

    // asign user to permissions
    Route::post('/User/Permission/{id}', [App\Http\Controllers\PermissionController::class, 'store'])->name('Permission.store');
    //assign role to permissions
    Route::post('/Role/Permission/{id}', [App\Http\Controllers\PermissionController::class, 'store2'])->name('Permission.store2');
    // AsignToExpertise
    Route::post('/User/TypeExpertise/{id}', [App\Http\Controllers\UserController::class, 'AsignToExpertise'])->name('User.expertise');
    Route::post('/user/permission', [App\Http\Controllers\PermissionController::class, 'index'])->name('user.gestion');
    //Types
    // Route::resource('/TypeDossier', TypeDossierController::class)->except('show');
    // Route::get('/TypeDossier/Deleted', [App\Http\Controllers\TypeDossierController::class, 'deleted'])->name('TypeDossier.deleted');
    // Route::post('/TypeDossier/restore/{id}', [App\Http\Controllers\TypeDossierController::class, 'restore'])->name('TypeDossier.restore');

    Route::resource('/TypeExpert', TypeExpertiseController::class)->except('show');
    Route::get('/TypeExpert/Deleted', [App\Http\Controllers\TypeExpertiseController::class, 'deleted'])->name('TypeExpert.deleted');
    Route::post('/TypeExpert/restore/{id}', [App\Http\Controllers\TypeExpertiseController::class, 'restore'])->name('TypeExpert.restore');

    Route::resource('/TypeDocument', TypeDocumentController::class)->except('show');

    Route::resource('/ShockPoint', ShockPointController::class)->except('show', 'create');
    Route::get('/Dossier/{id}/ShockPoint', [App\Http\Controllers\ShockPointController::class, 'create'])->name('ShockPoint.create');
    Route::resource('/PieceType', PieceTypeController::class)->except('show');
    Route::resource('/Operation', OperationController::class)->except('show');
    Route::get('/PieceType/Deleted', [App\Http\Controllers\PieceTypeController::class, 'deleted'])->name('PieceType.deleted');
    Route::post('/PieceType/restore/{id}', [App\Http\Controllers\PieceTypeController::class, 'restore'])->name('PieceType.restore');
    Route::get('Contradictoire/create/{id}', [App\Http\Controllers\ContradictoireController::class, 'create'])->name('Contradictoire.create');
    Route::post('Contradictoire', [App\Http\Controllers\ContradictoireController::class, 'store'])->name('Contradictoire.store');
    Route::get('Contradictoire/edit/{id}', [App\Http\Controllers\ContradictoireController::class, 'edit'])->name('Contradictoire.edit');
    Route::put('Contradictoire/{id}', [App\Http\Controllers\ContradictoireController::class, 'update'])->name('Contradictoire.update');

    Route::resource('/Devis', DevisController::class)->only(['store', 'update','destroy']);
    Route::get('Devis/Dossier/show/{id}', [App\Http\Controllers\DevisController::class, 'show'])->name('Devis.show');
    Route::get('Devis/Dossier/{id}', [App\Http\Controllers\DevisController::class, 'index'])->name('Devis.index');
    Route::get('Devis/create/{id}', [App\Http\Controllers\DevisController::class, 'create'])->name('Devis.create');
    Route::put('Devis/Dossier/Update/{id}', [App\Http\Controllers\DevisController::class, 'updatedossier'])->name('Devis.updatedossier');
    Route::get('Devis/Piece/Prix', [App\Http\Controllers\PieceController::class, 'lastprice'])->name('Devis.lastprice');



    Route::get('Rapport/Forfait/{id}', [App\Http\Controllers\RapportController::class, 'forfait'])->name('Rapport.forfait');
    Route::get('Rapport/{id}', [App\Http\Controllers\RapportController::class, 'index'])->name('Rapport.index');
    Route::get('Rapport/show/{id}', [App\Http\Controllers\RapportController::class, 'show'])->name('Rapport.show');
    Route::get('Rapport/create/{id}', [App\Http\Controllers\RapportController::class, 'create'])->name('Rapport.create');
    Route::post('Rapport/store', [App\Http\Controllers\RapportController::class, 'store'])->name('Rapport.store');
    Route::post('Rapport/attach', [App\Http\Controllers\RapportController::class, 'attach'])->name('Rapport.attach');
    Route::post('Rapport/send', [App\Http\Controllers\RapportController::class, 'send'])->name('Rapport.send');
    Route::get('Rapport/Signature/{id}', [App\Http\Controllers\RapportController::class, 'signature'])->name('rapport.signature');
    Route::post('Rapport/status', [App\Http\Controllers\RapportController::class, 'status'])->name('rapport.status');
    Route::get('Rapport/{id}/PDF', [App\Http\Controllers\RapportController::class, 'pdf'])->name('Rapport.doc');
    Route::get('Rapport/{id}/Documents', [App\Http\Controllers\RapportController::class, 'documents'])->name('Rapport.documents');
    Route::post('Rapport/{id}/Attachment', [App\Http\Controllers\RapportController::class, 'attachments'])->name('Rapport.attachments');
    Route::post('Rapport/{id}/Regenerate', [App\Http\Controllers\RapportController::class, 'regenerate'])->name('Rapport.regenerate');



    Route::resource('/Currency', CurrencyController::class)->except('show');


    Route::resource('TypeIngredient', TypeIngredientController::class)->except('show');
    Route::resource('TypeReparation', TypeReparationController::class)->except('show');
    Route::resource('Taux', TauxController::class)->only('store');
    Route::post('Devis/Taux', [App\Http\Controllers\TauxController::class, 'storedevis'])->name('taux.devis');

    Route::post('Dossier/Export', [App\Http\Controllers\DossierController::class, 'export'])->name('Dossier.export');
    Route::post('Dossier/Affecter', [App\Http\Controllers\DossierController::class, 'affecter'])->name('Dossier.affecter');
    Route::get('Dossier/Archive', [App\Http\Controllers\DossierController::class, 'archive'])->name('Dossier.archive');
    Route::get('Dossier/Historique/{id}', [App\Http\Controllers\DossierController::class, 'historique'])->name('Dossier.historique');
    Route::resource('Dossier', DossierController::class)->except('store');
    Route::put('Dossier/status/anomalie/{id}', [App\Http\Controllers\DossierController::class, 'anomalie'])->name('Dossier.anomalie');
    Route::put('Dossier/status/encours/{id}', [App\Http\Controllers\DossierController::class, 'encours'])->name('Dossier.encours');
    Route::put('Dossier/envoyer/{id}', [App\Http\Controllers\DossierController::class, 'envoyer'])->name('Dossier.envoyer');
    Route::put('Dossier/douteux/{id}', [App\Http\Controllers\DossierController::class, 'douteux'])->name('Dossier.douteux');
    Route::put('Dossier/open/{id}', [App\Http\Controllers\DossierController::class, 'open'])->name('Dossier.open');
    Route::post('Dossier/Archive/search', [App\Http\Controllers\DossierController::class, 'archiveSearch'])->name('Dossier.archiveSearch');
    Route::get('Dossier/Facturation/{id}', [App\Http\Controllers\DossierController::class, 'facturation'])->name('Dossier.facturation');
    Route::post('Dossier/Cloturer', [App\Http\Controllers\DossierController::class, 'cloturer'])->name('Dossier.cloturer');
    Route::post('Dossier/Annuler', [App\Http\Controllers\DossierController::class, 'annuler'])->name('Dossier.annuler');
    Route::post('Dossier/ReCloturer/{id}', [App\Http\Controllers\DossierController::class, 'ReCloturer'])->name('Dossier.ReCloturer');
    Route::get('Dossier/Demandes/{id}', [App\Http\Controllers\DossierController::class, 'demandesHistorique'])->name('Dossier.demandesHistorique');

    //meetings
    Route::get('Dossier/Meeting/{id}', [App\Http\Controllers\MeetingController::class, 'index'])->name('Meeting.index');
    Route::resource('/Meeting', MeetingController::class)->except('create', 'index', 'delete');
    Route::get('/Meetings/filter', [App\Http\Controllers\MeetingController::class, 'historique'])->name('Meeting.historique');
    Route::get('/Meeting/create/{id}', [App\Http\Controllers\MeetingController::class, 'create'])->name('Meeting.create');
    Route::put('/Meeting/status/{id}', [App\Http\Controllers\MeetingController::class, 'status'])->name('Meeting.status');
    Route::get('/Meeting/editing/{id}', [App\Http\Controllers\MeetingController::class, 'editing'])->name('Meeting.editing');

    Route::resource('/Observation', ObservationController::class)->only('store');
    Route::resource('/Mode', ModeController::class)->except('show');

    //document
    Route::get('/Document/index/{id}', [App\Http\Controllers\DocumentController::class, 'index'])->name('Document.index');
    Route::get('/Document/Signature/{id}', [App\Http\Controllers\DocumentController::class, 'asigner'])->name('Document.asigner');
    Route::post('/Document/Signer/{id}', [App\Http\Controllers\DocumentController::class, 'signer'])->name('Document.signer');

    Route::resource('/Document', DocumentController::class)->except('create','index','delete');
    Route::get('/Document/create/{id}', [App\Http\Controllers\DocumentController::class, 'create'])->name('Document.create');
    Route::post('/Document/PDF', [App\Http\Controllers\DocumentController::class, 'pdf'])->name('Document.pdf');
    Route::get('/test', [App\Http\Controllers\DocumentController::class, 'test'])->name('Document.test');
    Route::post('/Document/Image', [App\Http\Controllers\DocumentController::class, 'fileStore'])->name('Document.fileStore');
    // Route::delete('/Document/DeleteAll', [App\Http\Controllers\DocumentController::class, 'deleteall'])->name('Document.deleteall');


    Route::get('/Vehicule/{brand_id}', [App\Http\Controllers\BrandController::class, 'search'])->name('vehicule.search');
    Route::get('/Document/{dossier_id}/Type/{type_id}', [App\Http\Controllers\DocumentController::class, 'search'])->name('document.search');

    //search meeting with the same user selected
    Route::get('/Meeting/user/{user_id}', [App\Http\Controllers\MeetingController::class, 'search'])->name('meeting.search');

    //search garage selected
    Route::get('/Meeting/garage/{garage_id}', [App\Http\Controllers\MeetingController::class, 'searching'])->name('meeting.searching');

    // Route::post('/Devis/piece/remove/{id}', [App\Http\Controllers\PieceController::class, 'attach'])->name('Piece.attach');
    Route::post('/Devis/attach', [App\Http\Controllers\DevisController::class, 'attach'])->name('Devis.attach');
    Route::put('/Devis/status/{id}', [App\Http\Controllers\DevisController::class, 'status'])->name('Devis.status');

    Route::get('/Historique', [App\Http\Controllers\NotificationController::class, 'index'])->name('notification.index');
    Route::get('/Detail/{id}', [App\Http\Controllers\NotificationController::class, 'show'])->name('notification.show');
    Route::post('/Historique/search', [App\Http\Controllers\NotificationController::class, 'search'])->name('notification.search');
    // Route::get('push-notification', [App\Http\Controllers\NotificationController::class, 'getpush'])->name('get.notification');
    // Route::post('sendNotification', [App\Http\Controllers\NotificationController::class, 'sendNotification'])->name('send.notification');
    // Route::post('/storeToken', [NotificationController::class, 'storeToken'])->name('store.token');
    // Route::post('/update/token', [NotificationController::class, 'updatedevicetoken'])->name('updatetoken');

    Route::get('/Montant/{id}/edit', [App\Http\Controllers\MontantController::class, 'edit'])->name('Montant.edit');
    Route::put('/Montant/{id}', [App\Http\Controllers\MontantController::class, 'update'])->name('Montant.update');

    Route::resource('/IP', IpController::class)->except('show');

    Route::post("/create_class", [App\Http\Controllers\CallController::class, 'createClass'])
        ->name('create_class');
    Route::get("/Call/create", [App\Http\Controllers\CallController::class, 'create'])
        ->name('call.create');

    // This route is used by all
    Route::post("/Call/store/{dossier_id}", [App\Http\Controllers\CallController::class, 'store'])->name('call.store');
    Route::get('/Call/{dossier_id}', [App\Http\Controllers\CallController::class, 'index'])->name('call');
    Route::get('/Call/saved/{dossier_id}', [App\Http\Controllers\CallController::class, 'saved'])->name('call.saved');
    Route::post('/picture/{dossier_id}', [App\Http\Controllers\CallController::class, 'picture'])->name('call.screen');

    Route::get('/URL', [App\Http\Controllers\CallController::class, 'url']);

    Route::get('/Location', [App\Http\Controllers\LocationController::class, 'index'])->name('Location.index');

    Route::get('/Calcule', [App\Http\Controllers\CalculeController::class, 'create']);
    Route::post('/Calcule', [App\Http\Controllers\CalculeController::class, 'calcule']);
    Route::resource('/Expert', ExpertController::class)->except('show');

    //Remplacant
    Route::controller(SubstituteController::class)->group(function () {
        Route::post('/Substitute', 'store')->name('Substitute.store');
        Route::get('User/{id}/Substitute', 'show')->name('Substitute.show');
    });

    //Reglement
    Route::resource('/Settlement', SettlementController::class)->except('destroy', 'show');
    Route::resource('/Configuration', ConfigurationController::class)->except('destroy', 'show');


    Route::get('/Settlement/{id}', [App\Http\Controllers\SettlementController::class, 'show'])->name('Settlement.show');
    Route::post('/Settlement/search', [App\Http\Controllers\SettlementController::class, 'search'])->name('Settlement.search');
    Route::get('/List/Settlement', [App\Http\Controllers\SettlementController::class, 'all'])->name('Settlement.all');
    Route::get('/Payment/Settlement/{id}', [App\Http\Controllers\SettlementController::class, 'get'])->name('Settlement.get');


    //Dashboard
    Route::controller(DashboardController::class)->group(function () {
        Route::get('/Facture/Carence', 'carencefacture');
        Route::get('/Expertiser', 'aexpertiser');
        Route::get('/Reporter', 'areport');
        Route::get('/Devis/Carence', 'carencedevis');
        Route::get('/Carence/Rapport', 'carencerapport');
        Route::get('/Signer/Rapport', 'rapportasigner');
        Route::get('/Devis/Retraiter', 'devisaretraiter');
        Route::get('/Facture/Retraiter', 'facturearetraiter');
        Route::get('/Retraiter/Rapport', 'rapportaretraiter');
        Route::get('/Instance/Rapport', 'traitrapport');

        Route::get('/', 'front')->name('home');
        Route::get('/Facture/Traitement', 'traitfacture');
        // Route::get('/Signer/Forfait', 'traitrapport');
        Route::get('/Devis/Traitement', 'traitdevis');
        Route::get('/Devis/Avis', 'avisdevis');
        Route::get('/Facture/Avis', 'avisfacture');
        Route::get('/Devis/Envoyer', 'senddevis');
        Route::get('/Devis/Controler', 'controldevis');
        Route::get('/Facture/Envoyer', 'sendfacture');
        Route::get('/Envoyer/Rapport', 'sendrapport');
        Route::get('/Devis/Deuxieme', 'deuxdevis');
        Route::get('/Facture/Deuxieme', 'deuxfacture');
        Route::get('/Deuxieme/Rapport', 'deuxrapport');
        Route::get('/Douteux', 'douteux');
        Route::get('/Tribunale', 'tribunale');
        Route::get('/Warning', 'warning');
        Route::get('/Signer/Document', 'docasigner');
        Route::get('/Signé/Document', 'docsigner');
        Route::get('/Rapide', 'rapide');
        Route::get('/Base', 'basedoc');
        Route::get('/Facturation', 'facturation');
        Route::get('/Devis/Trait', 'devisentraitement');
        Route::get('/Facture/Trait', 'factureentraitement');
        Route::get('/Devis/Photo', 'attdevisav');
        Route::get('/Facture/Photo', 'attfactureap');
        Route::get('/Expertise/encours', 'enexp');
        Route::get('/Expertise/Apres', 'attexpap');
        
        // API Routes
        Route::get('/api/dossiers/data', 'getDossiersData')->name('dossiers.data');
        Route::post('/api/dossiers/export', 'exportDossiers')->name('dossiers.export');
        
        // ⚡ REAL-TIME sidebar counts - NO CACHE (for AJAX polling every 15 seconds)
        Route::get('/api/sidebar/counts', 'getSidebarCountsApi')->name('sidebar.counts');
    });

    //EMAIL
    Route::controller(EmailController::class)->group(function () {
        //CRUD
        Route::get('/Email/{id}/', 'show')->name('Email.show');
        Route::delete('/Email/{id}', 'destroy')->name('Email.destroy');
        Route::get('/Email', 'index')->name('Email.index');
        Route::get('/Email/{id}/edit', 'edit')->name('Email.edit');
        Route::get('Create/Email', 'create')->name('Email.create');
        Route::post('Email/{id}/update', 'update')->name('Email.update');
        Route::post('/Email', 'store')->name('Email.store');
        Route::post('/Email/Envoyer', 'envoyer')->name('Email.envoyer');
        Route::post('Email/{id}/attach', 'attach')->name('Email.attach');
        Route::get('Dossier/{id}/Email/Compose', 'compose')->name('Email.compose');
        Route::post('/Email/Inbox/Search', 'search')->name('Email.search');
        Route::post('/Email/Inbox/Send', 'send')->name('Email.send');
        Route::get('/Email/Inbox/Show/{id}/{company}', 'showinbox')->name('Email.showinbox');
        Route::get('User/Email/Inbox', 'inbox')->name('Email.inbox');
        Route::get('Email/Historique/{id}', 'historique')->name('Email.historique');


    });


    //Ticket

    Route::controller(TicketController::class)->group(function () {

        Route::get('/Ticket/create/{id}', 'create')->name('Ticket.create');
        Route::get('/Ticket/index/{id}', 'index')->name('Ticket.index');
        Route::get('/Ticket/list', 'list')->name('Ticket.list');
        Route::get('/Ticket/list/Terminer', 'listterminer')->name('Ticket.listterminer');
        Route::post('/Ticket/cloturer/{id}', 'cloturer')->name('Ticket.cloturer');
        Route::get('/Ticket/show/{id}', 'show')->name('Ticket.show');
        Route::get('/Ticket/edit/{id}', 'edit')->name('Ticket.edit');
        Route::post('/Ticket', 'store')->name('Ticket.store');
        Route::put('/Ticket/update/{id}', 'update')->name('Ticket.update');

    });


    //Statistique
    Route::controller(ChartController::class)->group(function () {

        Route::get('/Chart/Dossier', 'index')->name('Chart.index');
        Route::get('/Chart/Role/{id}', 'userdossier')->name('Chart.dossier');
        Route::get('/Statistique', 'charts')->name('Chart.all');
        Route::post('/Statistique/All', 'stats')->name('Chart.stats');
        Route::get('/Chart', 'range')->name('Chart.range');
        Route::post('/Statistique/Export', 'export')->name('Chart.export');

    });


    //Paiment des Note Honoraires
    Route::controller(PaymentController::class)->group(function () {
        Route::get('/Payment', 'index')->name('Payment.index');
        Route::get('/Payment/{id}/edit', 'edit')->name('Payment.edit');
        Route::get('Dossier/{id}/Payment/create', 'create')->name('Payment.create');
        Route::put('Payment/{id}/update', 'update')->name('Payment.update');
        Route::post('/Payment', 'store')->name('Payment.store');
        Route::get('/Payment/{id}', 'show')->name('Payment.show');
        // Route::put('/Payment/{id}/Payer', 'status')->name('Payment.status');

    });

    //Facture
    Route::controller(FactureController::class)->group(function () {
        Route::get('/Facture/create/{id}', 'create')->name('Facture.create');
        Route::post('/Facture', 'store')->name('Facture.store');
        Route::get('/Facture/{id}', 'show')->name('Facture.show');
        Route::get('/Dossier/{id}/Facture', 'index')->name('Facture.index');
        Route::put('/Facture/status/{id}', 'status')->name('Facture.status');
        Route::delete('/Facture/destroy/{id}', 'destroy')->name('Facture.destroy');

    });


    Route::controller(DemandeController::class)->group(function () {
        Route::get('/Demande/create/{dossier_id}', 'create')->name('Demande.create');
        Route::post('/Demande', 'store')->name('Demande.store');
        Route::get('/Demande/{id}', 'show')->name('Demande.show');
        Route::get('/Demande/{id}/edit', 'edit')->name('Demande.edit');
        Route::get('/Demande', 'index')->name('Demande.index');
        Route::put('/Demande/{id}/update', 'update')->name('Demande.update');
        Route::get('/Dossier/{id}/Demande', 'dossier')->name('Demande.dossier');

    });
    Route::controller(MarketvalueController::class)->group(function () {
        Route::get('/MarketValue/create/{id}', 'create')->name('Marketvalue.create');
        Route::post('/MarketValue', 'store')->name('Marketvalue.store');
    });
    //rdv
    Route::resource('/TypeRendezVous', TypeRendezvousController::class)->except('show');
    Route::resource('/RendezVous', RendezvousController::class)->only('index', 'update', 'show');
    //SMS
    Route::resource('/SMS', SmsController::class)->except('show');
    //signed url attach with type docs
    Route::post('/Typedocument/Signedurl', [App\Http\Controllers\SignedUrlController::class, 'store'])->name('signedurl.store');
});

Route::get("/Dossier/{dossier_id}/class/{class_id}", [App\Http\Controllers\CallController::class, 'showClassRoom'])
    ->where('id', '[0-9]+')
    ->name('classroom')->middleware('signed');
// Get temporary S3 URL (for lazy loading images)
Route::get('/api/document/{id}/url', [App\Http\Controllers\DocumentController::class, 'getTemporaryUrl'])
    ->name('document.url')
    ->middleware('auth');

// Download document
Route::get('/api/document/{id}/download', [App\Http\Controllers\DocumentController::class, 'download'])
    ->name('document.download')
    ->middleware('auth');