@extends('layouts.dashboard.app')

@section('content')

<form action="{{ route('Rapport.attachments', $id) }}" method="POST">
    @csrf
    <div class="row g-4 mt-2">
        @foreach ($docs as $doc)
            <div class="col-md-3">
                <span> {{$doc->typedocument->type ?? null }}</span>

                <div class="card h-100">
                    <img src="{{ Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30)) }}"
                        class="card-img-top img-fluid">
                    <input type="hidden" name="img[]"
                        value="{{ $doc->id}}"
                        id="">
                    <div class="card-body">
                        <textarea name="body[]" class="form-control" id="" cols="30" rows=5> {{ $doc->rapports[0]->pivot->observation ?? null }}</textarea>
                    </div>
                </div>
            </div>
        @endforeach
        <button type="submit" class="btn btn-primary"> Enregistrer</button>
    </div>
</form>

@endsection

