@extends('layouts.dashboard.app')
@section('style')
@endsection
@section('content')
    <div class="container mt-1">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title text-info mb-3">Dossier {{ $dossier->ref }}
                            @if ($dossier->sinistre_douteux)
                                <span class="badge bg-success">Sinistre Douteux</span>
                            @endif
                        </h4>
                        <div class="table-responsive">
                            <table class="table mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Reference</th>
                                        <th>Matricule</th>
                                        <th>Compagnie</th>
                                        <th>Garantie</th>
                                        <th>Date Sinistre</th>
                                        <th>Date Reception</th>
                                        <th>Type de Dossier</th>
                                        <th>Mode</th>
                                        <th>Vehicule</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <input type="hidden" value="{{ $dossier->id }}" id="id">
                                        <td class="text-dark">{{ $dossier->ref ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->matricule ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->company->company ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->guarantee->guarantee ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->date_sinistre ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->date_reception ?? null }}</td>
                                        <td> <span
                                                class="badge badge-primary-lighten">{{ $dossier->typeexpertise->type ?? null }}</span>
                                        </td>
                                        <td> <span
                                                class="badge badge-success-lighten">{{ $dossier->mode->mode ?? null }}</span>
                                        </td>
                                        <td>{{ $dossier->vehiculemodel->name ?? null }}/{{ $dossier->vehiculemodel->brand->brand ?? null }}
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <!-- end table-responsive -->
                    </div>
                </div>
            </div> <!-- end col -->
        </div>
        <div class="card">
            <div class="card-body">
                <h4 class="card-title mb-5">Selectionner les Type de Documents : </h4>
                <div class="row mb-5" style="margin-left: 35px;">
                    <form method="POST" action="{{ route('signedurl.store') }}">
                        @csrf
                        <input type="hidden" name="dossier_id" value="{{ $dossier->id }}">
                        @foreach ($typedocuments as $type)
                            {{-- <div class="col-md-3 ">
                                <input class="form-check-input" type="checkbox" value="{{ $type->id }}"
                                    name="{{ $type->type }}" id="test1">
                                <label class="form-check-label">{{ $type->type }}</label>
                            </div> --}}
                            

                                <div class="form-check form-check-inline form-checkbox-warning col-2">
                                    <input type="checkbox" class="form-check-input mb-2" value="{{ $type->id }}"
                                        name="{{ $type->type }}" id="customSwitch3{{ $type->id }}">
                                    <label class="form-check-label fs-4"
                                        for="customSwitch3{{ $type->id }}">{{ $type->type }}</label>
                                </div>

                            
                        @endforeach
                        <div class="row mt-3">
                            <div class="col-6">
                                <button class="btn btn-success" type="submit"> Génerer Lien Externe</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    {{-- <form action=""></form>
@foreach ($typedocuments as $type)

@endforeach --}}
@endsection
