@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4">
        <div class="row ">
            <div class="col-md-12 d-flex">
                <div class="col-md-6 ">
                    <div class="card">
                        <div class="card-body d-flex">
                            <div class="col-md-6">
                                <img style="width: 200px" src="https://www.w3schools.com/howto/img_avatar.png" alt=""
                                    class="rounded-circle">
                            </div>
                            <div class="col-md-6">
                                <div class="row about-list">
                                    <h3>Utilisateur</h3>

                                    <div class="col-md-6">
                                        <div class="media">
                                            <label>Civilité :</label>
                                            <p>{{ $user->civility ?? null }}</p>
                                        </div>

                                        <div class="media">
                                            <label>Email</label>
                                            <p>{{ $user->email ?? null }}</p>
                                        </div>
                                        <div class="media">
                                            <label>Role</label>
                                            <p>{{ $user->role->role ?? null }}</p>
                                        </div>

                                    </div>
                                    <div class="col-md-6">
                                        <div class="media">
                                            <label>Nom</label>
                                            <p>{{ $user->name ?? null }}</p>
                                        </div>
                                        <div class="media">
                                            <label>Ville</label>
                                            <p>{{ $user->city->city ?? null }}</p>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body ">
                            <form action="{{ route('user.password') }}" method="post">
                                @csrf
                                @method('PUT')
                                <div class="form-group  mb-2">
                                    <label for="password">Nouveau Mot de Passe</label>
                                    <input type="password" name="password" value=""
                                        class="form-control @error('password') is-invalid @enderror">
                                    @error('password')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <button class="btn btn-warning" type="submit">Modifier</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endsection
