@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('Device.store') }}" method="post">
                            @csrf
                            <div class="form-group mb-3">
                                <label for="simpleinput" class="form-label">Mac Address</label>
                                <input type="text"
                                 id="simpleinput" name="mac_address"
                                    class="form-control @error('mac_address') is-invalid  @enderror">
                                @error('mac_address')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group  mb-2">
                                <label for="user_id">Nom Agent :</label>
                               <select class="form-select @error('user_id') is-invalid @enderror" name="user_id" id="">
                                @foreach ($users as $agent)
                                <option value="{{ $agent->id }}">{{ $agent->name }}</option>
                                @endforeach
                               </select>
                                @error('user_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="mr-3">
                                <button class="btn btn-primary" type="submit">Créer</button>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
