@extends('layouts.dashboard.app')

@section('content')
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="table table-striped" id="myTable">
                            <thead>
                                <tr>
                                    <th>Id</th>
                                    <th>Libelle</th>
                                    <th>Email</th>
                                    <th>Adresse</th>
                                    <th>Restaurer</th>

                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($garages as $garage)
                                    <tr>
                                        <td>{{ $garage->id  }}</td>
                                        <td>{{ $garage->libelle }}</td>
                                        <td>{{ $garage->email }}</td>
                                        <td>{{ $garage->adress ?? null }}</td>
                                        <td>
                                            <form action="{{ route('Garage.restore', [$garage->id]) }}" method="post">
                                                @csrf
                                                <button class="btn btn-sm btn-warning rounded-pill" type="submit">Restaurer</i></button>
                                            </form>
                                        </td>
                                    </tr>
                                    @empty
                                    <h3>Tableau Vide</h3>
                                @endforelse
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection

