<?php

namespace App\Policies;

use App\Models\Seuil;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class SeuilPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user)
    {
        if( $user->role_id === 4 || $user->hasPermission('naviguer_seuils') || $user->hasRolePermission('naviguer_seuils') ){
            return true;
        }
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Seuil  $seuil
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function view(User $user)
    {
        if( $user->role_id === 4 || $user->hasPermission('afficher_seuils') || $user->hasRolePermission('afficher_seuils') ){
            return true;
        }
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user)
    {
        if( $user->role_id === 4 || $user->hasPermission('ajouter_seuils') || $user->hasRolePermission('ajouter_seuils') ){
            return true;
        }
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Seuil  $seuil
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user)
    {
        if( $user->role_id === 4 || $user->hasPermission('modifier_seuils') || $user->hasRolePermission('modifier_seuils') ){
            return true;
        }
    }

    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Seuil  $seuil
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function delete(User $user)
    {
        //
    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Seuil  $seuil
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function restore(User $user)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Seuil  $seuil
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function forceDelete(User $user)
    {
        //
    }
}
