<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Devis extends Model
{
    use HasFactory;

    protected $fillable =
    [
        'montant_devis',
        'dossier_id',
        'devis_status_id',
        'devis',
        'taux_id',
        'ref', 'date_reception'
    ];

    public function dossier()
    {
        return $this->belongsTo(Dossier::class);
    }

    public function montant()
    {
        return $this->hasOne(Montant::class);
    }

    public function taux()
    {
        return $this->belongsTo(Taux::class);
    }

    public function status()
    {
        return $this->belongsTo(DevisStatus::class, 'devis_status_id');
    }

    public function devisstatus()
    {
        return $this->belongsToMany(DevisStatus::class, 'devis_status')
            ->withPivot('user_id')->withTimestamps();
    }

    public function piece()
    {
        return $this->belongsToMany(Piece::class, 'devis_piece')
        ->withPivot(['qte','prix_unitaire','etat','gravite', 'vetuste', 'remise', 'montant_ht','type_reparation_id','operation_id','vehicule_model_id'])
        ->using(DevisPiece::class)->withTrashed()->withTimestamps();
    }

    public function document()
    {
        return $this->belongsToMany(Document::class, 'document_devis')->withTimestamps();
    }
}
