<?php

namespace App\Http\Controllers;

use App\Models\TypeIngredient;
use Illuminate\Http\Request;

class TypeIngredientController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $types = TypeIngredient::all();
        return view('configuration.Types.ingredient.index',compact('types'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('configuration.Types.ingredient.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'type'=>'required|unique:type_ingredients,type'
        ]);
        TypeIngredient::create([
            'type'=> $request->type
        ]);
        return redirect()->route('TypeIngredient.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\TypeIngredient  $typeIngredient
     * @return \Illuminate\Http\Response
     */
    public function show(TypeIngredient $typeIngredient)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\TypeIngredient  $typeIngredient
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $type = TypeIngredient::whereId($id)->firstOrFail();
        return view('configuration.Types.ingredient.edit',compact('type'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\TypeIngredient  $typeIngredient
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'type'=>'required|unique:type_ingredients,type,'.$id
        ]);
        $type = TypeIngredient::whereId($id)->firstOrFail();
        $type->type = $request->type;
        $type->update();

        return redirect()->route('TypeIngredient.index');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\TypeIngredient  $typeIngredient
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $type = TypeIngredient::whereId($id)->firstOrFail();
        $type->delete();

        return redirect()->route('TypeIngredient.index');
    }
}
