<div class="mb-2 row mt-2">
    <div class="col-lg-12">

        <div class="card">
            <div class="card-body" style="display: flex; gap:4px;flex-wrap: wrap;">
                @if (
                    $user ||
                        Auth::user()->role_id == 4 ||
                        $dossier->dossier_status_id == 3 ||
                        Auth::user()->role_id == 6 ||
                        Auth::user()->role_id == 7)
                    @can('viewAny', App\Models\Meeting::class)
                        <a class="mb-2 btn btn-outline-primary" href="{{ route('Meeting.index', $dossier->id) }}"> Meeting
                        </a>
                    @endcan
                    @can('viewAny', App\Models\Devis::class)
                        <a class="mb-2 btn btn-outline-success" href="{{ route('Devis.index', $dossier->id) }}">Devis </a>
                    @endcan
                    @can('viewAny', App\Models\Facture::class)
                        <a class="mb-2  btn btn-outline-dark" href="{{ route('Facture.index', $dossier->id) }}"> Facture
                        </a>
                    @endcan
                    @can('viewAny', App\Models\Rapport::class)
                        <a class="mb-2  btn btn-outline-info" href="{{ route('Rapport.index', $dossier->id) }}"> Rapport
                        </a>
                    @endcan
                    @can('viewAny', App\Models\Ticket::class)
                    <a class="mb-2  btn btn-outline-danger" href="{{ route('Ticket.index', $dossier->id) }}"> Ticket({{ $ticketcount }})
                    </a>
                @endcan
                    {{-- @can('send', App\Models\Email::class)
                        <a class="mb-2 btn btn-outline-secondary" href="{{ route('Email.compose', $dossier->id) }}">
                            Email
                        </a>
                    @endcan --}}
                    @can('send', App\Models\Email::class)
                        <div class="dropdown">
                            <a class="btn btn-secondary dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-expanded="false">
                                Email
                            </a>

                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                                <li>
                                    @can('send', App\Models\Email::class)
                                        <a class="dropdown-item" href="{{ route('Email.compose', $dossier->id) }}">
                                            Email
                                        </a>
                                    @endcan
                                </li>
                                <li>
                                    @can('historique', App\Models\Dossier::class)
                                        <a href="{{ route('Email.historique', $dossier->id) }}"
                                            class="dropdown-item">Historique</a>
                                    @endcan
                                </li>
                            </ul>
                        </div>
                    @endcan

                    <div class="dropdown">
                        <a class="btn btn-primary dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            Documents
                        </a>

                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                            <li>
                                @can('viewAny', App\Models\Document::class)
                                    <a class="dropdown-item" href="{{ route('Document.index', $dossier->id) }}">
                                        Liste </a>
                                @endcan
                            </li>
                            @can('signer', App\Models\Document::class)
                                <li>
                                    <a class="dropdown-item" href="{{ route('Document.asigner', $dossier->id) }}">
                                        Signer </a>
                                </li>
                            @endcan
                            <li>
                                @can('create', App\Models\Document::class)
                                    <a href="{{ route('Document.create', $dossier->id) }}" class="dropdown-item">
                                        Télécharger </a>
                                @endcan
                            </li>
                            <li>
                                @can('create', App\Models\Document::class)
                                    <button class="dropdown-item" type="button" class="btn btn-info mt-4 mb-2"
                                        data-bs-toggle="modal" data-bs-target="#signup-modal">
                                        Téléchargement Rapide
                                    </button>
                                @endcan
                            </li>

                        </ul>
                    </div>
                    <div class="dropdown">
                        <a class="btn btn-success dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            Dossier
                        </a>

                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                            <li>
                                @can('update', $dossier)
                                    <a class="dropdown-item" href="{{ route('Dossier.edit', $dossier->id) }}">
                                        Modifier
                                    </a>
                                @endcan
                            </li>
                            @if ($dossier->dossier_status_id == 2)
                                <li>
                                    <a href="{{ route('ShockPoint.create', $dossier->id) }}" class="dropdown-item">
                                        Ajouter
                                        Points de Chock </a>
                                </li>
                            @endif
                            <li>
                                <a href="{{ route('notification.show', $dossier->id) }}" class="dropdown-item">
                                    Detail
                                </a>
                            </li>

                            {{-- <li>
                                @can('create', App\Models\Payment::class)
                                    <a class="dropdown-item" href="{{ route('Payment.create', $dossier->id) }}">
                                        Paiment </a>
                                @endcan
                            </li> --}}
                            <li>
                                @can('historique', App\Models\Dossier::class)
                                    <a class="dropdown-item" href="{{ route('Dossier.historique', $dossier->id) }}">
                                        Historique
                                    </a>
                                @endcan
                            </li>
                            <li>
                                    <a class="dropdown-item" href="{{ route('Demande.dossier', $dossier->id) }}">
                                        Demandes
                                    </a>
                            </li>
                            <li>
                                @can('douteux', App\Models\Dossier::class)
                                    <form action="{{ route('Dossier.douteux', $dossier->id) }}" method="post">
                                        @csrf
                                        @method('PUT')

                                        <button class="dropdown-item">
                                            @if ($dossier->sinistre_douteux != 1)
                                                Declarer Sinistre Douteux
                                            @else
                                                Declarer Sinistre Non Douteux
                                            @endif
                                        </button>
                                    </form>
                                @endcan
                            </li>
                            @if ($dossier->dossier_status_id == 3 || $dossier->update == 1 || $dossier->dossier_status_id == 1)
                                @can('open', App\Models\Dossier::class)
                                    <li>
                                        <form action="{{ route('Dossier.open', $dossier->id) }}" method="post">
                                            @csrf
                                            @method('PUT')
                                            <button type="submit" class="dropdown-item">ReOuvrir
                                                Dossier</button>
                                        </form>
                                    </li>
                                @endcan
                            @endif
                            @can('delete', App\Models\Dossier::class)
                                <li>
                                    <form action="{{ route('Dossier.destroy', $dossier->id) }}" method="post">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="dropdown-item">Supprimer</button>
                                    </form>

                                </li>
                            @endcan
                            @if ($dossier->dossier_status_id != 3 && $dossier->update == 1)
                                <li>
                                    @can('cloturer', App\Models\Dossier::class)
                                        <a href="{{ route('Dossier.facturation', $dossier->id) }}" class="dropdown-item">
                                            Cloturer
                                        </a>
                                    @endcan
                                </li>
                            @endif

                            @if ($dossier->dossier_status_id == 2)
                                <li>
                                    @can('annuler', App\Models\Dossier::class)
                                        <form action="{{ route('Dossier.annuler') }}" method="post">
                                            @csrf
                                            <input type="hidden" name="dossier_id" value="{{ $dossier->id }}">
                                            <button class="dropdown-item">
                                                Annuler
                                            </button>
                                        </form>
                                    @endcan
                                </li>
                            @endif
                        </ul>
                    </div>
                    @if (Auth::user()->role_id != 6)

                        <div class="dropdown">
                            <a class="btn btn-danger dropdown-toggle" href="#" role="button"
                                id="dropdownMenuLink" data-bs-toggle="dropdown" aria-expanded="false">
                                AUTRE
                            </a>

                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                                @if ($dossier->typeexpertise)
                                    @if (
                                        $dossier->typeexpertise->id == 3 ||
                                            $dossier->typeexpertise->id == 4 ||
                                            $dossier->type_expertise_id == 5 ||
                                            $dossier->typeexpertise->id == 6 ||
                                            $dossier->type_expertise_id == 7 )
                                        {{-- devis deja accord --}}
                                        @if ($d == 1)
                                            <li>
                                                <a target="_blank" href="{{ route('pdf.avis', $dossier->id) }}"
                                                    class="dropdown-item">
                                                    Avis Dommage
                                                </a>
                                            </li>

                                            <li>
                                                <a target="_blank" class="dropdown-item "
                                                    href="{{ route('pdf.preliminaire', $dossier->id) }}">
                                                    Rapport Preliminaire
                                                </a>
                                            </li>

                                            {{-- <li>
                                                <a target="_blank" class="dropdown-item "
                                                    href="{{ route('pdf.preliminaire', $dossier->id) }}">
                                                    Accord su devis
                                                </a>
                                            </li> --}}
                                        @endif
                                        <li>
                                            @if ($dossier->contradictoire)
                                                <a class="dropdown-item"
                                                    href="{{ route('Contradictoire.edit', $dossier->id) }}">
                                                    Modifier Expert Adverse </a>
                                            @else
                                                <a class="dropdown-item"
                                                    href="{{ route('Contradictoire.create', $dossier->id) }}">
                                                    Expert Adverse </a>
                                            @endif
                                        </li>

                                    @endif
                                @endif
                                @if ($dossier->mode_id == 7 || $dossier->type_expertise_id == 14)
                                    <li>
                                        <a class="dropdown-item" target="_blank"
                                            href="{{ route('pdf.forfait', $dossier->id) }}">
                                            Fiche Forfaitaire
                                        </a>
                                    </li>
                                @endif
                                @can('create', App\Models\Demande::class)
                                    <li>
                                        @can('create', App\Models\Demande::class)
                                            <a class="dropdown-item"
                                                href="{{ route('Demande.create', $dossier->id) }}">Demande
                                            </a>
                                        @endcan


                                    </li>

                                @endcan
                                <li>
                                    @can('viewAny', App\Models\Demande::class)
                                        <a class="dropdown-item"
                                            href="{{ route('Dossier.demandesHistorique', $dossier->id) }}">Demandes Historiques
                                        </a>
                                    @endcan


                                </li>
                                @if ($dossier->mode_id == 2 || $dossier->mode_id == 3)
                                    <li>
                                        <a class="dropdown-item"
                                            href="{{ route('Marketvalue.create', $dossier->id) }}">Valeur
                                            Vénale</a>
                                    </li>
                                @endif
                                <li>
                                    <a target="_blank" class="dropdown-item"
                                        href="{{ route('pdf.req', $dossier->id) }}">Requete</a>
                                </li>
                                @if ($dossier->sinistre_douteux)
                                    <li>
                                        <a class="dropdown-item" href="{{ route('dossier.ref', $dossier->id) }}">
                                            Rapport Technique
                                        </a>
                                    </li>
                                @endif
                                <li>
                                    @if ($dossier->type_expertise_id == 10)
                                            <a class="dropdown-item" target="_blank"
                                                href="{{ route('pdf.fft', $dossier->id) }}">
                                                Fiche
                                                Fin
                                                Travaux </a>

                                    @endif
                                </li>
                                <li>
                                        @if ($rap > 0)
                                            <a class="dropdown-item" target="_blank"
                                                href="{{ route('pdf.canevas', $dossier->id) }}">
                                                Canevas
                                            </a>
                                        @endif

                                </li>
                                <li>
                                    <a class="dropdown-item" href="{{ route('Dossier.url', $dossier->id) }}">
                                        Lien Externe
                                    </a>
                                </li>
                                <li>
                                    @can('viewAny', App\Models\Call::class)
                                           <a class="dropdown-item">
                                            <form action="{{ route('create_class') }}" method="post">
                                                @csrf
                                                <input type="hidden" name="dossier_id"
                                                    value="{{ $dossier->id ?? null }}">

                                                <button type="submit"> Appel Video </button>

                                            </form>


                                        </a>
                                    @endcan
                                </li>
                                <li>
                                    @can('viewAny', App\Models\Call::class)
                                        <a class="dropdown-item"
                                            href="{{ route('call.saved', ['dossier_id' => $dossier->id]) }}">
                                            Appel Video Enregistrement
                                        </a>
                                    @endcan
                                </li>

                            </ul>
                        </div>
                    @endif

                @endif
                @if (Auth::user()->role_id == 3 || Auth::user()->role_id == 4)
                    @can('cloturer', App\Models\Dossier::class)
                        @if ($dossier->dossier_status_id == 2)
                            @if ($rap > 0)
                                <ul>
                                    <li>

                                        <a href="{{ route('Dossier.facturation', $dossier->id) }}"
                                            class="btn btn-outline-warning">
                                            Cloturer
                                        </a>

                                    </li>
                                </ul>
                            @endif
                        @endif
                    @endcan
                @endif
                @if (!$user && Auth::user()->role_id != 3 && Auth::user()->role_id != 4)
                    @can('create', App\Models\Demande::class)
                        <a class="btn btn-outline-primary" href="{{ route('Demande.create', $dossier->id) }}">
                            Demande
                        </a>
                    @endcan
                @endif

            </div>
        </div>


    </div>

</div>
<script defer src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.4.0/dropzone.js"></script>
<script type="text/javascript">
    Dropzone.options.dropzone = {
        maxFilesize: 12,
        renameFile: function(file) {
            var dt = new Date();
            var time = dt.getTime();
            return time + file.name;
        },
        acceptedFiles: ".jpeg,.jpg,.png",
        addRemoveLinks: true,
        timeout: 50000,
        removedfile: function(file) {
            var name = file.upload.filename;
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                },
                type: 'POST',
                url: '{{ route('Document.fileStore') }}',
                data: {
                    filename: name
                },
                success: function(data) {
                    console.log("File has been successfully removed!!");
                },
                error: function(e) {
                    console.log(e);
                }
            });
            var fileRef;
            return (fileRef = file.previewElement) != null ?
                fileRef.parentNode.removeChild(file.previewElement) : void 0;
        },

        success: function(file, response) {
            console.log(response);
        },
        error: function(file, response) {
            return false;
        }
    };
</script>
