@extends('layouts.dashboard.app')

@section('style')
<style>
.shock-card {
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 2px 12px rgba(0,0,0,0.08);
    border: 1px solid #e5e7eb;
    max-width: 1000px;
    margin: 20px auto;
}

.shock-header {
    background: #1f2937;
    color: #fff;
    padding: 16px 20px;
    border-radius: 12px 12px 0 0;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.shock-header h5 {
    margin: 0;
    font-size: 16px;
    font-weight: 600;
}

.count-badge {
    background: #f97316;
    padding: 6px 14px;
    border-radius: 20px;
    font-size: 13px;
    font-weight: 600;
}

.shock-body {
    padding: 24px;
}

.car-container {
    display: flex;
    justify-content: center;
    background: #f9fafb;
    border-radius: 8px;
    padding: 20px;
    border: 1px solid #e5e7eb;
}

.car-container svg {
    max-width: 500px;
    width: 100%;
    height: auto;
}

/* Zone styling - NO ANIMATIONS */
.zone {
    cursor: pointer;
    transition: fill 0.15s ease;
}

.zone:hover {
    fill: #86efac !important;
}

.zone.selected {
    fill: #f97316 !important;
}

/* Selected points list */
.selected-section {
    margin-top: 20px;
    padding: 16px;
    background: #f9fafb;
    border-radius: 8px;
    border: 1px solid #e5e7eb;
}

.selected-title {
    font-size: 13px;
    font-weight: 600;
    color: #374151;
    margin-bottom: 12px;
}

.selected-list {
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
    min-height: 40px;
}

.selected-tag {
    background: #f97316;
    color: #fff;
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 500;
    display: inline-flex;
    align-items: center;
    gap: 8px;
}

.selected-tag .remove {
    cursor: pointer;
    font-size: 14px;
    opacity: 0.8;
}

.selected-tag .remove:hover {
    opacity: 1;
}

.empty-text {
    color: #9ca3af;
    font-size: 13px;
}

/* Custom point input */
.custom-section {
    margin-top: 16px;
    padding: 16px;
    background: #fff;
    border-radius: 8px;
    border: 1px solid #e5e7eb;
}

.custom-title {
    font-size: 13px;
    font-weight: 600;
    color: #374151;
    margin-bottom: 10px;
}

.custom-form {
    display: flex;
    gap: 10px;
}

.custom-input {
    flex: 1;
    border: 1px solid #d1d5db;
    border-radius: 6px;
    padding: 10px 14px;
    font-size: 14px;
}

.custom-input:focus {
    outline: none;
    border-color: #f97316;
}

.custom-btn {
    background: #7c3aed;
    color: #fff;
    border: none;
    border-radius: 6px;
    padding: 10px 20px;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
}

.custom-btn:hover {
    background: #6d28d9;
}

.custom-tags {
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
    margin-top: 12px;
}

.custom-tag {
    background: #7c3aed;
    color: #fff;
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 500;
    display: inline-flex;
    align-items: center;
    gap: 8px;
}

/* Actions */
.actions {
    display: flex;
    gap: 12px;
    justify-content: flex-end;
    margin-top: 20px;
    padding-top: 20px;
    border-top: 1px solid #e5e7eb;
}

.btn-save {
    background: #10b981;
    color: #fff;
    border: none;
    border-radius: 8px;
    padding: 12px 28px;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
}

.btn-save:hover {
    background: #059669;
}

.btn-save:disabled {
    opacity: 0.6;
    cursor: not-allowed;
}

.btn-cancel {
    background: #f3f4f6;
    color: #4b5563;
    border: 1px solid #d1d5db;
    border-radius: 8px;
    padding: 12px 24px;
    font-size: 14px;
    font-weight: 600;
    text-decoration: none;
}

.btn-cancel:hover {
    background: #e5e7eb;
    color: #374151;
}

/* Tooltip */
.tooltip-box {
    position: fixed;
    background: #1f2937;
    color: #fff;
    padding: 8px 12px;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 500;
    pointer-events: none;
    opacity: 0;
    z-index: 1000;
    white-space: nowrap;
}

.tooltip-box.show {
    opacity: 1;
}

/* Legend */
.legend {
    display: flex;
    justify-content: center;
    gap: 20px;
    margin-top: 16px;
    font-size: 12px;
    color: #6b7280;
}

.legend-item {
    display: flex;
    align-items: center;
    gap: 6px;
}

.legend-color {
    width: 16px;
    height: 12px;
    border-radius: 3px;
}

.legend-color.body { background: #d1d5db; }
.legend-color.glass { background: #93c5fd; }
.legend-color.wheel { background: #4b5563; }
.legend-color.selected { background: #f97316; }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h4 class="mb-1">Points de Choc</h4>
                    <p class="text-muted mb-0">Dossier: {{ $dossier->ref ?? 'N/A' }} | {{ $dossier->matricule ?? '' }}</p>
                </div>
                <a href="{{ route('Dossier.show', $dossier->id) }}" class="btn btn-outline-secondary">
                    <i class="mdi mdi-arrow-left"></i> Retour
                </a>
            </div>
        </div>
    </div>

    <div class="shock-card">
        <div class="shock-header">
            <h5><i class="mdi mdi-car-side me-2"></i>Sélection des Points d'Impact</h5>
            <span class="count-badge" id="countBadge">0 sélectionné</span>
        </div>

        <div class="shock-body">
            <form id="shockForm" method="POST" action="{{ route('ShockPoint.store') }}">
                @csrf
                <input type="hidden" name="dossier_id" value="{{ $dossier->id }}">
                <input type="hidden" name="points" id="pointsInput">
                <input type="hidden" name="custom_points" id="customPointsInput">
                <input type="hidden" name="img" id="imgInput">

                <!-- Car Diagram -->
                <div class="car-container">
                    <svg id="carSvg" viewBox="0 0 400 680" xmlns="http://www.w3.org/2000/svg">
                        <!-- Background -->
                        <rect width="400" height="680" fill="#f9fafb"/>
                        
                        <!-- Car Outline Shadow -->
                        <ellipse cx="200" cy="650" rx="120" ry="15" fill="#e5e7eb"/>
                        
                        <!-- ===== FRONT BUMPER ===== -->
                        <path id="z1" data-id="1" data-name="Pare-chocs Avant" class="zone"
                              d="M100,50 L300,50 Q320,50 320,70 L320,85 L80,85 L80,70 Q80,50 100,50 Z"
                              fill="#d1d5db" stroke="#9ca3af" stroke-width="1"/>
                        
                        <!-- Front Bumper Left Corner -->
                        <path id="z36" data-id="36" data-name="Coin Pare-chocs AV Gauche" class="zone"
                              d="M80,70 L80,85 L60,85 L60,75 Q60,65 70,60 L80,70 Z"
                              fill="#d1d5db" stroke="#9ca3af" stroke-width="1"/>
                        
                        <!-- Front Bumper Right Corner -->
                        <path id="z37" data-id="37" data-name="Coin Pare-chocs AV Droit" class="zone"
                              d="M320,70 L330,60 Q340,65 340,75 L340,85 L320,85 Z"
                              fill="#d1d5db" stroke="#9ca3af" stroke-width="1"/>
                        
                        <!-- Grille -->
                        <rect id="z2" data-id="2" data-name="Calandre" class="zone"
                              x="130" y="55" width="140" height="25" rx="3"
                              fill="#4b5563" stroke="#374151" stroke-width="1"/>
                        
                        <!-- Left Headlight -->
                        <path id="z26" data-id="26" data-name="Phare Avant Gauche" class="zone"
                              d="M85,55 L125,55 L125,80 L85,80 Q80,75 80,70 L85,55 Z"
                              fill="#fef3c7" stroke="#fbbf24" stroke-width="1"/>
                        
                        <!-- Right Headlight -->
                        <path id="z27" data-id="27" data-name="Phare Avant Droit" class="zone"
                              d="M275,55 L315,55 L320,70 Q320,75 315,80 L275,80 Z"
                              fill="#fef3c7" stroke="#fbbf24" stroke-width="1"/>
                        
                        <!-- ===== HOOD ===== -->
                        <path id="z3" data-id="3" data-name="Capot" class="zone"
                              d="M80,90 L320,90 L310,180 Q200,190 90,180 Z"
                              fill="#d1d5db" stroke="#9ca3af" stroke-width="1"/>
                        
                        <!-- ===== FRONT FENDERS ===== -->
                        <path id="z17" data-id="17" data-name="Aile Avant Gauche" class="zone"
                              d="M55,90 L80,90 L90,180 L65,175 Q45,145 55,90 Z"
                              fill="#d1d5db" stroke="#9ca3af" stroke-width="1"/>
                        
                        <path id="z8" data-id="8" data-name="Aile Avant Droite" class="zone"
                              d="M320,90 L345,90 Q355,145 335,175 L310,180 Z"
                              fill="#d1d5db" stroke="#9ca3af" stroke-width="1"/>
                        
                        <!-- ===== FRONT WHEELS ===== -->
                        <ellipse id="z18" data-id="18" data-name="Roue Avant Gauche" class="zone"
                                 cx="55" cy="140" rx="22" ry="45"
                                 fill="#4b5563" stroke="#374151" stroke-width="2"/>
                        <ellipse cx="55" cy="140" rx="10" ry="20" fill="#6b7280" pointer-events="none"/>
                        
                        <ellipse id="z9" data-id="9" data-name="Roue Avant Droite" class="zone"
                                 cx="345" cy="140" rx="22" ry="45"
                                 fill="#4b5563" stroke="#374151" stroke-width="2"/>
                        <ellipse cx="345" cy="140" rx="10" ry="20" fill="#6b7280" pointer-events="none"/>
                        
                        <!-- ===== WINDSHIELD ===== -->
                        <path id="z28" data-id="28" data-name="Pare-brise" class="zone"
                              d="M90,185 Q200,200 310,185 L300,245 Q200,260 100,245 Z"
                              fill="#bfdbfe" stroke="#3b82f6" stroke-width="1.5"/>
                        
                        <!-- A-Pillars -->
                        <path d="M90,185 L100,245" stroke="#6b7280" stroke-width="5" stroke-linecap="round" pointer-events="none"/>
                        <path d="M310,185 L300,245" stroke="#6b7280" stroke-width="5" stroke-linecap="round" pointer-events="none"/>
                        
                        <!-- ===== MIRRORS ===== -->
                        <rect id="z34" data-id="34" data-name="Rétroviseur Gauche" class="zone"
                              x="58" y="195" width="25" height="35" rx="5"
                              fill="#d1d5db" stroke="#9ca3af" stroke-width="1"/>
                        
                        <rect id="z30" data-id="30" data-name="Rétroviseur Droit" class="zone"
                              x="317" y="195" width="25" height="35" rx="5"
                              fill="#d1d5db" stroke="#9ca3af" stroke-width="1"/>
                        
                        <!-- ===== ROOF ===== -->
                        <path id="z4" data-id="4" data-name="Toit" class="zone"
                              d="M100,250 Q200,265 300,250 L305,450 Q200,465 95,450 Z"
                              fill="#d1d5db" stroke="#9ca3af" stroke-width="1"/>
                        
                        <!-- Sunroof -->
                        <rect id="z5" data-id="5" data-name="Toit Ouvrant" class="zone"
                              x="145" y="300" width="110" height="80" rx="6"
                              fill="#bfdbfe" stroke="#3b82f6" stroke-width="1"/>
                        
                        <!-- ===== LEFT DOORS ===== -->
                        <path id="z19" data-id="19" data-name="Porte Avant Gauche" class="zone"
                              d="M55,185 L95,250 L95,355 L55,355 Z"
                              fill="#d1d5db" stroke="#9ca3af" stroke-width="1"/>
                        
                        <path id="z20" data-id="20" data-name="Porte Arrière Gauche" class="zone"
                              d="M55,360 L95,360 L95,460 L55,455 Z"
                              fill="#d1d5db" stroke="#9ca3af" stroke-width="1"/>
                        
                        <!-- Left Windows -->
                        <rect id="z24" data-id="24" data-name="Vitre Avant Gauche" class="zone"
                              x="60" y="255" width="30" height="90" rx="3"
                              fill="#bfdbfe" stroke="#3b82f6" stroke-width="1"/>
                        
                        <rect id="z25" data-id="25" data-name="Vitre Arrière Gauche" class="zone"
                              x="60" y="365" width="30" height="85" rx="3"
                              fill="#bfdbfe" stroke="#3b82f6" stroke-width="1"/>
                        
                        <!-- ===== RIGHT DOORS ===== -->
                        <path id="z10" data-id="10" data-name="Porte Avant Droite" class="zone"
                              d="M305,250 L345,185 L345,355 L305,355 Z"
                              fill="#d1d5db" stroke="#9ca3af" stroke-width="1"/>
                        
                        <path id="z11" data-id="11" data-name="Porte Arrière Droite" class="zone"
                              d="M305,360 L345,360 L345,455 L305,460 Z"
                              fill="#d1d5db" stroke="#9ca3af" stroke-width="1"/>
                        
                        <!-- Right Windows -->
                        <rect id="z15" data-id="15" data-name="Vitre Avant Droite" class="zone"
                              x="310" y="255" width="30" height="90" rx="3"
                              fill="#bfdbfe" stroke="#3b82f6" stroke-width="1"/>
                        
                        <rect id="z16" data-id="16" data-name="Vitre Arrière Droite" class="zone"
                              x="310" y="365" width="30" height="85" rx="3"
                              fill="#bfdbfe" stroke="#3b82f6" stroke-width="1"/>
                        
                        <!-- ===== SILLS ===== -->
                        <rect id="z32" data-id="32" data-name="Bas de Caisse Gauche" class="zone"
                              x="50" y="185" width="8" height="385" rx="2"
                              fill="#6b7280" stroke="#4b5563" stroke-width="1"/>
                        
                        <rect id="z31" data-id="31" data-name="Bas de Caisse Droit" class="zone"
                              x="342" y="185" width="8" height="385" rx="2"
                              fill="#6b7280" stroke="#4b5563" stroke-width="1"/>
                        
                        <!-- ===== REAR FENDERS ===== -->
                        <path id="z21" data-id="21" data-name="Aile Arrière Gauche" class="zone"
                              d="M55,460 L95,465 L90,555 Q45,540 50,490 Z"
                              fill="#d1d5db" stroke="#9ca3af" stroke-width="1"/>
                        
                        <path id="z12" data-id="12" data-name="Aile Arrière Droite" class="zone"
                              d="M305,465 L345,460 Q355,540 310,555 Z"
                              fill="#d1d5db" stroke="#9ca3af" stroke-width="1"/>
                        
                        <!-- ===== REAR WHEELS ===== -->
                        <ellipse id="z22" data-id="22" data-name="Roue Arrière Gauche" class="zone"
                                 cx="55" cy="510" rx="22" ry="45"
                                 fill="#4b5563" stroke="#374151" stroke-width="2"/>
                        <ellipse cx="55" cy="510" rx="10" ry="20" fill="#6b7280" pointer-events="none"/>
                        
                        <ellipse id="z13" data-id="13" data-name="Roue Arrière Droite" class="zone"
                                 cx="345" cy="510" rx="22" ry="45"
                                 fill="#4b5563" stroke="#374151" stroke-width="2"/>
                        <ellipse cx="345" cy="510" rx="10" ry="20" fill="#6b7280" pointer-events="none"/>
                        
                        <!-- ===== REAR WINDOW ===== -->
                        <path id="z29" data-id="29" data-name="Lunette Arrière" class="zone"
                              d="M95,455 Q200,470 305,455 L310,510 Q200,525 90,510 Z"
                              fill="#bfdbfe" stroke="#3b82f6" stroke-width="1.5"/>
                        
                        <!-- C-Pillars -->
                        <path d="M95,455 L90,510" stroke="#6b7280" stroke-width="5" stroke-linecap="round" pointer-events="none"/>
                        <path d="M305,455 L310,510" stroke="#6b7280" stroke-width="5" stroke-linecap="round" pointer-events="none"/>
                        
                        <!-- ===== TRUNK ===== -->
                        <path id="z6" data-id="6" data-name="Coffre" class="zone"
                              d="M90,515 Q200,530 310,515 L305,580 Q200,595 95,580 Z"
                              fill="#d1d5db" stroke="#9ca3af" stroke-width="1"/>
                        
                        <!-- ===== TAIL LIGHTS ===== -->
                        <rect id="z23" data-id="23" data-name="Feu Arrière Gauche" class="zone"
                              x="85" y="575" width="25" height="30" rx="3"
                              fill="#fca5a5" stroke="#ef4444" stroke-width="1"/>
                        
                        <rect id="z14" data-id="14" data-name="Feu Arrière Droit" class="zone"
                              x="290" y="575" width="25" height="30" rx="3"
                              fill="#fca5a5" stroke="#ef4444" stroke-width="1"/>
                        
                        <!-- ===== REAR BUMPER ===== -->
                        <path id="z7" data-id="7" data-name="Pare-chocs Arrière" class="zone"
                              d="M80,585 L110,610 L290,610 L320,585 L335,605 Q335,635 300,640 L100,640 Q65,635 65,605 Z"
                              fill="#d1d5db" stroke="#9ca3af" stroke-width="1"/>
                        
                        <!-- Rear Bumper Corners -->
                        <path id="z38" data-id="38" data-name="Coin Pare-chocs AR Gauche" class="zone"
                              d="M65,605 L80,585 L80,610 L65,620 Z"
                              fill="#d1d5db" stroke="#9ca3af" stroke-width="1"/>
                        
                        <path id="z39" data-id="39" data-name="Coin Pare-chocs AR Droit" class="zone"
                              d="M320,585 L335,605 L335,620 L320,610 Z"
                              fill="#d1d5db" stroke="#9ca3af" stroke-width="1"/>
                        
                        <!-- License Plate Rear -->
                        <rect id="z35" data-id="35" data-name="Plaque Arrière" class="zone"
                              x="155" y="615" width="90" height="18" rx="2"
                              fill="#fff" stroke="#9ca3af" stroke-width="1"/>
                        
                        <!-- License Plate Front -->
                        <rect id="z33" data-id="33" data-name="Plaque Avant" class="zone"
                              x="165" y="62" width="70" height="14" rx="2"
                              fill="#fff" stroke="#9ca3af" stroke-width="1"/>
                    </svg>
                </div>

                <!-- Legend -->
                <div class="legend">
                    <div class="legend-item"><span class="legend-color body"></span> Carrosserie</div>
                    <div class="legend-item"><span class="legend-color glass"></span> Vitrage</div>
                    <div class="legend-item"><span class="legend-color wheel"></span> Roues</div>
                    <div class="legend-item"><span class="legend-color selected"></span> Sélectionné</div>
                </div>

                <!-- Selected Points -->
                <div class="selected-section">
                    <div class="selected-title">Points sélectionnés:</div>
                    <div class="selected-list" id="selectedList">
                        <span class="empty-text">Cliquez sur les zones du véhicule pour les sélectionner</span>
                    </div>
                </div>

                <!-- Custom Points -->
                <div class="custom-section">
                    <div class="custom-title">Ajouter un point personnalisé:</div>
                    <div class="custom-form">
                        <input type="text" id="customInput" class="custom-input" 
                               placeholder="Ex: Jante alu, Antenne, Becquet..." maxlength="80">
                        <button type="button" id="addCustomBtn" class="custom-btn">Ajouter</button>
                    </div>
                    <div class="custom-tags" id="customTags"></div>
                </div>

                <!-- Actions -->
                <div class="actions">
                    <a href="{{ route('Dossier.show', $dossier->id) }}" class="btn-cancel">Annuler</a>
                    <button type="button" id="saveBtn" class="btn-save">
                        <i class="mdi mdi-check me-1"></i> Enregistrer
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div id="tooltip" class="tooltip-box"></div>
@endsection

@section('script')
<script>
(function() {
    // Zone names
    var ZONES = {
        1: 'Pare-chocs Avant',
        2: 'Calandre',
        3: 'Capot',
        4: 'Toit',
        5: 'Toit Ouvrant',
        6: 'Coffre',
        7: 'Pare-chocs Arrière',
        8: 'Aile Avant Droite',
        9: 'Roue Avant Droite',
        10: 'Porte Avant Droite',
        11: 'Porte Arrière Droite',
        12: 'Aile Arrière Droite',
        13: 'Roue Arrière Droite',
        14: 'Feu Arrière Droit',
        15: 'Vitre Avant Droite',
        16: 'Vitre Arrière Droite',
        17: 'Aile Avant Gauche',
        18: 'Roue Avant Gauche',
        19: 'Porte Avant Gauche',
        20: 'Porte Arrière Gauche',
        21: 'Aile Arrière Gauche',
        22: 'Roue Arrière Gauche',
        23: 'Feu Arrière Gauche',
        24: 'Vitre Avant Gauche',
        25: 'Vitre Arrière Gauche',
        26: 'Phare Avant Gauche',
        27: 'Phare Avant Droit',
        28: 'Pare-brise',
        29: 'Lunette Arrière',
        30: 'Rétroviseur Droit',
        31: 'Bas de Caisse Droit',
        32: 'Bas de Caisse Gauche',
        33: 'Plaque Avant',
        34: 'Rétroviseur Gauche',
        35: 'Plaque Arrière',
        36: 'Coin PC AV Gauche',
        37: 'Coin PC AV Droit',
        38: 'Coin PC AR Gauche',
        39: 'Coin PC AR Droit'
    };

    // State
    var selected = new Set();
    var customPoints = [];

    // Load existing
    @if(isset($dossier) && $dossier->shockpoint)
        @foreach($dossier->shockpoint as $sp)
            selected.add({{ $sp->id }});
        @endforeach
    @endif

    // Elements
    var zones = document.querySelectorAll('.zone');
    var tooltip = document.getElementById('tooltip');
    var selectedList = document.getElementById('selectedList');
    var countBadge = document.getElementById('countBadge');
    var customInput = document.getElementById('customInput');
    var customTags = document.getElementById('customTags');

    // Update display
    function update() {
        // Update SVG
        zones.forEach(function(z) {
            var id = parseInt(z.dataset.id);
            z.classList.toggle('selected', selected.has(id));
        });

        // Update selected list
        var html = '';
        selected.forEach(function(id) {
            html += '<span class="selected-tag" data-id="' + id + '">' + 
                    (ZONES[id] || 'Zone ' + id) + 
                    '<span class="remove" onclick="window.removeZone(' + id + ')">×</span></span>';
        });
        customPoints.forEach(function(name, i) {
            html += '<span class="selected-tag" style="background:#7c3aed">' + 
                    escapeHtml(name) + 
                    '<span class="remove" onclick="window.removeCustom(' + i + ')">×</span></span>';
        });
        
        if (!html) {
            html = '<span class="empty-text">Cliquez sur les zones du véhicule pour les sélectionner</span>';
        }
        selectedList.innerHTML = html;

        // Update custom tags
        var customHtml = '';
        customPoints.forEach(function(name, i) {
            customHtml += '<span class="custom-tag">' + escapeHtml(name) + 
                          '<span class="remove" onclick="window.removeCustom(' + i + ')">×</span></span>';
        });
        customTags.innerHTML = customHtml;

        // Update count
        var total = selected.size + customPoints.length;
        countBadge.textContent = total + ' sélectionné' + (total !== 1 ? 's' : '');

        // Update hidden inputs
        document.getElementById('pointsInput').value = Array.from(selected).join(',');
        document.getElementById('customPointsInput').value = JSON.stringify(customPoints);
    }

    function escapeHtml(text) {
        var div = document.createElement('div');
        div.textContent = text;
        return div.innerHTML;
    }

    // Toggle zone
    function toggleZone(id) {
        if (selected.has(id)) {
            selected.delete(id);
        } else {
            selected.add(id);
        }
        update();
    }

    // Global remove functions
    window.removeZone = function(id) {
        selected.delete(id);
        update();
    };

    window.removeCustom = function(index) {
        customPoints.splice(index, 1);
        update();
    };

    // Zone click handlers
    zones.forEach(function(zone) {
        zone.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            toggleZone(parseInt(this.dataset.id));
        });

        zone.addEventListener('mouseenter', function(e) {
            tooltip.textContent = this.dataset.name;
            tooltip.classList.add('show');
        });

        zone.addEventListener('mousemove', function(e) {
            tooltip.style.left = (e.clientX + 10) + 'px';
            tooltip.style.top = (e.clientY + 10) + 'px';
        });

        zone.addEventListener('mouseleave', function() {
            tooltip.classList.remove('show');
        });
    });

    // Add custom point
    document.getElementById('addCustomBtn').addEventListener('click', addCustomPoint);
    customInput.addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
            addCustomPoint();
        }
    });

    function addCustomPoint() {
        var name = customInput.value.trim();
        if (!name) return;
        
        // Check duplicate
        var lower = name.toLowerCase();
        if (customPoints.some(function(n) { return n.toLowerCase() === lower; })) {
            alert('Ce point existe déjà');
            return;
        }
        
        customPoints.push(name);
        customInput.value = '';
        update();
    }

    // Save
    document.getElementById('saveBtn').addEventListener('click', function() {
        var btn = this;
        btn.disabled = true;
        btn.innerHTML = '<i class="mdi mdi-loading mdi-spin me-1"></i> Enregistrement...';

        // Generate image
        try {
            var svg = document.getElementById('carSvg');
            var data = new XMLSerializer().serializeToString(svg);
            var canvas = document.createElement('canvas');
            canvas.width = 400;
            canvas.height = 680;
            var ctx = canvas.getContext('2d');
            var img = new Image();
            
            img.onload = function() {
                ctx.fillStyle = '#f9fafb';
                ctx.fillRect(0, 0, 400, 680);
                ctx.drawImage(img, 0, 0);
                document.getElementById('imgInput').value = canvas.toDataURL('image/png');
                document.getElementById('shockForm').submit();
            };
            
            img.onerror = function() {
                document.getElementById('shockForm').submit();
            };
            
            img.src = 'data:image/svg+xml;base64,' + btoa(unescape(encodeURIComponent(data)));
        } catch (e) {
            document.getElementById('shockForm').submit();
        }
    });

    // Init
    update();
})();
</script>
@endsection