

<?php $__env->startSection('style'); ?>
<style>
/* ============================================
   MODERN SEARCH BOX DESIGN
   ============================================ */
.search-container {
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
    border-radius: 16px;
    padding: 20px 25px;
    margin-bottom: 25px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
}

.search-container .search-title {
    color: rgba(255, 255, 255, 0.7);
    font-size: 12px;
    text-transform: uppercase;
    letter-spacing: 1px;
    margin-bottom: 12px;
    font-weight: 600;
}

.search-container .search-form {
    display: flex;
    align-items: center;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 50px;
    overflow: hidden;
    border: 1px solid rgba(255, 255, 255, 0.1);
    transition: all 0.3s ease;
}

.search-container .search-form:focus-within {
    background: rgba(255, 255, 255, 0.15);
    border-color: rgba(16, 185, 129, 0.5);
    box-shadow: 0 0 0 4px rgba(16, 185, 129, 0.1);
}

.search-container .search-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 0 5px 0 20px;
    color: rgba(255, 255, 255, 0.5);
}

.search-container .search-icon i {
    font-size: 20px;
}

.search-container .search-input {
    flex: 1;
    background: transparent;
    border: none;
    color: #fff;
    padding: 15px;
    font-size: 15px;
    outline: none;
}

.search-container .search-input::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.search-container .search-input::-webkit-search-cancel-button {
    -webkit-appearance: none;
    appearance: none;
}

.search-container .search-btn {
    background: #10b981;
    border: none;
    color: #fff;
    width: 48px;
    height: 48px;
    margin: 4px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.2s ease;
    flex-shrink: 0;
}

.search-container .search-btn:hover {
    background: #059669;
    transform: scale(1.05);
}

.search-container .search-btn i {
    font-size: 20px;
}

.search-container .search-hint {
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
    margin-top: 15px;
}

.search-container .search-hint span {
    background: rgba(255, 255, 255, 0.1);
    color: rgba(255, 255, 255, 0.7);
    padding: 5px 12px;
    border-radius: 20px;
    font-size: 11px;
    display: flex;
    align-items: center;
    gap: 5px;
}

.search-container .search-hint span i {
    font-size: 12px;
    color: #10b981;
}

/* ============================================
   PAGE HEADER
   ============================================ */
.page-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 20px;
}

.page-header .page-title {
    font-size: 24px;
    font-weight: 700;
    color: #1a1a2e;
    margin: 0;
}

.page-header .breadcrumb {
    background: transparent;
    margin: 0;
    padding: 0;
}

/* ============================================
   TABLE STYLING
   ============================================ */
.table-card {
    background: #fff;
    border-radius: 16px;
    box-shadow: 0 2px 15px rgba(0, 0, 0, 0.05);
    overflow: hidden;
}

.table-card .table {
    margin-bottom: 0;
}

.table-card .table thead th {
    background: #f8fafc;
    border-bottom: 2px solid #e2e8f0;
    color: #475569;
    font-weight: 600;
    font-size: 12px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    padding: 15px;
    white-space: nowrap;
}

.table-card .table tbody td {
    padding: 15px;
    vertical-align: middle;
    border-bottom: 1px solid #f1f5f9;
    color: #334155;
}

.table-card .table tbody tr:hover {
    background: #f8fafc;
}

.table-card .table tbody tr:last-child td {
    border-bottom: none;
}

/* Reference styling */
.ref-badge {
    font-weight: 700;
    color: #1a1a2e;
}

/* Status badges */
.badge {
    padding: 6px 12px;
    font-weight: 500;
    font-size: 12px;
    border-radius: 6px;
}

/* Action button */
.action-btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 36px;
    height: 36px;
    border-radius: 8px;
    background: #f1f5f9;
    color: #475569;
    transition: all 0.2s ease;
}

.action-btn:hover {
    background: #10b981;
    color: #fff;
}

.action-btn i {
    font-size: 18px;
}

/* Empty state */
.empty-state {
    text-align: center;
    padding: 60px 20px;
    color: #94a3b8;
}

.empty-state i {
    font-size: 60px;
    margin-bottom: 15px;
    opacity: 0.5;
}

.empty-state h5 {
    color: #64748b;
    margin-bottom: 5px;
}

/* Responsive */
@media (max-width: 768px) {
    .search-container {
        padding: 15px;
    }
    
    .search-container .search-form {
        border-radius: 12px;
    }
    
    .search-container .search-input {
        padding: 12px 10px;
        font-size: 14px;
    }
    
    .search-container .search-btn {
        width: 42px;
        height: 42px;
    }
    
    .search-container .search-hint {
        display: none;
    }
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <h4 class="page-title">Dossiers</h4>
        </div>

        <!-- Modern Search Box -->
        <div class="search-container">
            <div class="search-title">Recherche rapide</div>
            <form action="<?php echo e(route('Dossier.archiveSearch')); ?>" method="POST" class="search-form">
                <?php echo csrf_field(); ?>
                <div class="search-icon">
                    <i class="uil uil-search"></i>
                </div>
                <input type="search" 
                       name="search" 
                       class="search-input" 
                       placeholder="Rechercher par matricule, nom, référence ou n° sinistre..."
                       value="<?php echo e(request('search')); ?>"
                       autocomplete="off">
                <button type="submit" class="search-btn">
                    <i class="uil uil-arrow-right"></i>
                </button>
            </form>
            <div class="search-hint">
                <span><i class="uil uil-car"></i> Matricule</span>
                <span><i class="uil uil-user"></i> Nom assuré</span>
                <span><i class="uil uil-file-alt"></i> Référence</span>
                <span><i class="uil uil-clipboard-notes"></i> N° Sinistre</span>
            </div>
        </div>

        <!-- Results Table -->
        <div class="table-card">
            <?php if($dossiers->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table" id="myTable">
                        <thead>
                            <tr>
                                <th>Reference Dossier</th>
                                <th>Compagnie</th>
                                <th>Assuré</th>
                                <th>Matricule</th>
                                <th>Nature De Dossier</th>
                                <th>Date de Sinistre</th>
                                <th>Etape</th>
                                <th>Status</th>
                                <th style="width: 80px;">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $dossiers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dossier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <span class="ref-badge"><?php echo e($dossier->ref); ?></span>
                                    </td>
                                    <td><?php echo e($dossier->company->company ?? '-'); ?></td>
                                    <td>
                                        <strong><?php echo e($dossier->insured->name ?? '-'); ?></strong>
                                    </td>
                                    <td><?php echo e($dossier->matricule ?? '-'); ?></td>
                                    <td>
                                        <span class="badge bg-info"><?php echo e($dossier->typeexpertise->type ?? '-'); ?></span>
                                    </td>
                                    <td><?php echo e($dossier->date_sinistre ?? '-'); ?></td>
                                    <td>
                                        <span class="badge bg-dark"><?php echo e($dossier->currentStep->step ?? '-'); ?></span>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo e($dossier->status->color ?? 'secondary'); ?>">
                                            <?php echo e($dossier->status->status ?? '-'); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view', $dossier)): ?>
                                            <a href="<?php echo e(route('Dossier.show', $dossier->id)); ?>" class="action-btn" title="Voir le dossier">
                                                <i class="mdi mdi-eye"></i>
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="empty-state">
                    <i class="uil uil-search"></i>
                    <h5>Aucun dossier trouvé</h5>
                    <p>Essayez de modifier votre recherche</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dashboard.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/amea/public_html/demo4.ameaengi.com/resources/views/dossiers/cloturer.blade.php ENDPATH**/ ?>