<div>
    
    <style>
        /* ========================================
           MODAL OVERLAY - HIGHEST Z-INDEX
           ======================================== */
        
        /* Backdrop - covers everything */
        .panel-backdrop {
            position: fixed !important;
            top: 0 !important;
            left: 0 !important;
            right: 0 !important;
            bottom: 0 !important;
            width: 100vw !important;
            height: 100vh !important;
            background: rgba(0,0,0,0.6) !important;
            z-index: 99999 !important;
            animation: fadeIn 0.2s ease;
        }
        
        /* Modal Panel - above backdrop */
        .dossier-results-panel {
            position: fixed !important;
            top: 50% !important;
            left: 50% !important;
            transform: translate(-50%, -50%) !important;
            z-index: 100000 !important;
            background: white !important;
            border-radius: 12px;
            box-shadow: 0 25px 80px rgba(0,0,0,0.4) !important;
            width: 90%;
            max-width: 600px;
            max-height: 80vh;
            overflow: hidden;
            display: flex;
            flex-direction: column;
            animation: slideUp 0.3s ease;
        }
        
        .dossier-results-panel .panel-header {
            padding: 16px 20px;
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-shrink: 0;
        }
        
        .dossier-results-panel .panel-body {
            overflow-y: auto;
            flex: 1;
            padding: 0;
            background: white;
        }
        
        .dossier-results-panel .close-btn {
            background: rgba(255,255,255,0.2);
            border: none;
            color: white;
            width: 32px;
            height: 32px;
            border-radius: 50%;
            cursor: pointer;
            font-size: 18px;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: background 0.2s ease;
        }
        
        .dossier-results-panel .close-btn:hover {
            background: rgba(255,255,255,0.3);
        }
        
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        @keyframes slideUp {
            from { 
                opacity: 0;
                transform: translate(-50%, -45%);
            }
            to { 
                opacity: 1;
                transform: translate(-50%, -50%);
            }
        }
        
        /* Result items inside modal */
        .dossier-results-panel .result-item {
            padding: 14px 20px;
            border-bottom: 1px solid #f1f5f9;
            cursor: pointer;
            transition: all 0.2s ease;
            position: relative;
            background: white;
        }
        
        .dossier-results-panel .result-item:hover {
            background: linear-gradient(135deg, rgba(16,185,129,0.08) 0%, rgba(5,150,105,0.08) 100%);
            padding-left: 24px;
        }
        
        .dossier-results-panel .result-item:last-child {
            border-bottom: none;
        }
        
        .dossier-results-panel .result-header {
            font-weight: 600;
            color: #1e293b;
            font-size: 14px;
        }
        
        .dossier-results-panel .result-meta {
            font-size: 12px;
            color: #64748b;
            margin-top: 2px;
        }
        
        .dossier-results-panel .result-badge {
            display: inline-block;
            padding: 2px 8px;
            border-radius: 4px;
            font-size: 11px;
            font-weight: 500;
            background: #e0f2fe;
            color: #0369a1;
        }
        
        /* Import hint on hover */
        .dossier-results-panel .result-item::after {
            content: 'Cliquez pour importer';
            position: absolute;
            right: 16px;
            top: 50%;
            transform: translateY(-50%);
            font-size: 11px;
            color: #10b981;
            opacity: 0;
            transition: opacity 0.2s ease;
            pointer-events: none;
        }
        
        .dossier-results-panel .result-item:hover::after {
            opacity: 1;
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .dossier-results-panel {
                width: 95% !important;
                max-height: 85vh !important;
            }
            
            .dossier-results-panel .panel-header {
                padding: 12px 16px;
            }
            
            .dossier-results-panel .result-item {
                padding: 10px 12px;
            }
            
            .dossier-results-panel .result-item::after {
                display: none;
            }
        }
        
        @media (max-width: 576px) {
            .dossier-results-panel {
                width: 100% !important;
                max-width: 100% !important;
                border-radius: 16px 16px 0 0 !important;
                top: auto !important;
                bottom: 0 !important;
                left: 0 !important;
                right: 0 !important;
                transform: none !important;
                max-height: 75vh !important;
                animation: slideUpMobile 0.3s ease !important;
            }
            
            .dossier-results-panel .result-item .d-flex {
                flex-direction: column;
            }
            
            .dossier-results-panel .result-item .text-end {
                text-align: left !important;
                margin-top: 8px;
            }
        }
        
        @keyframes slideUpMobile {
            from { 
                opacity: 0;
                transform: translateY(100%);
            }
            to { 
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        /* ========================================
           FORM ELEMENTS - LOWER Z-INDEX
           ======================================== */
        
        /* Ensure form elements stay below modal */
        .card,
        .card-body,
        .form-control,
        .form-select,
        .selectpicker,
        .bootstrap-select,
        .select2-container,
        .tab-content,
        .tab-pane {
            z-index: auto !important;
        }
        
        /* Select dropdowns should be below modal */
        .bootstrap-select.show > .dropdown-menu,
        .select2-dropdown,
        .dropdown-menu.show {
            z-index: 1050 !important;
        }
        
        /* ========================================
           SEARCH RESULTS DROPDOWN (inline)
           ======================================== */
        .search-results-dropdown {
            position: absolute;
            top: 100%;
            left: 0;
            right: 0;
            z-index: 1060;
            background: white;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            max-height: 300px;
            overflow-y: auto;
            margin-top: 4px;
        }
        
        /* ========================================
           BRAND AUTOCOMPLETE
           ======================================== */
        .autocomplete-wrapper {
            position: relative;
        }
        
        .autocomplete-input {
            width: 100%;
            padding: 10px 40px 10px 14px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            font-size: 14px;
            transition: all 0.2s ease;
            background: #f8fafc;
        }
        
        .autocomplete-input:focus {
            border-color: #10b981;
            box-shadow: 0 0 0 3px rgba(16,185,129,0.1);
            background: #fff;
            outline: none;
        }
        
        .autocomplete-input.has-value {
            background: #fff;
            border-color: #10b981;
        }
        
        .autocomplete-clear {
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            background: #e2e8f0;
            border: none;
            width: 22px;
            height: 22px;
            border-radius: 50%;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 12px;
            color: #64748b;
            transition: all 0.2s ease;
        }
        
        .autocomplete-clear:hover {
            background: #cbd5e1;
            color: #334155;
        }
        
        .autocomplete-dropdown {
            position: absolute;
            top: 100%;
            left: 0;
            right: 0;
            z-index: 2000;
            background: white;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.15);
            max-height: 280px;
            overflow-y: auto;
            margin-top: 4px;
        }
        
        .autocomplete-item {
            padding: 10px 14px;
            cursor: pointer;
            transition: all 0.15s ease;
            border-bottom: 1px solid #f1f5f9;
            display: flex;
            align-items: center;
        }
        
        .autocomplete-item:last-child {
            border-bottom: none;
        }
        
        .autocomplete-item:hover {
            background: linear-gradient(135deg, rgba(16,185,129,0.1) 0%, rgba(5,150,105,0.1) 100%);
            padding-left: 18px;
        }
        
        .autocomplete-item.active {
            background: linear-gradient(135deg, rgba(16,185,129,0.15) 0%, rgba(5,150,105,0.15) 100%);
            padding-left: 18px;
        }
        
        .autocomplete-item i {
            margin-right: 10px;
            color: #10b981;
        }
        
        .autocomplete-item .brand-name {
            font-weight: 500;
            color: #1e293b;
        }
        
        .autocomplete-item .brand-match {
            background: #fef3c7;
            padding: 0 2px;
            border-radius: 2px;
        }
        
        .autocomplete-hint {
            padding: 8px 14px;
            background: #f8fafc;
            border-bottom: 1px solid #e2e8f0;
            font-size: 11px;
            color: #64748b;
        }
        
        .autocomplete-empty {
            padding: 16px;
            text-align: center;
            color: #94a3b8;
            font-size: 13px;
        }
        
        /* Selected brand badge */
        .selected-brand-badge {
            display: inline-flex;
            align-items: center;
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 13px;
            font-weight: 500;
            margin-top: 6px;
        }
        
        .selected-brand-badge i {
            margin-right: 6px;
        }
        
        .selected-brand-badge .remove-brand {
            margin-left: 8px;
            background: rgba(255,255,255,0.2);
            border: none;
            width: 18px;
            height: 18px;
            border-radius: 50%;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 10px;
        }
        
        .selected-brand-badge .remove-brand:hover {
            background: rgba(255,255,255,0.3);
        }
        
        /* ========================================
           FILE UPLOAD SECTION
           ======================================== */
        .file-upload-zone {
            border: 2px dashed #cbd5e1;
            border-radius: 12px;
            padding: 30px 20px;
            text-align: center;
            background: #f8fafc;
            transition: all 0.3s ease;
            cursor: pointer;
        }
        
        .file-upload-zone:hover {
            border-color: #10b981;
            background: rgba(16,185,129,0.05);
        }
        
        .file-upload-zone.drag-over {
            border-color: #10b981;
            background: rgba(16,185,129,0.1);
            transform: scale(1.01);
        }
        
        .file-upload-zone i {
            font-size: 48px;
            color: #94a3b8;
            margin-bottom: 12px;
        }
        
        .file-upload-zone:hover i {
            color: #10b981;
        }
        
        .file-upload-zone h5 {
            color: #475569;
            margin-bottom: 8px;
        }
        
        .file-upload-zone p {
            color: #94a3b8;
            font-size: 13px;
            margin: 0;
        }
        
        .file-upload-zone input[type="file"] {
            display: none;
        }
        
        /* Uploaded files list */
        .uploaded-files-list {
            margin-top: 16px;
        }
        
        .uploaded-file-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 12px 16px;
            background: white;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            margin-bottom: 8px;
            transition: all 0.2s ease;
        }
        
        .uploaded-file-item:hover {
            border-color: #10b981;
            box-shadow: 0 2px 8px rgba(16,185,129,0.1);
        }
        
        .uploaded-file-info {
            display: flex;
            align-items: center;
            flex: 1;
            min-width: 0;
        }
        
        .uploaded-file-info i {
            font-size: 24px;
            color: #10b981;
            margin-right: 12px;
            flex-shrink: 0;
        }
        
        .uploaded-file-info .file-name {
            font-weight: 500;
            color: #1e293b;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            max-width: 200px;
        }
        
        .uploaded-file-info .file-size {
            font-size: 12px;
            color: #94a3b8;
            margin-left: 8px;
        }
        
        .uploaded-file-type {
            margin: 0 12px;
            min-width: 150px;
        }
        
        .uploaded-file-type select {
            width: 100%;
            padding: 6px 10px;
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            font-size: 13px;
            background: white;
            cursor: pointer;
        }
        
        .uploaded-file-type select:focus {
            border-color: #10b981;
            outline: none;
        }
        
        .uploaded-file-type select.assigned {
            border-color: #10b981;
            background: #ecfdf5;
        }
        
        .uploaded-file-remove {
            background: #fee2e2;
            border: none;
            width: 32px;
            height: 32px;
            border-radius: 6px;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #ef4444;
            transition: all 0.2s ease;
            flex-shrink: 0;
        }
        
        .uploaded-file-remove:hover {
            background: #fecaca;
        }
        
        /* File type badges */
        .file-type-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 10px;
            border-radius: 12px;
            font-size: 11px;
            font-weight: 600;
        }
        
        .file-type-badge.pv {
            background: #dbeafe;
            color: #1d4ed8;
        }
        
        .file-type-badge.constat {
            background: #fef3c7;
            color: #b45309;
        }
        
        .file-type-badge.declaration {
            background: #dcfce7;
            color: #166534;
        }
        
        @media (max-width: 768px) {
            .uploaded-file-item {
                flex-wrap: wrap;
                gap: 10px;
            }
            
            .uploaded-file-info {
                width: 100%;
            }
            
            .uploaded-file-type {
                flex: 1;
                margin: 0;
            }
        }
        
        /* Matricule Input Styling */
        .matricule-input-group {
            position: relative;
        }
        
        .matricule-badge {
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            font-size: 11px;
            padding: 3px 8px;
            border-radius: 4px;
            background: #f1f5f9;
            color: #64748b;
            font-family: monospace;
            letter-spacing: 1px;
        }
        
        .matricule-badge.valid {
            background: #dcfce7;
            color: #166534;
        }
        
        .matricule-badge.invalid {
            background: #fee2e2;
            color: #991b1b;
        }
        
        .matricule-badge.searching {
            background: #fef3c7;
            color: #92400e;
        }
        
        .matricule-input {
            padding-right: 100px !important;
            font-family: monospace;
            letter-spacing: 2px;
            text-transform: uppercase;
        }
        
        /* Search indicator */
        .search-indicator {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
        }
        
        .search-indicator .spinner {
            width: 18px;
            height: 18px;
            border: 2px solid #e2e8f0;
            border-top-color: #10b981;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
        }
        
        @keyframes spin {
            to { transform: translateY(-50%) rotate(360deg); }
        }
        
        /* Quick action buttons */
        .quick-search-hint {
            font-size: 11px;
            color: #94a3b8;
            margin-top: 4px;
        }
        
        .quick-search-hint kbd {
            background: #f1f5f9;
            padding: 1px 5px;
            border-radius: 3px;
            font-size: 10px;
        }
        
        /* Enhanced form controls */
        .form-control-enhanced {
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 10px 14px;
            transition: all 0.2s ease;
        }
        
        .form-control-enhanced:focus {
            border-color: #10b981;
            box-shadow: 0 0 0 3px rgba(16,185,129,0.1);
        }
        
        /* Dossier found alert */
        .dossier-found-alert {
            background: linear-gradient(135deg, #ecfdf5 0%, #d1fae5 100%);
            border: 1px solid #10b981;
            border-radius: 8px;
            padding: 10px 14px;
            margin-top: 8px;
        }
        
        .dossier-found-alert .count-badge {
            background: #10b981;
            color: white;
            padding: 2px 8px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }
    </style>

    <div class="card mb-3">
        <div class="card-body">
            <form wire:submit.prevent="createStep()" method="post" enctype="multipart/form-data" autocomplete="off">
                <?php echo csrf_field(); ?>
                <div id="basicwizard">
                    
                    <ul class="nav nav-pills nav-justified form-wizard-header mb-4">
                        <li class="nav-item">
                            <a data-bs-toggle="tab" data-toggle="tab"
                                class="nav-link rounded-0 pt-2 pb-2 <?php echo e($count == 0 ? 'active' : ''); ?>">
                                <i class="mdi mdi-car me-1"></i>
                                <span class="d-none d-sm-inline">Assuré, Véhicule & Documents</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a data-bs-toggle="tab" data-toggle="tab"
                                class="nav-link rounded-0 pt-2 pb-2 <?php echo e($count == 1 ? 'active' : ''); ?>">
                                <i class="mdi mdi-human-handsup me-1"></i>
                                <span class="d-none d-sm-inline">Adversaire</span>
                            </a>
                        </li>
                    </ul>

                    <div class="tab-content b-0 mb-0">
                        
                        <div class="tab-pane <?php echo e($count == 0 ? 'active' : ''); ?>" id="basictab1">
                            <div class="row g-2">

                                
                                <div class="mb-3 col-md-4">
                                    <label class="form-label">
                                        Matricule WW
                                        <span class="text-muted small">(Format: WW-XXXXXX)</span>
                                    </label>
                                    <div class="matricule-input-group position-relative">
                                        <input type="text" 
                                            id="matriculeWW"
                                            name="new_matricule"
                                            class="form-control form-control-enhanced matricule-input <?php $__errorArgs = ['new_matricule'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="WW-"
                                            wire:model.lazy="new_matricule"
                                            maxlength="9">
                                        <span id="wwBadge" class="matricule-badge">WW-XXXXXX</span>
                                        
                                        <?php if($searchingMatricule): ?>
                                            <div class="search-indicator">
                                                <div class="spinner"></div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <?php $__errorArgs = ['new_matricule'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    
                                    <?php if($dossiers1 && count($dossiers1) > 0): ?>
                                        <div class="dossier-found-alert">
                                            <span class="count-badge"><?php echo e(count($dossiers1)); ?></span>
                                            <span class="ms-2 small">dossier(s) avec ce matricule</span>
                                            <a href="#" wire:click.prevent="toggleTable" class="float-end small text-success fw-bold">
                                                <i class="mdi mdi-eye me-1"></i><?php echo e($hidden ? 'Afficher' : 'Masquer'); ?>

                                            </a>
                                        </div>
                                        
                                        
                                        <?php if(!$hidden): ?>
                                            <div class="panel-backdrop" wire:click="toggleTable"></div>
                                            <div class="dossier-results-panel">
                                                <div class="panel-header">
                                                    <div>
                                                        <i class="mdi mdi-folder-search me-2"></i>
                                                        <strong><?php echo e(count($dossiers1)); ?></strong> dossier(s) trouvé(s)
                                                        <small class="d-block opacity-75">Matricule WW: <?php echo e($new_matricule); ?></small>
                                                    </div>
                                                    <button type="button" class="close-btn" wire:click="toggleTable">
                                                        <i class="mdi mdi-close"></i>
                                                    </button>
                                                </div>
                                                <div class="panel-body">
                                                    <?php $__currentLoopData = $dossiers1; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="result-item" wire:click="importDossier1(<?php echo e($d->id); ?>)">
                                                            <div class="d-flex justify-content-between align-items-start">
                                                                <div>
                                                                    <div class="result-header">
                                                                        <i class="mdi mdi-folder me-1 text-primary"></i>
                                                                        <?php echo e($d->new_matricule ?? $d->matricule); ?>

                                                                    </div>
                                                                    <div class="result-meta mt-1">
                                                                        <?php if($d->insured): ?>
                                                                            <i class="mdi mdi-account me-1"></i><?php echo e($d->insured->name); ?>

                                                                        <?php endif; ?>
                                                                        <?php if($d->vehiculemodel): ?>
                                                                            <span class="mx-1">•</span>
                                                                            <i class="mdi mdi-car me-1"></i><?php echo e($d->vehiculemodel->brand->brand ?? ''); ?> <?php echo e($d->vehiculemodel->name); ?>

                                                                        <?php endif; ?>
                                                                    </div>
                                                                    <?php if($d->company): ?>
                                                                        <div class="result-meta">
                                                                            <i class="mdi mdi-domain me-1"></i><?php echo e($d->company->company); ?>

                                                                        </div>
                                                                    <?php endif; ?>
                                                                </div>
                                                                <div class="text-end">
                                                                    <span class="result-badge">Réf: <?php echo e($d->ref); ?></span>
                                                                    <div class="mt-1">
                                                                        <small class="text-muted"><?php echo e($d->created_at ? $d->created_at->format('d/m/Y') : ''); ?></small>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    
                                    <div class="quick-search-hint">
                                        <i class="mdi mdi-information-outline me-1"></i>
                                        Tapez le matricule, la recherche se fait automatiquement
                                    </div>
                                </div>

                                
                                <div class="mb-3 col-md-4">
                                    <label class="form-label">
                                        Matricule Ancien
                                        <span class="text-muted small">(Format: XXXXX-X-XX)</span>
                                    </label>
                                    <div class="matricule-input-group position-relative">
                                        <input type="text" 
                                            id="matriculeOld"
                                            name="matricule"
                                            class="form-control form-control-enhanced matricule-input <?php $__errorArgs = ['matricule'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="00000-A-00"
                                            wire:model.lazy="matricule"
                                            maxlength="10">
                                        <span id="oldBadge" class="matricule-badge">XXXXX-X-XX</span>
                                    </div>
                                    
                                    <?php $__errorArgs = ['matricule'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    
                                    <?php if($dossiers && count($dossiers) > 0): ?>
                                        <div class="dossier-found-alert">
                                            <span class="count-badge"><?php echo e(count($dossiers)); ?></span>
                                            <span class="ms-2 small">dossier(s) avec ce matricule</span>
                                            <a href="#" wire:click.prevent="toggleTable" class="float-end small text-success fw-bold">
                                                <i class="mdi mdi-eye me-1"></i><?php echo e($hidden ? 'Afficher' : 'Masquer'); ?>

                                            </a>
                                        </div>
                                        
                                        
                                        <?php if(!$hidden): ?>
                                            <div class="panel-backdrop" wire:click="toggleTable"></div>
                                            <div class="dossier-results-panel">
                                                <div class="panel-header">
                                                    <div>
                                                        <i class="mdi mdi-folder-search me-2"></i>
                                                        <strong><?php echo e(count($dossiers)); ?></strong> dossier(s) trouvé(s)
                                                        <small class="d-block opacity-75">Matricule: <?php echo e($matricule); ?></small>
                                                    </div>
                                                    <button type="button" class="close-btn" wire:click="toggleTable">
                                                        <i class="mdi mdi-close"></i>
                                                    </button>
                                                </div>
                                                <div class="panel-body">
                                                    <?php $__currentLoopData = $dossiers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="result-item" wire:click="importDossier(<?php echo e($d->id); ?>)">
                                                            <div class="d-flex justify-content-between align-items-start">
                                                                <div>
                                                                    <div class="result-header">
                                                                        <i class="mdi mdi-folder me-1 text-primary"></i>
                                                                        <?php echo e($d->matricule ?? $d->new_matricule); ?>

                                                                    </div>
                                                                    <div class="result-meta mt-1">
                                                                        <?php if($d->insured): ?>
                                                                            <i class="mdi mdi-account me-1"></i><?php echo e($d->insured->name); ?>

                                                                        <?php endif; ?>
                                                                        <?php if($d->vehiculemodel): ?>
                                                                            <span class="mx-1">•</span>
                                                                            <i class="mdi mdi-car me-1"></i><?php echo e($d->vehiculemodel->brand->brand ?? ''); ?> <?php echo e($d->vehiculemodel->name); ?>

                                                                        <?php endif; ?>
                                                                    </div>
                                                                    <?php if($d->company): ?>
                                                                        <div class="result-meta">
                                                                            <i class="mdi mdi-domain me-1"></i><?php echo e($d->company->company); ?>

                                                                        </div>
                                                                    <?php endif; ?>
                                                                </div>
                                                                <div class="text-end">
                                                                    <span class="result-badge">Réf: <?php echo e($d->ref); ?></span>
                                                                    <div class="mt-1">
                                                                        <small class="text-muted"><?php echo e($d->created_at ? $d->created_at->format('d/m/Y') : ''); ?></small>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>

                                
                                <div class="mb-3 col-md-4 position-relative">
                                    <label class="form-label" for="date_sinistre">
                                        Date de Sinistre <span class="text-danger">*</span>
                                    </label>
                                    <input type="date"
                                        class="form-control form-control-enhanced <?php $__errorArgs = ['date_sinistre'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="date_sinistre" id="date_sinistre" wire:model="date_sinistre">
                                    <?php $__errorArgs = ['date_sinistre'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <hr class="my-3">

                                
                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Civilité</label>
                                    <select name="civility" wire:model="civility"
                                        class="form-control form-control-enhanced <?php $__errorArgs = ['civility'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                        <option value="" selected>Sélectionner</option>
                                        <option value="Mr">Monsieur</option>
                                        <option value="Mme">Madame</option>
                                        <option value="Sociéte">Société</option>
                                    </select>
                                    <?php $__errorArgs = ['civility'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <div class="mb-3 col-md-4">
                                    <label class="form-label">
                                        Nom Assuré <span class="text-danger">*</span>
                                    </label>
                                    <div class="position-relative">
                                        <input type="text" 
                                            id="insuredName"
                                            name="name"
                                            class="form-control form-control-enhanced <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="Entrer le nom de l'assuré" 
                                            wire:model.lazy="name">
                                        
                                        <?php if($searchingName): ?>
                                            <div class="search-indicator">
                                                <div class="spinner"></div>
                                            </div>
                                        <?php endif; ?>
                                        
                                        
                                        <?php if($dossiersByName && count($dossiersByName) > 0): ?>
                                            
                                            <div class="dossier-found-alert mt-2">
                                                <span class="count-badge"><?php echo e(count($dossiersByName)); ?></span>
                                                <span class="ms-2 small">client(s) trouvé(s)</span>
                                                <a href="#" wire:click.prevent="toggleNameResults" class="float-end small text-success fw-bold">
                                                    <i class="mdi mdi-eye me-1"></i>Afficher
                                                </a>
                                            </div>
                                            
                                            
                                            <?php if($showNameResults): ?>
                                                <div class="panel-backdrop" wire:click="toggleNameResults"></div>
                                                <div class="dossier-results-panel">
                                                    <div class="panel-header">
                                                        <div>
                                                            <i class="mdi mdi-account-search me-2"></i>
                                                            <strong><?php echo e(count($dossiersByName)); ?></strong> client(s) trouvé(s)
                                                            <small class="d-block opacity-75">Recherche: <?php echo e($name); ?></small>
                                                        </div>
                                                        <button type="button" class="close-btn" wire:click="toggleNameResults">
                                                            <i class="mdi mdi-close"></i>
                                                        </button>
                                                    </div>
                                                    <div class="panel-body">
                                                        <?php $__currentLoopData = $dossiersByName; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div class="result-item" wire:click="importDossierByName(<?php echo e($d->id); ?>)">
                                                                <div class="d-flex justify-content-between align-items-start">
                                                                    <div>
                                                                        <div class="result-header">
                                                                            <i class="mdi mdi-account me-1 text-success"></i>
                                                                            <?php echo e($d->insured->name ?? 'N/A'); ?>

                                                                        </div>
                                                                        <div class="result-meta mt-1">
                                                                            <i class="mdi mdi-car me-1"></i><?php echo e($d->matricule ?? $d->new_matricule); ?>

                                                                            <?php if($d->vehiculemodel): ?>
                                                                                <span class="mx-1">•</span>
                                                                                <?php echo e($d->vehiculemodel->brand->brand ?? ''); ?> <?php echo e($d->vehiculemodel->name); ?>

                                                                            <?php endif; ?>
                                                                        </div>
                                                                        <?php if($d->company): ?>
                                                                            <div class="result-meta">
                                                                                <i class="mdi mdi-domain me-1"></i><?php echo e($d->company->company); ?>

                                                                            </div>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                    <div class="text-end">
                                                                        <span class="result-badge">Réf: <?php echo e($d->ref); ?></span>
                                                                        <div class="mt-1">
                                                                            <small class="text-muted"><?php echo e($d->created_at ? $d->created_at->format('d/m/Y') : ''); ?></small>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <div class="quick-search-hint">
                                        <i class="mdi mdi-magnify me-1"></i>
                                        Recherche automatique des clients existants
                                    </div>
                                </div>

                                
                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Téléphone Assuré</label>
                                    <input type="tel" name="telephone"
                                        class="form-control form-control-enhanced <?php $__errorArgs = ['telephone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="0611223355"
                                        wire:model="telephone"
                                        maxlength="10">
                                    <?php $__errorArgs = ['telephone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Numéro de Police</label>
                                    <input type="text" name="numero_police"
                                        class="form-control form-control-enhanced <?php $__errorArgs = ['numero_police'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="Entrer le numéro de police" 
                                        wire:model="numero_police">
                                    <?php $__errorArgs = ['numero_police'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <div class="mb-3 col-md-4">
                                    <label for="type_vehicule_id" class="form-label">Type de Véhicule</label>
                                    <select name="type_vehicule_id" id="type_vehicule_id"
                                        class="form-control selectpicker <?php $__errorArgs = ['type_vehicule_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        data-live-search="true"
                                        wire:model="type_vehicule_id">
                                        <option value="" selected>Sélectionner un Type</option>
                                        <?php $__currentLoopData = $typevehicules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($type->id); ?>"><?php echo e($type->type); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['type_vehicule_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <div class="mb-3 col-md-4">
                                    <label for="brand_id" class="form-label">Marque de Véhicule</label>
                                    
                                    
                                    <div class="autocomplete-wrapper" wire:ignore.self>
                                        <input type="text" 
                                            id="brandAutocomplete"
                                            class="autocomplete-input <?php echo e($selectedBrand ? 'has-value' : ''); ?>"
                                            placeholder="Tapez pour rechercher une marque..."
                                            wire:model.debounce.150ms="brandSearch"
                                            wire:focus="$set('showBrandDropdown', true)"
                                            autocomplete="off">
                                        
                                        <?php if($selectedBrand): ?>
                                            <button type="button" class="autocomplete-clear" wire:click="clearBrand" title="Effacer">
                                                <i class="mdi mdi-close"></i>
                                            </button>
                                        <?php endif; ?>
                                        
                                        
                                        <?php if($showBrandDropdown && strlen($brandSearch) > 0): ?>
                                            <div class="autocomplete-dropdown">
                                                <?php if(count($brandResults) > 0): ?>
                                                    <div class="autocomplete-hint">
                                                        <i class="mdi mdi-information-outline me-1"></i>
                                                        <?php echo e(count($brandResults)); ?> marque(s) trouvée(s) - Cliquez pour sélectionner
                                                    </div>
                                                    <?php $__currentLoopData = $brandResults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="autocomplete-item" wire:click="selectBrand(<?php echo e($brand->id); ?>, '<?php echo e(addslashes($brand->brand)); ?>')">
                                                            <i class="mdi mdi-car"></i>
                                                            <span class="brand-name"><?php echo e($brand->brand); ?></span>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <div class="autocomplete-empty">
                                                        <i class="mdi mdi-magnify-close me-1"></i>
                                                        Aucune marque trouvée pour "<?php echo e($brandSearch); ?>"
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    
                                    
                                    <?php if($selectedBrand && $selectedBrandName): ?>
                                        <div class="selected-brand-badge">
                                            <i class="mdi mdi-check-circle"></i>
                                            <?php echo e($selectedBrandName); ?>

                                            <button type="button" class="remove-brand" wire:click="clearBrand" title="Supprimer">
                                                <i class="mdi mdi-close"></i>
                                            </button>
                                        </div>
                                    <?php endif; ?>
                                    
                                    
                                    <input type="hidden" name="brand_id" wire:model="selectedBrand">
                                    
                                    <?php $__errorArgs = ['selectedBrand'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <div id="apiYearContainer" class="mb-3 col-md-4 d-none">
                                    <label class="form-label">Année du véhicule</label>
                                    <select id="apiYear" class="form-control selectpicker" data-live-search="true">
                                        <option value="">Sélectionner l'année</option>
                                    </select>
                                </div>

                                
                                <div class="mb-3 col-md-4">
                                    <label for="vehicule_model_id" class="form-label">Modèle de Véhicule</label>
                                    
                                    
                                    <div id="localModelContainer">
                                        <select name="vehicule_model_id" id="vehicule_model_id"
                                            class="form-control selectpicker <?php $__errorArgs = ['vehicule_model_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            data-live-search="true"
                                            wire:model="vehicule_model_id">
                                            <option value="" selected>Sélectionner un modèle</option>
                                            <?php if($models): ?>
                                                <?php $__currentLoopData = $models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($model->id); ?>"><?php echo e($model->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                    
                                    
                                    <div id="apiModelContainer" class="d-none">
                                        <select id="apiModel" class="form-control selectpicker" data-live-search="true">
                                            <option value="">Sélectionner d'abord une marque</option>
                                        </select>
                                    </div>

                                    <?php $__errorArgs = ['vehicule_model_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                
                                
                                <input type="hidden" id="apiBrandName" name="api_brand_name" wire:model="api_brand_name">
                                <input type="hidden" id="apiModelName" name="api_model_name" wire:model="api_model_name">
                                <input type="hidden" id="apiYearValue" name="api_year" wire:model="api_year">

                                
                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Garantie</label>
                                    <select id="guarantee_id" name="guarantee_id"
                                        class="form-control selectpicker <?php $__errorArgs = ['guarantee_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        data-live-search="true"
                                        wire:model="guarantee_id">
                                        <option value="" selected>Sélectionner la garantie</option>
                                        <?php $__currentLoopData = $warranties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warranty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($warranty->id); ?>"><?php echo e($warranty->guarantee); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['guarantee_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <div class="mb-3 col-md-4">
                                    <label class="form-label" for="numero_sinistre">
                                        Numéro de sinistre <span class="text-danger">*</span>
                                    </label>
                                    <input type="text"
                                        class="form-control form-control-enhanced <?php $__errorArgs = ['numero_sinistre'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="numero_sinistre" id="numero_sinistre" wire:model="numero_sinistre">
                                    <?php $__errorArgs = ['numero_sinistre'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <div class="mb-3 col-md-4">
                                    <label for="intermidiaire_id" class="form-label">Nom Intermédiaire</label>
                                    
                                    <div class="autocomplete-wrapper" wire:ignore.self>
                                        <input type="text" 
                                            id="intermediaireAutocomplete"
                                            class="autocomplete-input <?php echo e($intermidiaire_id ? 'has-value' : ''); ?>"
                                            placeholder="Tapez pour rechercher..."
                                            wire:model.debounce.150ms="intermediaireSearch"
                                            wire:focus="$set('showIntermediaireDropdown', true)"
                                            autocomplete="off">
                                        
                                        <?php if($intermidiaire_id): ?>
                                            <button type="button" class="autocomplete-clear" wire:click="clearIntermediaire" title="Effacer">
                                                <i class="mdi mdi-close"></i>
                                            </button>
                                        <?php endif; ?>
                                        
                                        
                                        <?php if($showIntermediaireDropdown && strlen($intermediaireSearch) > 0): ?>
                                            <div class="autocomplete-dropdown">
                                                <?php if(count($intermediaireResults) > 0): ?>
                                                    <div class="autocomplete-hint">
                                                        <i class="mdi mdi-information-outline me-1"></i>
                                                        <?php echo e(count($intermediaireResults)); ?> intermédiaire(s) trouvé(s)
                                                    </div>
                                                    <?php $__currentLoopData = $intermediaireResults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $interm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="autocomplete-item" wire:click="selectIntermediaire(<?php echo e($interm->id); ?>, '<?php echo e(addslashes($interm->company)); ?>')">
                                                            <i class="mdi mdi-account-tie"></i>
                                                            <span class="brand-name"><?php echo e($interm->company); ?></span>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <div class="autocomplete-empty">
                                                        <i class="mdi mdi-magnify-close me-1"></i>
                                                        Aucun intermédiaire trouvé pour "<?php echo e($intermediaireSearch); ?>"
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <?php if($intermidiaire_id && $selectedIntermediaireName): ?>
                                        <div class="selected-brand-badge" style="background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%);">
                                            <i class="mdi mdi-account-tie"></i>
                                            <?php echo e($selectedIntermediaireName); ?>

                                            <button type="button" class="remove-brand" wire:click="clearIntermediaire" title="Supprimer">
                                                <i class="mdi mdi-close"></i>
                                            </button>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <input type="hidden" name="intermidiaire_id" wire:model="intermidiaire_id">
                                    
                                    <?php $__errorArgs = ['intermidiaire_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <div class="mb-3 col-md-4">
                                    <label for="company_id" class="form-label">
                                        Compagnie <span class="text-danger">*</span>
                                    </label>
                                    <select name="company_id" id="company_id"
                                        class="form-control selectpicker <?php $__errorArgs = ['company_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        data-live-search="true"
                                        wire:model="company_id">
                                        <option value="" selected>Sélectionner la Compagnie</option>
                                        <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($company->id); ?>"><?php echo e($company->company); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['company_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <div class="mb-3 col-md-4 position-relative">
                                    <label class="form-label" for="date_reception">
                                        Date de Réception <span class="text-danger">*</span>
                                    </label>
                                    <input type="date"
                                        class="form-control form-control-enhanced <?php $__errorArgs = ['date_reception'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="date_reception" id="date_reception" wire:model="date_reception">
                                    <?php $__errorArgs = ['date_reception'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <div class="col-12">
                                    <hr class="my-3">
                                    <h6 class="text-muted mb-3">
                                        <i class="mdi mdi-car-info me-1"></i>Détails du Véhicule
                                    </h6>
                                </div>

                                
                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Mode <span class="text-danger">*</span></label>
                                    <select id="mode_id" name="mode_id"
                                        class="form-control selectpicker <?php $__errorArgs = ['mode_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        data-live-search="true"
                                        wire:model="mode_id">
                                        <option value="" selected>Sélectionner Mode</option>
                                        <?php $__currentLoopData = $dossierTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($type->id); ?>"><?php echo e($type->mode); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['mode_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Type Expertise <span class="text-danger">*</span></label>
                                    <select id="type_expertise_id" name="type_expertise_id"
                                        class="form-control selectpicker <?php $__errorArgs = ['type_expertise_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        data-live-search="true"
                                        wire:model="type_expertise_id">
                                        <option value="" selected>Sélectionner le Type Expertise</option>
                                        <?php $__currentLoopData = $typeexpertises; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($type->id); ?>"><?php echo e($type->type); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['type_expertise_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Garage</label>
                                    
                                    <div class="autocomplete-wrapper" wire:ignore.self>
                                        <input type="text" 
                                            id="garageAutocomplete"
                                            class="autocomplete-input <?php echo e($garage_id ? 'has-value' : ''); ?>"
                                            placeholder="Tapez pour rechercher un garage..."
                                            wire:model.debounce.150ms="garageSearch"
                                            wire:focus="$set('showGarageDropdown', true)"
                                            autocomplete="off">
                                        
                                        <?php if($garage_id): ?>
                                            <button type="button" class="autocomplete-clear" wire:click="clearGarage" title="Effacer">
                                                <i class="mdi mdi-close"></i>
                                            </button>
                                        <?php endif; ?>
                                        
                                        
                                        <?php if($showGarageDropdown && strlen($garageSearch) > 0): ?>
                                            <div class="autocomplete-dropdown">
                                                <?php if(count($garageResults) > 0): ?>
                                                    <div class="autocomplete-hint">
                                                        <i class="mdi mdi-information-outline me-1"></i>
                                                        <?php echo e(count($garageResults)); ?> garage(s) trouvé(s)
                                                    </div>
                                                    <?php $__currentLoopData = $garageResults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $garage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="autocomplete-item" wire:click="selectGarage(<?php echo e($garage->id); ?>, '<?php echo e(addslashes($garage->libelle)); ?>')">
                                                            <i class="mdi mdi-garage"></i>
                                                            <span class="brand-name"><?php echo e($garage->libelle); ?></span>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <div class="autocomplete-empty">
                                                        <i class="mdi mdi-magnify-close me-1"></i>
                                                        Aucun garage trouvé pour "<?php echo e($garageSearch); ?>"
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <?php if($garage_id && $selectedGarageName): ?>
                                        <div class="selected-brand-badge" style="background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);">
                                            <i class="mdi mdi-garage"></i>
                                            <?php echo e($selectedGarageName); ?>

                                            <button type="button" class="remove-brand" wire:click="clearGarage" title="Supprimer">
                                                <i class="mdi mdi-close"></i>
                                            </button>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <input type="hidden" name="garage_id" wire:model="garage_id">
                                    
                                    <?php $__errorArgs = ['garage_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <div class="mb-3 col-md-4">
                                    <label class="form-label">
                                        Numéro de Châssis (VIN)
                                        <span class="text-muted small">(17 caractères)</span>
                                    </label>
                                    <div class="position-relative">
                                        <input type="text" 
                                            id="chassisNumber"
                                            name="chassis_number"
                                            class="form-control form-control-enhanced <?php $__errorArgs = ['chassis_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="Ex: WVWZZZ3CZWE123456"
                                            wire:model.lazy="chassis_number"
                                            maxlength="17"
                                            style="text-transform: uppercase; font-family: monospace; letter-spacing: 1px;">
                                        
                                        <?php if($searchingChassis): ?>
                                            <div class="search-indicator">
                                                <div class="spinner"></div>
                                            </div>
                                        <?php endif; ?>
                                        
                                        
                                        <?php if($dossiersByChassis && count($dossiersByChassis) > 0): ?>
                                            
                                            <div class="dossier-found-alert mt-2">
                                                <span class="count-badge"><?php echo e(count($dossiersByChassis)); ?></span>
                                                <span class="ms-2 small">véhicule(s) trouvé(s)</span>
                                                <a href="#" wire:click.prevent="toggleChassisResults" class="float-end small text-success fw-bold">
                                                    <i class="mdi mdi-eye me-1"></i>Afficher
                                                </a>
                                            </div>
                                            
                                            
                                            <?php if($showChassisResults): ?>
                                                <div class="panel-backdrop" wire:click="toggleChassisResults"></div>
                                                <div class="dossier-results-panel">
                                                    <div class="panel-header">
                                                        <div>
                                                            <i class="mdi mdi-car-key me-2"></i>
                                                            <strong><?php echo e(count($dossiersByChassis)); ?></strong> véhicule(s) trouvé(s)
                                                            <small class="d-block opacity-75">VIN: <?php echo e($chassis_number); ?></small>
                                                        </div>
                                                        <button type="button" class="close-btn" wire:click="toggleChassisResults">
                                                            <i class="mdi mdi-close"></i>
                                                        </button>
                                                    </div>
                                                    <div class="panel-body">
                                                        <?php $__currentLoopData = $dossiersByChassis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div class="result-item" wire:click="importDossierByChassis(<?php echo e($d->id); ?>)">
                                                                <div class="d-flex justify-content-between align-items-start">
                                                                    <div>
                                                                        <div class="result-header">
                                                                            <i class="mdi mdi-car-key me-1 text-warning"></i>
                                                                            <?php echo e($d->numero_chassis); ?>

                                                                        </div>
                                                                        <div class="result-meta mt-1">
                                                                            <i class="mdi mdi-car me-1"></i><?php echo e($d->matricule ?? $d->new_matricule); ?>

                                                                            <?php if($d->insured): ?>
                                                                                <span class="mx-1">•</span>
                                                                                <i class="mdi mdi-account me-1"></i><?php echo e($d->insured->name); ?>

                                                                            <?php endif; ?>
                                                                        </div>
                                                                        <?php if($d->vehiculemodel): ?>
                                                                            <div class="result-meta">
                                                                                <i class="mdi mdi-car-side me-1"></i>
                                                                                <?php echo e($d->vehiculemodel->brand->brand ?? ''); ?> <?php echo e($d->vehiculemodel->name); ?>

                                                                            </div>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                    <div class="text-end">
                                                                        <span class="result-badge">Réf: <?php echo e($d->ref); ?></span>
                                                                        <div class="mt-1">
                                                                            <small class="text-muted"><?php echo e($d->created_at ? $d->created_at->format('d/m/Y') : ''); ?></small>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                    <?php $__errorArgs = ['chassis_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <div class="quick-search-hint">
                                        <i class="mdi mdi-magnify me-1"></i>
                                        Recherche automatique des véhicules par VIN
                                    </div>
                                </div>

                                
                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Numéro d'attestation</label>
                                    <input type="text" name="numero_attestation"
                                        class="form-control form-control-enhanced <?php $__errorArgs = ['numero_attestation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="Entrer le numéro d'attestation" 
                                        wire:model="numero_attestation">
                                    <?php $__errorArgs = ['numero_attestation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <div class="mb-3 col-md-4 position-relative">
                                    <label class="form-label" for="circulation_date">Date de mise en circulation</label>
                                    <input type="date"
                                        class="form-control form-control-enhanced <?php $__errorArgs = ['circulation_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="circulation_date" id="circulation_date" wire:model="circulation_date">
                                    <?php $__errorArgs = ['circulation_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <div class="mb-3 col-md-4">
                                    <label class="form-label" for="kilometrage">Kilométrage</label>
                                    <input type="number" min="0"
                                        class="form-control form-control-enhanced <?php $__errorArgs = ['kilometrage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="Ex: 125000" name="kilometrage" id="kilometrage"
                                        wire:model="kilometrage">
                                    <?php $__errorArgs = ['kilometrage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <div class="mb-3 col-md-4">
                                    <label class="form-label" for="puissance_fiscale">Puissance Fiscale</label>
                                    <input type="number" min="1"
                                        class="form-control form-control-enhanced <?php $__errorArgs = ['puissance_fiscale'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="Ex: 7" name="puissance_fiscale"
                                        id="puissance_fiscale" wire:model="puissance_fiscale">
                                    <?php $__errorArgs = ['puissance_fiscale'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <div class="mb-3 col-md-4">
                                    <label class="form-label" for="carburant">Carburant</label>
                                    <select id="carburant" name="carburant"
                                        class="form-control selectpicker <?php $__errorArgs = ['carburant'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        data-live-search="true"
                                        wire:model="carburant">
                                        <option value="" selected>Sélectionner Carburant</option>
                                        <?php $__currentLoopData = $carburants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $carb): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($carb->id); ?>"><?php echo e($carb->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['carburant'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <div class="mb-3 col-md-4">
                                    <label class="form-label" for="city_id">Ville</label>
                                    
                                    <div class="autocomplete-wrapper" wire:ignore.self>
                                        <input type="text" 
                                            id="cityAutocomplete"
                                            class="autocomplete-input <?php echo e($city_id ? 'has-value' : ''); ?>"
                                            placeholder="Tapez pour rechercher une ville..."
                                            wire:model.debounce.150ms="citySearch"
                                            wire:focus="$set('showCityDropdown', true)"
                                            autocomplete="off">
                                        
                                        <?php if($city_id): ?>
                                            <button type="button" class="autocomplete-clear" wire:click="clearCity" title="Effacer">
                                                <i class="mdi mdi-close"></i>
                                            </button>
                                        <?php endif; ?>
                                        
                                        
                                        <?php if($showCityDropdown && strlen($citySearch) > 0): ?>
                                            <div class="autocomplete-dropdown">
                                                <?php if(count($cityResults) > 0): ?>
                                                    <div class="autocomplete-hint">
                                                        <i class="mdi mdi-information-outline me-1"></i>
                                                        <?php echo e(count($cityResults)); ?> ville(s) trouvée(s)
                                                    </div>
                                                    <?php $__currentLoopData = $cityResults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="autocomplete-item" wire:click="selectCity(<?php echo e($city->id); ?>, '<?php echo e(addslashes($city->city)); ?>')">
                                                            <i class="mdi mdi-map-marker"></i>
                                                            <span class="brand-name"><?php echo e($city->city); ?></span>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <div class="autocomplete-empty">
                                                        <i class="mdi mdi-magnify-close me-1"></i>
                                                        Aucune ville trouvée pour "<?php echo e($citySearch); ?>"
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <?php if($city_id && $selectedCityName): ?>
                                        <div class="selected-brand-badge" style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);">
                                            <i class="mdi mdi-map-marker"></i>
                                            <?php echo e($selectedCityName); ?>

                                            <button type="button" class="remove-brand" wire:click="clearCity" title="Supprimer">
                                                <i class="mdi mdi-close"></i>
                                            </button>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <input type="hidden" name="city_id" wire:model="city_id">
                                    
                                    <?php $__errorArgs = ['city_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <div class="col-12">
                                    <hr class="my-3">
                                    <h6 class="text-muted mb-3">
                                        <i class="mdi mdi-file-document-multiple me-1"></i>Documents
                                    </h6>
                                </div>

                                <div class="col-12">
                                    
                                    <div class="file-upload-zone" 
                                         onclick="document.getElementById('fileUploadInput').click()"
                                         id="dropZone">
                                        <i class="mdi mdi-cloud-upload"></i>
                                        <h5>Glissez vos fichiers ici</h5>
                                        <p>ou cliquez pour sélectionner (PV, Constat, Déclaration)</p>
                                        <input type="file" 
                                               id="fileUploadInput" 
                                               wire:model="uploadedFiles" 
                                               multiple 
                                               accept=".pdf,.jpg,.jpeg,.png,.doc,.docx">
                                    </div>
                                    
                                    
                                    <div wire:loading wire:target="uploadedFiles" class="text-center mt-3">
                                        <div class="spinner-border text-success" role="status">
                                            <span class="visually-hidden">Chargement...</span>
                                        </div>
                                        <p class="text-muted mt-2">Téléchargement en cours...</p>
                                    </div>
                                    
                                    
                                    <?php if($uploadedFiles && count($uploadedFiles) > 0): ?>
                                        <div class="uploaded-files-list">
                                            <div class="d-flex justify-content-between align-items-center mb-3">
                                                <span class="text-muted">
                                                    <i class="mdi mdi-paperclip me-1"></i>
                                                    <?php echo e(count($uploadedFiles)); ?> fichier(s) sélectionné(s)
                                                </span>
                                                <small class="text-warning">
                                                    <i class="mdi mdi-alert-circle me-1"></i>
                                                    Assignez un type à chaque fichier
                                                </small>
                                            </div>
                                            
                                            <?php $__currentLoopData = $uploadedFiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="uploaded-file-item">
                                                    <div class="uploaded-file-info">
                                                        <i class="mdi mdi-file-document"></i>
                                                        <div>
                                                            <span class="file-name"><?php echo e($file->getClientOriginalName()); ?></span>
                                                            <span class="file-size"><?php echo e(number_format($file->getSize() / 1024, 1)); ?> KB</span>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="uploaded-file-type">
                                                        <select wire:change="setFileType(<?php echo e($index); ?>, $event.target.value)"
                                                                class="<?php echo e(isset($fileTypes[$index]) && $fileTypes[$index] ? 'assigned' : ''); ?>">
                                                            <option value="">-- Type --</option>
                                                            <option value="1" <?php echo e((isset($fileTypes[$index]) && $fileTypes[$index] == '1') ? 'selected' : ''); ?>>
                                                                📋 PV
                                                            </option>
                                                            <option value="2" <?php echo e((isset($fileTypes[$index]) && $fileTypes[$index] == '2') ? 'selected' : ''); ?>>
                                                                📝 Constat
                                                            </option>
                                                            <option value="3" <?php echo e((isset($fileTypes[$index]) && $fileTypes[$index] == '3') ? 'selected' : ''); ?>>
                                                                📄 Déclaration
                                                            </option>
                                                        </select>
                                                    </div>
                                                    
                                                    <button type="button" 
                                                            class="uploaded-file-remove" 
                                                            wire:click="removeUploadedFile(<?php echo e($index); ?>)"
                                                            title="Supprimer">
                                                        <i class="mdi mdi-delete"></i>
                                                    </button>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            
                                            
                                            <div class="mt-3 d-flex gap-2 flex-wrap">
                                                <?php
                                                    $pvCount = collect($fileTypes)->filter(fn($v) => $v == '1')->count();
                                                    $constatCount = collect($fileTypes)->filter(fn($v) => $v == '2')->count();
                                                    $declarationCount = collect($fileTypes)->filter(fn($v) => $v == '3')->count();
                                                    $unassigned = count($uploadedFiles) - $pvCount - $constatCount - $declarationCount;
                                                ?>
                                                
                                                <?php if($pvCount > 0): ?>
                                                    <span class="file-type-badge pv">
                                                        <i class="mdi mdi-file me-1"></i>PV: <?php echo e($pvCount); ?>

                                                    </span>
                                                <?php endif; ?>
                                                <?php if($constatCount > 0): ?>
                                                    <span class="file-type-badge constat">
                                                        <i class="mdi mdi-file-document me-1"></i>Constat: <?php echo e($constatCount); ?>

                                                    </span>
                                                <?php endif; ?>
                                                <?php if($declarationCount > 0): ?>
                                                    <span class="file-type-badge declaration">
                                                        <i class="mdi mdi-file-check me-1"></i>Déclaration: <?php echo e($declarationCount); ?>

                                                    </span>
                                                <?php endif; ?>
                                                <?php if($unassigned > 0): ?>
                                                    <span class="file-type-badge" style="background: #fee2e2; color: #991b1b;">
                                                        <i class="mdi mdi-alert me-1"></i>Non assigné: <?php echo e($unassigned); ?>

                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>

                            </div>
                        </div>

                        
                        <div class="tab-pane <?php echo e($count == 1 ? 'active' : ''); ?>" id="basictab2">
                            <div class="row g-2">
                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Civilité</label>
                                    <select name="civilityop" wire:model="civilityop"
                                        class="form-control form-control-enhanced <?php $__errorArgs = ['civilityop'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                        <option value="" selected>Sélectionner</option>
                                        <option value="Mr">Monsieur</option>
                                        <option value="Mme">Madame</option>
                                        <option value="Sociéte">Société</option>
                                    </select>
                                    <?php $__errorArgs = ['civilityop'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Nom Adversaire</label>
                                    <input type="text" name="nameop"
                                        class="form-control form-control-enhanced <?php $__errorArgs = ['nameop'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="Entrer le nom de l'adversaire" wire:model="nameop">
                                    <?php $__errorArgs = ['nameop'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Téléphone Adversaire</label>
                                    <input type="tel" name="telephoneop"
                                        class="form-control form-control-enhanced <?php $__errorArgs = ['telephoneop'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="0611223355" wire:model="telephoneop"
                                        maxlength="10">
                                    <?php $__errorArgs = ['telephoneop'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Matricule Adversaire</label>
                                    <input type="text" name="matriculeop"
                                        class="form-control form-control-enhanced <?php $__errorArgs = ['matriculeop'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="Matricule adversaire" wire:model="matriculeop">
                                    <?php $__errorArgs = ['matriculeop'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Compagnie Adversaire</label>
                                    <select name="companyop_id"
                                        class="form-control selectpicker <?php $__errorArgs = ['companyop_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        data-live-search="true"
                                        wire:model="companyop_id">
                                        <option value="" selected>Sélectionner Compagnie</option>
                                        <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($company->id); ?>"><?php echo e($company->company); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['companyop_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Numéro Attestation Adversaire</label>
                                    <input type="text" name="numero_attestationop"
                                        class="form-control form-control-enhanced <?php $__errorArgs = ['numero_attestationop'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="Numéro attestation" wire:model="numero_attestationop">
                                    <?php $__errorArgs = ['numero_attestationop'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <div class="mb-3 col-md-4">
                                    <label for="brand_idop" class="form-label">Marque Véhicule Adversaire</label>
                                    
                                    <div class="autocomplete-wrapper" wire:ignore.self>
                                        <input type="text" 
                                            id="brandOpAutocomplete"
                                            class="autocomplete-input <?php echo e($selectedBrandop ? 'has-value' : ''); ?>"
                                            placeholder="Tapez pour rechercher une marque..."
                                            wire:model.debounce.150ms="brandSearchOp"
                                            wire:focus="$set('showBrandDropdownOp', true)"
                                            autocomplete="off">
                                        
                                        <?php if($selectedBrandop): ?>
                                            <button type="button" class="autocomplete-clear" wire:click="clearBrandOp" title="Effacer">
                                                <i class="mdi mdi-close"></i>
                                            </button>
                                        <?php endif; ?>
                                        
                                        
                                        <?php if($showBrandDropdownOp && strlen($brandSearchOp) > 0): ?>
                                            <div class="autocomplete-dropdown">
                                                <?php if(count($brandResultsOp) > 0): ?>
                                                    <div class="autocomplete-hint">
                                                        <i class="mdi mdi-information-outline me-1"></i>
                                                        <?php echo e(count($brandResultsOp)); ?> marque(s) trouvée(s)
                                                    </div>
                                                    <?php $__currentLoopData = $brandResultsOp; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="autocomplete-item" wire:click="selectBrandOp(<?php echo e($brand->id); ?>, '<?php echo e(addslashes($brand->brand)); ?>')">
                                                            <i class="mdi mdi-car"></i>
                                                            <span class="brand-name"><?php echo e($brand->brand); ?></span>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <div class="autocomplete-empty">
                                                        <i class="mdi mdi-magnify-close me-1"></i>
                                                        Aucune marque trouvée pour "<?php echo e($brandSearchOp); ?>"
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <?php if($selectedBrandop && $selectedBrandNameOp): ?>
                                        <div class="selected-brand-badge">
                                            <i class="mdi mdi-car"></i>
                                            <?php echo e($selectedBrandNameOp); ?>

                                            <button type="button" class="remove-brand" wire:click="clearBrandOp" title="Supprimer">
                                                <i class="mdi mdi-close"></i>
                                            </button>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <input type="hidden" name="brand_idop" wire:model="selectedBrandop">
                                    
                                    <?php $__errorArgs = ['brand_idop'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                
                                <div class="mb-3 col-md-4">
                                    <label for="vehicule_modelop_id" class="form-label">Modèle Véhicule Adversaire</label>
                                    <select name="vehicule_modelop_id" id="vehicule_modelop_id"
                                        class="form-control form-control-enhanced <?php $__errorArgs = ['vehicule_modelop_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        wire:model="vehicule_modelop_id"
                                        <?php echo e(!$selectedBrandop ? 'disabled' : ''); ?>>
                                        <option value="" selected>
                                            <?php echo e($selectedBrandop ? 'Sélectionner un modèle' : 'Sélectionnez d\'abord une marque'); ?>

                                        </option>
                                        <?php if($modelsop): ?>
                                            <?php $__currentLoopData = $modelsop; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($model->id); ?>"><?php echo e($model->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </select>
                                    <?php if($selectedBrandop && $modelsop && count($modelsop) > 0): ?>
                                        <small class="text-muted"><?php echo e(count($modelsop)); ?> modèle(s) disponible(s)</small>
                                    <?php endif; ?>
                                    <?php $__errorArgs = ['vehicule_modelop_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    
                    <ul class="list-inline wizard mb-0 mt-4">
                        <li class="previous list-inline-item">
                            <?php if($count > 0): ?>
                                <button type="button" wire:click="previousStep()"
                                    class="btn btn-secondary">
                                    <i class="mdi mdi-arrow-left me-1"></i> Précédent
                                </button>
                            <?php endif; ?>
                        </li>
                        <li class="next list-inline-item float-end">
                            <?php if($count == 0): ?>
                                <button type="button" wire:click="vehiculeStep()"
                                    class="btn btn-primary">
                                    Suivant <i class="mdi mdi-arrow-right ms-1"></i>
                                </button>
                            <?php elseif($count == 1): ?>
                                <button type="submit" class="btn btn-success">
                                    <i class="mdi mdi-check me-1"></i> Créer le Dossier
                                </button>
                            <?php endif; ?>
                        </li>
                    </ul>
                </div>
            </form>
        </div>
    </div>

    
    <script>
    document.addEventListener('livewire:load', function() {
        initEnhancedInputs();
        initBrandAutocomplete();
        
        // Re-initialize after Livewire updates
        Livewire.hook('message.processed', function() {
            setTimeout(initEnhancedInputs, 100);
        });
        
        // Handle dossier import event
        Livewire.on('dossierImported', function() {
            // Refresh bootstrap-select pickers
            if (typeof jQuery !== 'undefined' && jQuery.fn.selectpicker) {
                jQuery('.selectpicker').selectpicker('refresh');
            }
        });
    });
    
    // ========================================
    // BRAND AUTOCOMPLETE
    // ========================================
    function initBrandAutocomplete() {
        // Close all autocomplete dropdowns when clicking outside
        document.addEventListener('click', function(e) {
            const wrappers = document.querySelectorAll('.autocomplete-wrapper');
            wrappers.forEach(wrapper => {
                if (!wrapper.contains(e.target)) {
                    // Close this dropdown
                    const input = wrapper.querySelector('input');
                    if (input) {
                        const fieldName = input.id.replace('Autocomplete', '');
                        if (fieldName === 'brand') window.livewire.find('<?php echo e($_instance->id); ?>').set('showBrandDropdown', false);
                        if (fieldName === 'city') window.livewire.find('<?php echo e($_instance->id); ?>').set('showCityDropdown', false);
                        if (fieldName === 'garage') window.livewire.find('<?php echo e($_instance->id); ?>').set('showGarageDropdown', false);
                        if (fieldName === 'intermediaire') window.livewire.find('<?php echo e($_instance->id); ?>').set('showIntermediaireDropdown', false);
                        if (fieldName === 'brandOp') window.livewire.find('<?php echo e($_instance->id); ?>').set('showBrandDropdownOp', false);
                    }
                }
            });
        });
        
        // Initialize keyboard navigation for all autocomplete fields
        initAutocompleteKeyboard('brandAutocomplete', 'showBrandDropdown');
        initAutocompleteKeyboard('cityAutocomplete', 'showCityDropdown');
        initAutocompleteKeyboard('garageAutocomplete', 'showGarageDropdown');
        initAutocompleteKeyboard('intermediaireAutocomplete', 'showIntermediaireDropdown');
        initAutocompleteKeyboard('brandOpAutocomplete', 'showBrandDropdownOp');
        
        // Initialize drag and drop for file upload
        initDragAndDrop();
    }
    
    function initAutocompleteKeyboard(inputId, dropdownProp) {
        const input = document.getElementById(inputId);
        if (!input || input.hasAttribute('data-keyboard-init')) return;
        input.setAttribute('data-keyboard-init', 'true');
        
        input.addEventListener('keydown', function(e) {
            const dropdown = this.closest('.autocomplete-wrapper').querySelector('.autocomplete-dropdown');
            if (!dropdown) return;
            
            const items = dropdown.querySelectorAll('.autocomplete-item');
            const current = dropdown.querySelector('.autocomplete-item.active');
            let index = Array.from(items).indexOf(current);
            
            if (e.key === 'ArrowDown') {
                e.preventDefault();
                if (index < items.length - 1) index++;
                else index = 0;
                items.forEach(i => i.classList.remove('active'));
                items[index]?.classList.add('active');
                items[index]?.scrollIntoView({ block: 'nearest' });
            }
            
            if (e.key === 'ArrowUp') {
                e.preventDefault();
                if (index > 0) index--;
                else index = items.length - 1;
                items.forEach(i => i.classList.remove('active'));
                items[index]?.classList.add('active');
                items[index]?.scrollIntoView({ block: 'nearest' });
            }
            
            if (e.key === 'Enter') {
                e.preventDefault();
                const active = dropdown.querySelector('.autocomplete-item.active');
                if (active) active.click();
                else if (items.length === 1) items[0].click();
            }
            
            if (e.key === 'Escape') {
                window.livewire.find('<?php echo e($_instance->id); ?>').set(dropdownProp, false);
                input.blur();
            }
        });
    }
    
    // ========================================
    // DRAG AND DROP FILE UPLOAD
    // ========================================
    function initDragAndDrop() {
        const dropZone = document.getElementById('dropZone');
        if (!dropZone || dropZone.hasAttribute('data-drop-init')) return;
        dropZone.setAttribute('data-drop-init', 'true');
        
        ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
            dropZone.addEventListener(eventName, preventDefaults, false);
        });
        
        function preventDefaults(e) {
            e.preventDefault();
            e.stopPropagation();
        }
        
        ['dragenter', 'dragover'].forEach(eventName => {
            dropZone.addEventListener(eventName, () => {
                dropZone.classList.add('drag-over');
            }, false);
        });
        
        ['dragleave', 'drop'].forEach(eventName => {
            dropZone.addEventListener(eventName, () => {
                dropZone.classList.remove('drag-over');
            }, false);
        });
        
        dropZone.addEventListener('drop', handleDrop, false);
        
        function handleDrop(e) {
            const dt = e.dataTransfer;
            const files = dt.files;
            
            // Trigger Livewire file upload
            const input = document.getElementById('fileUploadInput');
            if (input) {
                // Create a new DataTransfer to set files
                const dataTransfer = new DataTransfer();
                
                // Add existing files if any
                if (input.files) {
                    for (let i = 0; i < input.files.length; i++) {
                        dataTransfer.items.add(input.files[i]);
                    }
                }
                
                // Add new dropped files
                for (let i = 0; i < files.length; i++) {
                    dataTransfer.items.add(files[i]);
                }
                
                input.files = dataTransfer.files;
                
                // Trigger change event for Livewire
                const event = new Event('change', { bubbles: true });
                input.dispatchEvent(event);
            }
        }
    }
    
    function initEnhancedInputs() {
        // ========================================
        // WW MATRICULE AUTO-FORMAT
        // ========================================
        const wwInput = document.getElementById('matriculeWW');
        const wwBadge = document.getElementById('wwBadge');
        
        if (wwInput && !wwInput.hasAttribute('data-enhanced')) {
            wwInput.setAttribute('data-enhanced', 'true');
            
            let wwDebounce = null;
            
            wwInput.addEventListener('input', function(e) {
                let val = this.value.toUpperCase().replace(/[^A-Z0-9]/g, '');
                
                // Auto-add WW- prefix
                if (val.length >= 2 && val.substring(0, 2) === 'WW') {
                    val = 'WW-' + val.substring(2, 8);
                } else if (val.length > 0 && /^[0-9]/.test(val)) {
                    // If starts with number, assume WW prefix intended
                    val = 'WW-' + val.substring(0, 6);
                }
                
                this.value = val;
                
                // Update badge
                if (/^WW-[0-9]{1,6}$/.test(val)) {
                    wwBadge.className = 'matricule-badge valid';
                    wwBadge.innerHTML = '<i class="fas fa-check"></i> Valide';
                } else if (val.length > 0) {
                    wwBadge.className = 'matricule-badge invalid';
                    wwBadge.innerHTML = '<i class="fas fa-times"></i> Format WW-XXXXXX';
                } else {
                    wwBadge.className = 'matricule-badge';
                    wwBadge.textContent = 'WW-XXXXXX';
                }
                
                // Debounced search
                clearTimeout(wwDebounce);
                if (val.length >= 4) {
                    wwBadge.className = 'matricule-badge searching';
                    wwBadge.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Recherche...';
                    wwDebounce = setTimeout(() => {
                        window.livewire.find('<?php echo e($_instance->id); ?>').call('searchNewMatricule', val);
                    }, 400);
                }
            });
            
            // Search on blur
            wwInput.addEventListener('blur', function() {
                if (this.value.length >= 4) {
                    window.livewire.find('<?php echo e($_instance->id); ?>').call('searchNewMatricule', this.value);
                }
            });
        }
        
        // ========================================
        // OLD MATRICULE AUTO-FORMAT
        // ========================================
        const oldInput = document.getElementById('matriculeOld');
        const oldBadge = document.getElementById('oldBadge');
        
        if (oldInput && !oldInput.hasAttribute('data-enhanced')) {
            oldInput.setAttribute('data-enhanced', 'true');
            
            let oldDebounce = null;
            
            oldInput.addEventListener('input', function(e) {
                let val = this.value.toUpperCase().replace(/[^A-Z0-9]/g, '');
                let formatted = '';
                
                // Format: XXXXX-X-XX (5 digits, 1 letter, 2 digits)
                if (val.length > 0) {
                    // First 5 digits
                    formatted = val.substring(0, Math.min(5, val.length));
                    
                    if (val.length > 5) {
                        // Letter part
                        const letter = val.substring(5, 6);
                        if (/[A-Z]/.test(letter)) {
                            formatted += '-' + letter;
                        }
                    }
                    
                    if (val.length > 6) {
                        // Last 2 digits
                        const digits = val.substring(6, 8);
                        if (/[0-9]/.test(digits)) {
                            formatted += '-' + digits;
                        }
                    }
                }
                
                this.value = formatted;
                
                // Update badge
                if (/^[0-9]{1,5}-[A-Z]-[0-9]{1,2}$/.test(formatted)) {
                    oldBadge.className = 'matricule-badge valid';
                    oldBadge.innerHTML = '<i class="fas fa-check"></i> Valide';
                } else if (formatted.length > 0) {
                    oldBadge.className = 'matricule-badge invalid';
                    oldBadge.innerHTML = '<i class="fas fa-times"></i> Format XXXXX-X-XX';
                } else {
                    oldBadge.className = 'matricule-badge';
                    oldBadge.textContent = 'XXXXX-X-XX';
                }
                
                // Debounced search
                clearTimeout(oldDebounce);
                if (formatted.length >= 4) {
                    oldBadge.className = 'matricule-badge searching';
                    oldBadge.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Recherche...';
                    oldDebounce = setTimeout(() => {
                        window.livewire.find('<?php echo e($_instance->id); ?>').call('searchMatricule', formatted);
                    }, 400);
                }
            });
            
            // Search on blur
            oldInput.addEventListener('blur', function() {
                if (this.value.length >= 4) {
                    window.livewire.find('<?php echo e($_instance->id); ?>').call('searchMatricule', this.value);
                }
            });
        }
        
        // ========================================
        // CHASSIS NUMBER SEARCH
        // ========================================
        const chassisInput = document.getElementById('chassisNumber');
        
        if (chassisInput && !chassisInput.hasAttribute('data-enhanced')) {
            chassisInput.setAttribute('data-enhanced', 'true');
            
            let chassisDebounce = null;
            
            chassisInput.addEventListener('input', function(e) {
                this.value = this.value.toUpperCase().replace(/[^A-Z0-9]/g, '');
                
                clearTimeout(chassisDebounce);
                if (this.value.length >= 5) {
                    chassisDebounce = setTimeout(() => {
                        window.livewire.find('<?php echo e($_instance->id); ?>').call('searchChassis', this.value);
                    }, 500);
                }
            });
            
            // Search on blur
            chassisInput.addEventListener('blur', function() {
                if (this.value.length >= 5) {
                    window.livewire.find('<?php echo e($_instance->id); ?>').call('searchChassis', this.value);
                }
            });
        }
        
        // ========================================
        // CLIENT NAME SEARCH
        // ========================================
        const nameInput = document.getElementById('insuredName');
        
        if (nameInput && !nameInput.hasAttribute('data-enhanced')) {
            nameInput.setAttribute('data-enhanced', 'true');
            
            let nameDebounce = null;
            
            nameInput.addEventListener('input', function(e) {
                clearTimeout(nameDebounce);
                if (this.value.length >= 2) {
                    nameDebounce = setTimeout(() => {
                        window.livewire.find('<?php echo e($_instance->id); ?>').call('searchByName', this.value);
                    }, 500);
                }
            });
            
            // Search on blur
            nameInput.addEventListener('blur', function() {
                if (this.value.length >= 2) {
                    // Small delay to allow click on dropdown items
                    setTimeout(() => {
                        window.livewire.find('<?php echo e($_instance->id); ?>').call('searchByName', this.value);
                    }, 200);
                }
            });
        }
        
        // ========================================
        // VEHICLE API INTEGRATION
        // ========================================
        const apiToggle = document.getElementById('useCarQueryApi');
        
        if (apiToggle && !apiToggle.hasAttribute('data-enhanced')) {
            apiToggle.setAttribute('data-enhanced', 'true');
            
            apiToggle.addEventListener('change', function() {
                const useApi = this.checked;
                
                // Toggle containers
                document.getElementById('localBrandContainer').classList.toggle('d-none', useApi);
                document.getElementById('apiBrandContainer').classList.toggle('d-none', !useApi);
                document.getElementById('localModelContainer').classList.toggle('d-none', useApi);
                document.getElementById('apiModelContainer').classList.toggle('d-none', !useApi);
                document.getElementById('apiYearContainer').classList.toggle('d-none', !useApi);
                
                if (useApi) {
                    loadMakes();
                    loadYears();
                }
            });
        }
        
        // API Brand change handler
        const apiBrand = document.getElementById('apiBrand');
        if (apiBrand && !apiBrand.hasAttribute('data-enhanced')) {
            apiBrand.setAttribute('data-enhanced', 'true');
            
            apiBrand.addEventListener('change', function() {
                const makeId = this.value;
                const makeName = this.options[this.selectedIndex]?.textContent || '';
                const year = document.getElementById('apiYear')?.value;
                
                document.getElementById('apiBrandName').value = makeName;
                window.livewire.find('<?php echo e($_instance->id); ?>').set('api_brand_name', makeName);
                
                if (makeId) {
                    loadModels(makeId, makeName, year);
                }
            });
        }
        
        // API Model change handler
        const apiModel = document.getElementById('apiModel');
        if (apiModel && !apiModel.hasAttribute('data-enhanced')) {
            apiModel.setAttribute('data-enhanced', 'true');
            
            apiModel.addEventListener('change', function() {
                const modelName = this.value;
                document.getElementById('apiModelName').value = modelName;
                window.livewire.find('<?php echo e($_instance->id); ?>').set('api_model_name', modelName);
            });
        }
        
        // API Year change handler
        const apiYear = document.getElementById('apiYear');
        if (apiYear && !apiYear.hasAttribute('data-enhanced')) {
            apiYear.setAttribute('data-enhanced', 'true');
            
            apiYear.addEventListener('change', function() {
                const year = this.value;
                document.getElementById('apiYearValue').value = year;
                window.livewire.find('<?php echo e($_instance->id); ?>').set('api_year', year);
                
                // Reload models if brand selected
                const makeSelect = document.getElementById('apiBrand');
                if (makeSelect?.value) {
                    loadModels(makeSelect.value, makeSelect.options[makeSelect.selectedIndex]?.textContent, year);
                }
            });
        }
    }
    
    // Load years for API dropdown
    function loadYears() {
        const select = document.getElementById('apiYear');
        if (!select) return;
        
        select.innerHTML = '<option value="">Année (optionnel)</option>';
        const currentYear = new Date().getFullYear();
        for (let y = currentYear; y >= 1980; y--) {
            const option = document.createElement('option');
            option.value = y;
            option.textContent = y;
            select.appendChild(option);
        }
        
        if (typeof jQuery !== 'undefined' && jQuery.fn.selectpicker) {
            jQuery('#apiYear').selectpicker('refresh');
        }
    }
    
    // Load makes from NHTSA API
    function loadMakes() {
        const select = document.getElementById('apiBrand');
        if (!select) return;
        
        select.innerHTML = '<option value="">Chargement...</option>';
        if (typeof jQuery !== 'undefined' && jQuery.fn.selectpicker) {
            jQuery('#apiBrand').selectpicker('refresh');
        }
        
        fetch('https://vpic.nhtsa.dot.gov/api/vehicles/GetAllMakes?format=json')
            .then(response => response.json())
            .then(data => {
                select.innerHTML = '<option value="">Sélectionner une marque</option>';
                
                if (data.Results && data.Results.length > 0) {
                    // Sort with common makes first
                    const commonMakes = ['TOYOTA', 'HONDA', 'FORD', 'CHEVROLET', 'NISSAN', 'BMW', 
                        'MERCEDES-BENZ', 'AUDI', 'VOLKSWAGEN', 'HYUNDAI', 'KIA', 'MAZDA', 
                        'PEUGEOT', 'RENAULT', 'CITROEN', 'FIAT', 'DACIA', 'OPEL', 'SEAT', 'SKODA'];
                    
                    const sorted = data.Results.sort((a, b) => {
                        const aCommon = commonMakes.includes(a.Make_Name.toUpperCase());
                        const bCommon = commonMakes.includes(b.Make_Name.toUpperCase());
                        if (aCommon && !bCommon) return -1;
                        if (!aCommon && bCommon) return 1;
                        return a.Make_Name.localeCompare(b.Make_Name);
                    });
                    
                    sorted.forEach(make => {
                        const option = document.createElement('option');
                        option.value = make.Make_ID;
                        option.textContent = make.Make_Name;
                        select.appendChild(option);
                    });
                }
                
                if (typeof jQuery !== 'undefined' && jQuery.fn.selectpicker) {
                    jQuery('#apiBrand').selectpicker('refresh');
                }
            })
            .catch(error => {
                console.error('Error loading makes:', error);
                select.innerHTML = '<option value="">Erreur de chargement</option>';
            });
    }
    
    // Load models from NHTSA API
    function loadModels(makeId, makeName, year) {
        const select = document.getElementById('apiModel');
        if (!select) return;
        
        select.innerHTML = '<option value="">Chargement...</option>';
        if (typeof jQuery !== 'undefined' && jQuery.fn.selectpicker) {
            jQuery('#apiModel').selectpicker('refresh');
        }
        
        let url = `https://vpic.nhtsa.dot.gov/api/vehicles/GetModelsForMakeId/${makeId}?format=json`;
        if (year) {
            url = `https://vpic.nhtsa.dot.gov/api/vehicles/GetModelsForMakeIdYear/makeId/${makeId}/modelyear/${year}?format=json`;
        }
        
        fetch(url)
            .then(response => response.json())
            .then(data => {
                select.innerHTML = '<option value="">Sélectionner un modèle</option>';
                
                if (data.Results && data.Results.length > 0) {
                    // Remove duplicates and sort
                    const unique = [...new Map(data.Results.map(m => [m.Model_Name, m])).values()];
                    unique.sort((a, b) => a.Model_Name.localeCompare(b.Model_Name));
                    
                    unique.forEach(model => {
                        const option = document.createElement('option');
                        option.value = model.Model_Name;
                        option.textContent = model.Model_Name;
                        select.appendChild(option);
                    });
                }
                
                if (typeof jQuery !== 'undefined' && jQuery.fn.selectpicker) {
                    jQuery('#apiModel').selectpicker('refresh');
                }
            })
            .catch(error => {
                console.error('Error loading models:', error);
                select.innerHTML = '<option value="">Erreur de chargement</option>';
            });
    }
    </script>
</div><?php /**PATH /home/amea/public_html/demo4.ameaengi.com/resources/views/livewire/dossier-wizard.blade.php ENDPATH**/ ?>