@extends('layouts.dashboard.app')

@section('content')
<div class="container-fluid">
    <!-- Dossier Header -->
    <div class="dossier-header mb-4 mt-3">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h4 class="mb-1 text-white"><i class="uil uil-file-alt me-2"></i>Rapports du Dossier</h4>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item"><a href="{{ route('Dossier.show', $id) }}" class="text-white-50">Dossier</a></li>
                        <li class="breadcrumb-item active text-white" aria-current="page">Rapports</li>
                    </ol>
                </nav>
            </div>
            <div class="d-flex gap-2">
                <a href="{{ route('Dossier.show', $id) }}" class="btn btn-glass-light">
                    <i class="uil uil-arrow-left me-1"></i> Retour
                </a>
                @can('create', App\Models\Rapport::class)
                    <a href="{{ route('Rapport.create', ['id' => $id]) }}" class="btn btn-success-gradient">
                        <i class="uil uil-plus me-1"></i> Nouveau Rapport
                    </a>
                @endcan
            </div>
        </div>
    </div>

    <!-- Reports Table -->
    <div class="row">
        <div class="col-12">
            <div class="modern-card">
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-modern table-hover align-middle mb-0" id="myTable">
                            <thead class="table-light">
                                <tr>
                                    <th style="width: 50px;">
                                        <div class="form-check ms-3">
                                            <input type="checkbox" class="form-check-input" id="customCheck1">
                                            <label class="form-check-label" for="customCheck1">&nbsp;</label>
                                        </div>
                                    </th>
                                    <th>ID</th>
                                    <th>Reference</th>
                                    <th>Compagnie</th>
                                    <th>Matricule</th>
                                    <th>Statut</th>
                                    @can('view', App\Models\Rapport::class)
                                        <th class="text-end pe-4">Actions</th>
                                    @endcan
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($rapports as $rapport)
                                    <tr>
                                        <td>
                                            <div class="form-check ms-3">
                                                <input type="checkbox" class="form-check-input" id="check_{{ $rapport->id }}">
                                                <label class="form-check-label" for="check_{{ $rapport->id }}">&nbsp;</label>
                                            </div>
                                        </td>
                                        <td class="fw-bold">#{{ $rapport->id }}</td>
                                        <td>{{ $rapport->dossier->ref ?? '-' }}</td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="avatar-xs me-2">
                                                    <span class="avatar-title rounded-circle bg-soft-primary text-primary">
                                                        {{ substr($rapport->dossier->company->company ?? 'A', 0, 1) }}
                                                    </span>
                                                </div>
                                                <span>{{ $rapport->dossier->company->company ?? '-' }}</span>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge badge-soft-dark">{{ $rapport->dossier->matricule ?? '-' }}</span>
                                        </td>
                                        <td>
                                            <span class="badge badge-soft-{{ $rapport->status->color ?? 'secondary' }} rounded-pill px-3 py-2">
                                                {{ $rapport->status->status ?? 'Unknown' }}
                                            </span>
                                        </td>
                                        @can('view', App\Models\Rapport::class)
                                            <td class="text-end pe-4">
                                                <a href="{{ route('Rapport.show', $rapport->id) }}" class="btn btn-sm btn-soft-primary" title="Voir">
                                                    <i class="uil uil-eye"></i>
                                                </a>
                                                <a href="{{ route('Rapport.edit', $rapport->id) }}" class="btn btn-sm btn-soft-warning" title="Modifier">
                                                    <i class="uil uil-edit"></i>
                                                </a>
                                            </td>
                                        @endcan
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('style')
<style>
/* Modern Card & Header Styles */
.dossier-header {
    background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%);
    padding: 25px;
    border-radius: 16px;
    box-shadow: 0 4px 20px -5px rgba(0,0,0,0.2);
    margin-bottom: 24px;
    color: white;
}
.btn-glass-light {
    background: rgba(255,255,255,0.1);
    color: white;
    border: 1px solid rgba(255,255,255,0.2);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
}
.btn-glass-light:hover {
    background: rgba(255,255,255,0.2);
    color: white;
    transform: translateY(-2px);
}
.btn-success-gradient {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: white;
    border: none;
    box-shadow: 0 4px 15px rgba(16, 185, 129, 0.3);
    transition: all 0.3s ease;
}
.btn-success-gradient:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(16, 185, 129, 0.4);
    color: white;
}
.modern-card {
    background: #fff;
    border-radius: 16px;
    border: 1px solid #e2e8f0;
    box-shadow: 0 1px 3px rgba(0,0,0,0.05);
    overflow: hidden;
    transition: all 0.3s ease;
}
.modern-card:hover {
    box-shadow: 0 10px 30px -5px rgba(0,0,0,0.08);
    transform: translateY(-2px);
}
.table-modern thead th {
    background-color: #f8fafc;
    color: #64748b;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    padding: 1rem;
    border-bottom: 1px solid #e2e8f0;
}
.table-modern tbody td {
    padding: 1rem;
    vertical-align: middle;
    color: #334155;
    border-bottom: 1px solid #f1f5f9;
}
.table-modern tbody tr:last-child td {
    border-bottom: none;
}
.table-modern tbody tr:hover {
    background-color: #f8fafc;
}
.badge-soft-dark {
    color: #1e293b;
    background-color: rgba(30, 41, 59, 0.1);
}
.badge-soft-primary {
    color: #3b82f6;
    background-color: rgba(59, 130, 246, 0.1);
}
.badge-soft-success {
    color: #10b981;
    background-color: rgba(16, 185, 129, 0.1);
}
.badge-soft-danger {
    color: #ef4444;
    background-color: rgba(239, 68, 68, 0.1);
}
.badge-soft-warning {
    color: #f59e0b;
    background-color: rgba(245, 158, 11, 0.1);
}
.btn-soft-primary {
    color: #3b82f6;
    background-color: rgba(59, 130, 246, 0.1);
    border-color: transparent;
}
.btn-soft-primary:hover {
    color: #fff;
    background-color: #3b82f6;
}
.btn-soft-warning {
    color: #f59e0b;
    background-color: rgba(245, 158, 11, 0.1);
    border-color: transparent;
}
.btn-soft-warning:hover {
    color: #fff;
    background-color: #f59e0b;
}
</style>
@endsection
