@if (Auth::user()->role_id == 4)
    <?php
    $notifications = App\Models\Notification::with('user')
        ->whereDate('created_at', '=', Carbon\Carbon::today()->toDateString())
        ->latest()
        ->get();
    ?>
@else
    <?php
    $dossiers = App\Models\Dossier::user()->get();
    $array = [];
    foreach ($dossiers as $dossier) {
        array_push($array, $dossier->id);
    }
    $notifications = App\Models\Notification::whereIn('dossier_id', $array)
        ->whereDate('created_at', '=', Carbon\Carbon::today()->toDateString())
        ->latest()
        ->get();
    ?>
@endif

<style>
/* ============================================
   TOPBAR REDESIGN - Modern Style
   ============================================ */

.navbar-custom {
    position: relative !important;
    left: auto !important;
    top: auto !important;
    right: auto !important;
    
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
    height: 70px;
    min-height: 70px !important;
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 0 20px !important;
    box-shadow: 0 2px 15px rgba(0, 0, 0, 0.1);
    z-index: 99;
    box-sizing: border-box;
    
    margin-top: -70px !important;
    margin-left: -12px !important;
    margin-right: -12px !important;
    margin-bottom: 20px !important;
    
    width: calc(100% + 24px) !important;
    max-width: calc(100% + 24px) !important;
}

/* ============================================
   LEFT SECTION - Toggle Button
   ============================================ */
.navbar-custom .topbar-left {
    position: relative !important;
    left: auto !important;
    top: auto !important;
    width: auto !important;
    height: auto !important;
    background: transparent !important;
    text-align: left !important;
    
    display: flex;
    align-items: center;
    flex-shrink: 0;
}

.button-menu-mobile {
    background: rgba(255, 255, 255, 0.1) !important;
    border: none !important;
    color: #fff !important;
    width: 42px !important;
    height: 42px !important;
    border-radius: 10px !important;
    display: flex !important;
    align-items: center !important;
    justify-content: center !important;
    cursor: pointer;
    transition: all 0.2s ease;
    padding: 0 !important;
    line-height: 1 !important;
    margin-left: 8px;
}

.button-menu-mobile:hover {
    background: rgba(255, 255, 255, 0.2) !important;
}

.button-menu-mobile i {
    font-size: 22px !important;
    line-height: 1 !important;
    display: flex !important;
    align-items: center !important;
    justify-content: center !important;
    color: #fff !important;
}

/* ============================================
   CENTER SECTION - Search Bar
   ============================================ */
.topbar-center {
    flex: 1;
    display: flex;
    justify-content: center;
    padding: 0 20px;
}

.topbar-search {
    width: 100%;
    max-width: 500px;
}

.topbar-search .search-form {
    display: flex;
    align-items: center;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 25px;
    overflow: hidden;
    border: 1px solid rgba(255, 255, 255, 0.1);
    transition: all 0.2s ease;
}

.topbar-search .search-form:focus-within {
    background: rgba(255, 255, 255, 0.15);
    border-color: rgba(16, 185, 129, 0.5);
    box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.1);
}

.topbar-search .search-icon-left {
    display: flex;
    align-items: center;
    justify-content: center;
    padding-left: 15px;
    color: rgba(255, 255, 255, 0.5);
}

.topbar-search .search-icon-left i {
    font-size: 18px;
}

.topbar-search input[type="search"] {
    flex: 1;
    background: transparent;
    border: none;
    color: #fff;
    padding: 12px 15px;
    font-size: 14px;
    outline: none;
    min-width: 280px;
}

.topbar-search input[type="search"]::placeholder {
    color: rgba(255, 255, 255, 0.5);
    font-size: 13px;
}

.topbar-search input[type="search"]::-webkit-search-cancel-button {
    -webkit-appearance: none;
    appearance: none;
}

.topbar-search .search-btn {
    background: #10b981;
    border: none;
    color: #fff;
    width: 42px;
    height: 42px;
    margin: 2px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.2s ease;
    flex-shrink: 0;
    padding: 0;
}

.topbar-search .search-btn:hover {
    background: #059669;
    transform: scale(1.05);
}

.topbar-search .search-btn i {
    font-size: 18px;
    line-height: 1;
}

/* ============================================
   RIGHT SECTION - Config, Notifications & Profile
   ============================================ */
.navbar-custom .topbar-right {
    display: flex !important;
    align-items: center !important;
    gap: 12px;
    flex-shrink: 0;
    position: relative !important;
    z-index: 1;
    float: none !important;
}

/* Configuration Button */
.config-btn {
    position: relative;
    background: rgba(255, 255, 255, 0.1);
    border: none;
    color: #fff !important;
    width: 42px;
    height: 42px;
    border-radius: 10px;
    display: flex !important;
    align-items: center !important;
    justify-content: center !important;
    cursor: pointer;
    transition: all 0.2s ease;
    padding: 0 !important;
    margin: 0 !important;
    min-width: 42px !important;
    text-decoration: none !important;
}

.config-btn:hover {
    background: rgba(255, 255, 255, 0.2);
    color: #fff !important;
}

.config-btn i {
    font-size: 20px;
    line-height: 1;
    color: #fff !important;
}

/* Notification Button */
.notification-btn {
    position: relative;
    background: rgba(255, 255, 255, 0.1);
    border: none;
    color: #fff !important;
    width: 42px;
    height: 42px;
    border-radius: 10px;
    display: flex !important;
    align-items: center !important;
    justify-content: center !important;
    cursor: pointer;
    transition: all 0.2s ease;
    padding: 0 !important;
    margin: 0 !important;
    min-width: 42px !important;
    max-height: none !important;
    line-height: 1 !important;
    text-decoration: none !important;
}

.notification-btn:hover {
    background: rgba(255, 255, 255, 0.2);
    color: #fff !important;
}

.notification-btn i {
    font-size: 20px;
    line-height: 1;
    color: #fff !important;
}

/* Notification Badge - NOW SHOWS COUNT */
.notification-badge {
    position: absolute;
    top: 4px;
    right: 4px;
    min-width: 18px;
    height: 18px;
    background: #ef4444;
    color: #fff;
    font-size: 10px;
    font-weight: 700;
    border-radius: 9px;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 0 5px;
    border: 2px solid #1a1a2e;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.1); }
}

/* Notification Dropdown */
.notification-dropdown .dropdown-menu {
    min-width: 320px;
    max-width: 350px;
    border: none;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.15);
    border-radius: 12px;
    padding: 0;
    overflow: hidden;
    margin-top: 10px !important;
}

.notification-dropdown .noti-title {
    padding: 15px 20px;
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.notification-dropdown .noti-title h5 {
    margin: 0;
    color: #fff;
    font-size: 14px;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 10px;
}

.notification-dropdown .noti-title .badge {
    font-size: 11px;
    padding: 4px 8px;
}

.notification-dropdown .notify-item {
    display: block;
    padding: 0;
    margin: 8px;
    border-radius: 10px;
    transition: all 0.2s ease;
    text-decoration: none;
    border: 1px solid #e2e8f0;
}

.notification-dropdown .notify-item:hover {
    transform: translateX(5px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
    border-color: #10b981;
}

.notification-dropdown .notify-item .card-body {
    padding: 12px;
}

.notification-dropdown .noti-item-title {
    font-size: 13px;
    font-weight: 600;
    color: #1e293b;
    margin-bottom: 4px;
}

.notification-dropdown .noti-item-subtitle {
    font-size: 12px;
    color: #64748b;
    line-height: 1.4;
}

/* Profile Button */
.profile-btn {
    display: flex !important;
    align-items: center !important;
    gap: 10px;
    padding: 5px 12px 5px 5px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 25px;
    text-decoration: none !important;
    transition: all 0.2s ease;
    border: none;
    cursor: pointer;
}

.profile-btn:hover {
    background: rgba(255, 255, 255, 0.15);
}

.profile-avatar {
    width: 36px;
    height: 36px;
    border-radius: 50%;
    object-fit: cover;
    border: 2px solid rgba(255, 255, 255, 0.2);
}

.profile-info {
    display: flex;
    flex-direction: column;
    align-items: flex-start;
}

.profile-name {
    font-size: 13px;
    font-weight: 600;
    color: #fff;
    line-height: 1.2;
    max-width: 120px;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

.profile-role {
    font-size: 11px;
    color: rgba(255, 255, 255, 0.6);
    line-height: 1.2;
    max-width: 120px;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

/* Profile Dropdown */
.profile-dropdown .dropdown-menu {
    min-width: 200px;
    border: none;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.15);
    border-radius: 12px;
    padding: 8px;
    margin-top: 10px !important;
}

.profile-dropdown .dropdown-item {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 10px 15px;
    border-radius: 8px;
    font-size: 13px;
    color: #475569;
    transition: all 0.2s ease;
}

.profile-dropdown .dropdown-item:hover {
    background: #f1f5f9;
    color: #1e293b;
}

.profile-dropdown .dropdown-item i {
    font-size: 18px;
    width: 20px;
}

.profile-dropdown .dropdown-item.text-danger:hover {
    background: #fef2f2;
    color: #dc2626;
}

/* Quick Create Dropdown */
.quick-create-dropdown .dropdown-menu {
    min-width: 280px;
    border: none;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.15);
    border-radius: 12px;
    padding: 0;
    overflow: hidden;
    margin-top: 10px !important;
}

.quick-create-header {
    padding: 15px 20px;
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.quick-create-header h6 {
    margin: 0;
    color: #fff;
    font-size: 14px;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 8px;
}

.quick-create-header h6 i {
    color: #f59e0b;
}

.quick-create-items {
    padding: 10px;
    max-height: 350px;
    overflow-y: auto;
}

.quick-create-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 10px 12px;
    border-radius: 10px;
    text-decoration: none;
    transition: all 0.2s ease;
    margin-bottom: 4px;
}

.quick-create-item:hover {
    background: #f1f5f9;
    transform: translateX(5px);
}

.quick-create-item:last-child {
    margin-bottom: 0;
}

.quick-create-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}

.quick-create-icon i {
    font-size: 20px;
    color: #fff;
}

.quick-create-text {
    display: flex;
    flex-direction: column;
    min-width: 0;
}

.quick-create-title {
    font-size: 13px;
    font-weight: 600;
    color: #1e293b;
    line-height: 1.3;
}

.quick-create-desc {
    font-size: 11px;
    color: #64748b;
    line-height: 1.3;
}

/* ============================================
   RESPONSIVE BREAKPOINTS
   ============================================ */

@media (max-width: 1199px) {
    .topbar-search {
        max-width: 400px;
    }
    
    .profile-name,
    .profile-role {
        max-width: 100px;
    }
}

@media (max-width: 991px) {
    .topbar-center {
        display: none !important;
    }
    
    .profile-info {
        display: none !important;
    }
    
    .profile-btn {
        padding: 5px !important;
    }
    
    .navbar-custom {
        padding: 0 15px !important;
    }
}

@media (max-width: 767.98px) {
    .navbar-custom {
        padding: 0 12px !important;
        height: 65px;
        min-height: 65px !important;
        margin-top: -65px !important;
        margin-left: -10px !important;
        margin-right: -10px !important;
        margin-bottom: 15px !important;
        width: calc(100% + 20px) !important;
        max-width: calc(100% + 20px) !important;
    }
    
    .button-menu-mobile,
    .config-btn,
    .notification-btn {
        width: 38px !important;
        height: 38px !important;
        min-width: 38px !important;
    }
    
    .button-menu-mobile i,
    .config-btn i,
    .notification-btn i {
        font-size: 18px !important;
    }
    
    .profile-avatar {
        width: 34px;
        height: 34px;
    }
    
    .topbar-right {
        gap: 8px;
    }
    
    .notification-dropdown .dropdown-menu,
    .profile-dropdown .dropdown-menu {
        position: fixed !important;
        right: 10px !important;
        left: auto !important;
        top: 70px !important;
        transform: none !important;
        z-index: 1100;
    }
    
    .notification-dropdown .dropdown-menu {
        min-width: 280px;
    }
}

/* ============================================
   SIDEBAR TOGGLE BEHAVIOR
   ============================================ */
@media (max-width: 767.98px) {
    .leftside-menu {
        transform: translateX(-100%);
        transition: transform 0.3s ease;
        position: fixed !important;
        left: 0;
        top: 0;
        z-index: 1050;
    }
    
    body.sidebar-open .leftside-menu {
        transform: translateX(0);
    }
    
    body.sidebar-open::before {
        content: '';
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0, 0, 0, 0.5);
        z-index: 1040;
        animation: fadeIn 0.3s ease;
    }
    
    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }
}
</style>

<div class="navbar-custom">
    <!-- Left Section - Toggle -->
    <div class="topbar-left">
        <button class="button-menu-mobile" id="sidebarToggle" type="button">
            <i class="mdi mdi-menu"></i>
        </button>
    </div>

    <!-- Center Section - Search -->
    <div class="topbar-center d-none d-lg-flex">
        <div class="topbar-search">
            <form class="search-form" action="{{ route('Dossier.archiveSearch') }}" method="POST">
                @csrf
                <div class="search-icon-left">
                    <i class="uil uil-search"></i>
                </div>
                <input type="search" name="search" placeholder="Rechercher par matricule, nom, référence, n° sinistre..." value="">
                <button type="submit" class="search-btn">
                    <i class="uil uil-arrow-right"></i>
                </button>
            </form>
        </div>
    </div>

    <!-- Right Section - Config, Notifications & Profile -->
    <div class="topbar-right">
        
        <!-- Configuration Button - With Permission Check -->
        @if(Auth::user()->role_id == 1 || Auth::user()->role_id == 4)
        <a href="{{ route('Dossier.index') }}" class="config-btn" title="Configuration">
            <i class="fa fa-tools"></i>
        </a>
        @endif

        <!-- Quick Create Button - With Permission Check -->
        @if(Auth::user()->role_id == 1 || Auth::user()->role_id == 4)
        <div class="quick-create-dropdown dropdown">
            <button class="config-btn dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false" title="Création Rapide">
                <i class="mdi mdi-plus"></i>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <div class="quick-create-header">
                    <h6><i class="mdi mdi-lightning-bolt"></i> Création Rapide</h6>
                </div>
                <div class="quick-create-items">
                    <a href="{{ route('Dossier.create') }}" class="quick-create-item">
                        <div class="quick-create-icon" style="background: linear-gradient(135deg, #3b82f6, #2563eb);">
                            <i class="mdi mdi-folder-plus"></i>
                        </div>
                        <div class="quick-create-text">
                            <span class="quick-create-title">Nouveau Dossier</span>
                            <span class="quick-create-desc">Créer un dossier d'expertise</span>
                        </div>
                    </a>
                    <a href="/piece" class="quick-create-item">
                        <div class="quick-create-icon" style="background: linear-gradient(135deg, #10b981, #059669);">
                            <i class="mdi mdi-cog"></i>
                        </div>
                        <div class="quick-create-text">
                            <span class="quick-create-title">Pièces</span>
                            <span class="quick-create-desc">Gérer les pièces détachées</span>
                        </div>
                    </a>
                    <a href="/operation" class="quick-create-item">
                        <div class="quick-create-icon" style="background: linear-gradient(135deg, #f59e0b, #d97706);">
                            <i class="mdi mdi-wrench"></i>
                        </div>
                        <div class="quick-create-text">
                            <span class="quick-create-title">Opérations</span>
                            <span class="quick-create-desc">Gérer les opérations</span>
                        </div>
                    </a>
                    <a href="/company" class="quick-create-item">
                        <div class="quick-create-icon" style="background: linear-gradient(135deg, #8b5cf6, #7c3aed);">
                            <i class="mdi mdi-domain"></i>
                        </div>
                        <div class="quick-create-text">
                            <span class="quick-create-title">Compagnies</span>
                            <span class="quick-create-desc">Gérer les compagnies</span>
                        </div>
                    </a>
                    <a href="/garage" class="quick-create-item">
                        <div class="quick-create-icon" style="background: linear-gradient(135deg, #ec4899, #db2777);">
                            <i class="mdi mdi-car-wrench"></i>
                        </div>
                        <div class="quick-create-text">
                            <span class="quick-create-title">Garages</span>
                            <span class="quick-create-desc">Gérer les garages</span>
                        </div>
                    </a>
                    <a href="/user" class="quick-create-item">
                        <div class="quick-create-icon" style="background: linear-gradient(135deg, #06b6d4, #0891b2);">
                            <i class="mdi mdi-account-plus"></i>
                        </div>
                        <div class="quick-create-text">
                            <span class="quick-create-title">Utilisateurs</span>
                            <span class="quick-create-desc">Gérer les utilisateurs</span>
                        </div>
                    </a>
                </div>
            </div>
        </div>
        @endif

        <!-- Notifications -->
        <div class="notification-dropdown dropdown">
            <a href="#" class="notification-btn dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                <i class="dripicons-bell"></i>
                @if(count($notifications) > 0)
                <span class="notification-badge">{{ count($notifications) }}</span>
                @endif
            </a>

            <div class="dropdown-menu dropdown-menu-end">
                <div class="noti-title">
                    <h5>
                        Notifications
                        @if(count($notifications) > 0)
                        <span class="badge bg-success">{{ count($notifications) }}</span>
                        @endif
                    </h5>
                </div>
                
                <div class="px-2 py-2" style="max-height: 350px; overflow-y: auto;">
                    @if(count($notifications) > 0)
                    <small class="text-muted text-uppercase fw-semibold px-2">Aujourd'hui</small>
                    @endif
                    
                    @forelse ($notifications as $notification)
                    <a href="{{ route('Dossier.show', $notification->dossier_id) }}" class="notify-item card">
                        <div class="card-body">
                            <div class="d-flex align-items-start">
                                <div class="flex-shrink-0">
                                    <div style="width: 36px; height: 36px; background: linear-gradient(135deg, #10b981, #059669); border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                                        <i class="uil uil-bell text-white"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="noti-item-title mb-1">
                                        {{ $notification->user->name }}
                                        <small class="text-muted fw-normal">{{ $notification->created_at->diffForHumans() }}</small>
                                    </h6>
                                    <p class="noti-item-subtitle mb-0">{{ Str::limit($notification->body, 60) }}</p>
                                </div>
                            </div>
                        </div>
                    </a>
                    @empty
                    <div class="text-center py-4">
                        <i class="uil uil-bell-slash text-muted" style="font-size: 40px;"></i>
                        <p class="text-muted mt-2 mb-0">Aucune notification</p>
                    </div>
                    @endforelse
                </div>

                <a href="{{ route('notification.index') }}" class="dropdown-item text-center border-top py-3">
                    <span class="text-primary fw-semibold">Voir toutes les notifications</span>
                </a>
            </div>
        </div>

        <!-- Profile -->
        <div class="profile-dropdown dropdown">
            <a href="#" class="profile-btn dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                <img src="https://www.w3schools.com/howto/img_avatar.png" alt="{{ auth()->user()->name }}" class="profile-avatar">
                <div class="profile-info">
                    <span class="profile-name">{{ auth()->user()->name }}</span>
                    <span class="profile-role">{{ auth()->user()->role->role }}</span>
                </div>
            </a>
            
            <div class="dropdown-menu dropdown-menu-end">
                <a href="{{ route('user.profile') }}" class="dropdown-item">
                    <i class="uil uil-user"></i>
                    <span>Mon Profil</span>
                </a>
                <a href="{{ route('logout') }}" class="dropdown-item text-danger" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                    <i class="uil uil-sign-out-alt"></i>
                    <span>Déconnexion</span>
                </a>
                <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                    @csrf
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    var sidebarToggle = document.getElementById('sidebarToggle');
    var body = document.body;
    
    if (sidebarToggle) {
        sidebarToggle.addEventListener('click', function(e) {
            e.preventDefault();
            
            // Check if mobile or desktop
            if (window.innerWidth <= 767) {
                // Mobile: toggle sidebar-open class
                body.classList.toggle('sidebar-open');
            } else {
                // Desktop: toggle sidebar-collapsed class
                body.classList.toggle('sidebar-collapsed');
            }
        });
    }
    
    // Click outside to close sidebar on mobile
    document.addEventListener('click', function(e) {
        if (body.classList.contains('sidebar-open')) {
            var sidebar = document.querySelector('.leftside-menu');
            var toggle = document.getElementById('sidebarToggle');
            
            if (sidebar && !sidebar.contains(e.target) && toggle && !toggle.contains(e.target)) {
                body.classList.remove('sidebar-open');
            }
        }
    });
    
    // Reset on resize
    window.addEventListener('resize', function() {
        if (window.innerWidth > 767) {
            body.classList.remove('sidebar-open');
        }
    });
});
</script>