@extends('layouts.dashboard.app')


@section('content')
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="d-flex ">
                                <div class="col-md-6">
                                    @can('create', App\Models\SMS::class)
                                        <a style="float: left" href="{{ route('SMS.create') }}"
                                            class="btn btn-success rounded-pill"> Créer</a>
                                    @endcan
                                </div>
                                {{-- <div class="col-md-6">
                                    <a style="float: right" href="{{ route('TypeDossier.deleted') }}"
                                        class="btn btn-warning rounded-pill"> Restaurer</a>
                                </div> --}}
                            </div>
                        </div>
                        <div class="table-responsive">

                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Message</th>
                                        <th>Etape</th>
                                        <th>Modifier</th>
                                        <th>Supprimer</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($smss as $sms)
                                        <tr>
                                            <td>{{ $sms->id }}</td>
                                            <td>{{ $sms->message ?? null }}</td>
                                            <td> <span class="badge bg-success"> {{ $sms->step->step }} </span></td>
                                            @can('update', App\Models\SMS::class)
                                            <td>
                                                <a class="btn btn-sm btn-primary rounded-pill"
                                                    href="{{ route('SMS.edit', [$sms->id]) }}"><i
                                                        class="uil uil-pen fs-5"></i>
                                                </a>
                                            </td>
                                            @endcan
                                            @can('delete', App\Models\SMS::class)
                                            <td>
                                                <form action="{{ route('SMS.destroy', $sms->id) }}" method="Post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger rounded-pill">
                                                        <i class="uil uil-trash fs-5"></i>
                                                    </button>

                                                </form>
                                            </td>
                                            @endcan

                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
