<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Rapport d'Expertise - {{ $dossier->ref ?? 'N/A' }}</title>
</head>
<style>
    @page {
        margin: 12mm 8mm 15mm 8mm;
    }
    
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }
    
    body {
        font-family: 'DejaVu Sans', Arial, sans-serif;
        font-size: 9px;
        line-height: 1.2;
        color: #000;
    }

    .page-break {
        page-break-after: always;
    }

    /* Header Styles */
    .header-container {
        width: 100%;
        margin-bottom: 8px;
        border-bottom: 2px solid #1a365d;
        padding-bottom: 5px;
    }
    
    .logo-cell {
        width: 25%;
        vertical-align: middle;
    }
    
    .title-cell {
        width: 50%;
        text-align: center;
        vertical-align: middle;
    }
    
    .ref-cell {
        width: 25%;
        text-align: right;
        vertical-align: middle;
    }
    
    .report-title {
        font-size: 14px;
        font-weight: bold;
        color: #1a365d;
        text-transform: uppercase;
        letter-spacing: 1px;
    }
    
    .report-subtitle {
        font-size: 10px;
        color: #2d3748;
        margin-top: 3px;
    }

    /* Section Headers */
    .section-header {
        background-color: #1a365d;
        color: white;
        font-size: 9px;
        font-weight: bold;
        padding: 4px 8px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-top: 8px;
        margin-bottom: 4px;
    }

    /* Data Tables */
    .data-table {
        width: 100%;
        border-collapse: collapse;
        font-size: 8px;
        margin-bottom: 6px;
    }
    
    .data-table th {
        background-color: #e2e8f0;
        border: 1px solid #718096;
        padding: 3px 5px;
        text-align: left;
        font-weight: 600;
        color: #1a365d;
        width: 40%;
    }
    
    .data-table td {
        border: 1px solid #718096;
        padding: 3px 5px;
        text-align: left;
        background-color: #fff;
    }
    
    /* Two Column Layout */
    .two-col-table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 8px 0;
    }
    
    .two-col-table > tbody > tr > td {
        width: 50%;
        vertical-align: top;
    }

    /* Financial Tables */
    .finance-table {
        width: 100%;
        border-collapse: collapse;
        font-size: 8px;
    }
    
    .finance-table th {
        background-color: #1a365d;
        color: white;
        border: 1px solid #1a365d;
        padding: 4px 5px;
        text-align: center;
        font-weight: 600;
    }
    
    .finance-table td {
        border: 1px solid #718096;
        padding: 3px 5px;
        text-align: center;
    }
    
    .finance-table .label-cell {
        background-color: #e2e8f0;
        text-align: left;
        font-weight: 600;
    }
    
    .finance-table .total-row td {
        background-color: #bee3f8;
        font-weight: bold;
    }
    
    .finance-table .highlight-row td {
        background-color: #c6f6d5;
        font-weight: bold;
    }

    /* Pieces Table */
    .pieces-table {
        width: 100%;
        border-collapse: collapse;
        font-size: 7px;
    }
    
    .pieces-table th {
        background-color: #1a365d;
        color: white;
        border: 1px solid #1a365d;
        padding: 4px 3px;
        text-align: center;
        font-weight: 600;
    }
    
    .pieces-table td {
        border: 1px solid #a0aec0;
        padding: 3px;
        text-align: center;
    }
    
    .pieces-table tr:nth-child(even) {
        background-color: #f7fafc;
    }

    /* Shock Point & Observations */
    .shock-obs-table {
        width: 100%;
        margin-top: 8px;
    }
    
    .shock-cell {
        width: 40%;
        vertical-align: top;
        text-align: center;
    }
    
    .obs-cell {
        width: 60%;
        vertical-align: top;
        padding-left: 10px;
    }
    
    .shock-box {
        border: 1px solid #718096;
        padding: 5px;
        background: #f7fafc;
    }
    
    .shock-title {
        background-color: #1a365d;
        color: white;
        font-size: 8px;
        font-weight: bold;
        padding: 3px 6px;
        text-align: center;
        margin-bottom: 5px;
    }
    
    .shock-image {
        max-width: 200px;
        height: auto;
        max-height: 140px;
    }
    
    .shock-points {
        font-size: 7px;
        color: #4a5568;
        margin-top: 5px;
        text-align: left;
        padding: 3px;
        background: #edf2f7;
    }
    
    .obs-box {
        border: 1px solid #718096;
        padding: 8px;
        background: #fffaf0;
        min-height: 140px;
    }
    
    .obs-title {
        font-weight: bold;
        font-size: 9px;
        color: #1a365d;
        border-bottom: 1px solid #e2e8f0;
        padding-bottom: 4px;
        margin-bottom: 6px;
    }
    
    .obs-item {
        font-size: 8px;
        margin-bottom: 4px;
        padding-left: 8px;
        border-left: 2px solid #ed8936;
    }

    /* Values Table */
    .values-table {
        width: 48%;
        border-collapse: collapse;
        font-size: 8px;
    }
    
    .values-table th {
        background-color: #e2e8f0;
        border: 1px solid #718096;
        padding: 3px 5px;
        text-align: left;
        font-weight: 600;
    }
    
    .values-table td {
        border: 1px solid #718096;
        padding: 3px 5px;
        text-align: center;
    }

    /* Footer */
    .page-footer {
        text-align: center;
        font-size: 7px;
        color: #4a5568;
        margin-top: 10px;
        padding-top: 8px;
        border-top: 1px solid #a0aec0;
    }
    
    .company-info {
        font-size: 7px;
        line-height: 1.4;
    }

    /* Signatures */
    .signature-table {
        width: 100%;
        margin-top: 15px;
    }
    
    .signature-cell {
        width: 50%;
        text-align: center;
        vertical-align: top;
        padding: 10px;
    }
    
    .signature-line {
        border-bottom: 1px solid #000;
        width: 80%;
        margin: 30px auto 5px;
    }
    
    .signature-label {
        font-size: 8px;
        font-weight: bold;
    }

    /* Warning */
    .warning-box {
        border: 2px solid #c53030;
        color: #c53030;
        font-size: 8px;
        font-weight: bold;
        text-align: center;
        padding: 6px;
        margin: 10px 0;
        background: #fff5f5;
    }

    /* Image Gallery */
    .gallery-header {
        background-color: #1a365d;
        color: white;
        font-size: 10px;
        font-weight: bold;
        padding: 6px 10px;
        margin-bottom: 10px;
    }
    
    .gallery-table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 5px;
    }
    
    .gallery-cell {
        width: 32%;
        text-align: center;
        vertical-align: top;
        border: 1px solid #e2e8f0;
        padding: 4px;
        background: #f7fafc;
    }
    
    .gallery-img {
        width: 100%;
        height: 130px;
        object-fit: contain;
    }
    
    .gallery-label {
        font-size: 7px;
        color: #4a5568;
        margin-top: 3px;
    }

    /* Checkbox styling */
    .checkbox {
        display: inline-block;
        width: 10px;
        height: 10px;
        border: 1px solid #000;
        vertical-align: middle;
        margin-right: 3px;
        text-align: center;
        font-size: 8px;
        line-height: 10px;
    }
    
    .checkbox.checked::before {
        content: "✓";
    }
</style>

<body>
    <!-- ======================== PAGE 1: MAIN REPORT ======================== -->
    
    <!-- HEADER -->
    <table class="header-container" style="width: 100%;">
        <tr>
            <td class="logo-cell">
                <img src="img/amea2.png" style="height: 50px; width: auto;" alt="AMEA">
            </td>
            <td class="title-cell">
                <div class="report-title">RAPPORT D'EXPERTISE AUTOMOBILE</div>
                <div class="report-subtitle">{{ $dossier->typeexpertise->type ?? 'Expertise' }} - {{ $dossier->mode->mode ?? '' }}</div>
            </td>
            <td class="ref-cell">
                <div style="font-size: 10px; font-weight: bold; color: #1a365d;">Réf: {{ $dossier->ref ?? 'N/A' }}</div>
                <div style="font-size: 8px; margin-top: 3px;">N° Sinistre: {{ $dossier->numero_sinistre ?? 'N/A' }}</div>
            </td>
        </tr>
    </table>

    <!-- ASSURANCE & DATES - Side by Side -->
    <table class="two-col-table">
        <tr>
            <td>
                <div class="section-header">COMPAGNIE D'ASSURANCE</div>
                <table class="data-table">
                    <tr>
                        <th>Assurance</th>
                        <td>{{ $dossier->company->company ?? '-' }}</td>
                    </tr>
                    <tr>
                        <th>Expert</th>
                        <td>AMEA</td>
                    </tr>
                    <tr>
                        <th>Intermédiaire</th>
                        <td>{{ $dossier->intermidiaire->company ?? '-' }}</td>
                    </tr>
                    <tr>
                        <th>Garantie</th>
                        <td>{{ $dossier->guarantee->guarantee ?? '-' }}</td>
                    </tr>
                </table>
            </td>
            <td>
                <div class="section-header">DATES & RÉFÉRENCES</div>
                <table class="data-table">
                    <tr>
                        <th>Date Réception Mission</th>
                        <td>{{ $dossier->date_reception ?? '-' }}</td>
                    </tr>
                    <tr>
                        <th>Date d'Expertise</th>
                        <td>@if ($meeting){{ $meeting->date ?? '-' }}@else - @endif</td>
                    </tr>
                    <tr>
                        <th>Date du Sinistre</th>
                        <td>{{ $dossier->date_sinistre ?? '-' }}</td>
                    </tr>
                    <tr>
                        <th>Date Rapport Définitif</th>
                        <td>{{ $dossier->onerapport->created_at->format('Y-m-d') ?? '-' }}</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

    <!-- VEHICULES - Side by Side -->
    <table class="two-col-table">
        <tr>
            <td>
                <div class="section-header">VÉHICULE EXPERTISÉ</div>
                <table class="data-table">
                    <tr>
                        <th>Assuré</th>
                        <td>{{ $dossier->insured->name ?? '-' }}</td>
                    </tr>
                    <tr>
                        <th>N° Police</th>
                        <td>{{ $dossier->numero_police ?? '-' }}</td>
                    </tr>
                    <tr>
                        <th>Immatriculation</th>
                        <td><strong>{{ $dossier->matricule ?? $dossier->new_matricule }}</strong></td>
                    </tr>
                    <tr>
                        <th>Marque / Modèle</th>
                        <td>{{ $dossier->vehiculemodel->brand->brand ?? '' }} {{ $dossier->vehiculemodel->name ?? '' }}</td>
                    </tr>
                    <tr>
                        <th>N° Chassis</th>
                        <td style="font-size: 7px;">{{ $dossier->numero_chassis ?? '-' }}</td>
                    </tr>
                    <tr>
                        <th>DMC</th>
                        <td>{{ $dossier->date_circulation ?? '-' }}</td>
                    </tr>
                    <tr>
                        <th>Kilométrage</th>
                        <td>{{ $dossier->kilometrage ?? '-' }} Km</td>
                    </tr>
                    <tr>
                        <th>Puissance Fiscale</th>
                        <td>{{ $dossier->puissance_fiscale ?? '-' }} CV</td>
                    </tr>
                    <tr>
                        <th>Carburant</th>
                        <td>{{ $dossier->carburant->name ?? '-' }}</td>
                    </tr>
                </table>
            </td>
            <td>
                <div class="section-header">VÉHICULE ADVERSE</div>
                <table class="data-table">
                    <tr>
                        <th>Nom</th>
                        <td>{{ $dossier->opponent->name ?? '-' }}</td>
                    </tr>
                    <tr>
                        <th>Compagnie</th>
                        <td>{{ $dossier->opponent->company->company ?? '-' }}</td>
                    </tr>
                    <tr>
                        <th>Immatriculation</th>
                        <td>{{ $dossier->opponent->matricule ?? '-' }}</td>
                    </tr>
                    <tr>
                        <th>N° Police</th>
                        <td>{{ $dossier->opponent->numero_attestation ?? '-' }}</td>
                    </tr>
                </table>
                
                <!-- Checkboxes -->
                <table class="data-table" style="margin-top: 8px;">
                    <tr>
                        <th>Lieu de Visite</th>
                        <td style="font-size: 7px;">{{ Str::limit($dossier->garage->libelle ?? '-', 30) }}</td>
                    </tr>
                    <tr>
                        <th>Visite en Cours</th>
                        <td>@if ($encours){{ $encours->created_at->format('Y-m-d') }}@else - @endif</td>
                    </tr>
                    <tr>
                        <th>Visite Fin Travaux</th>
                        <td>@if ($apres){{ $apres->created_at->format('Y-m-d') }}@else - @endif</td>
                    </tr>
                </table>
                
                <table style="width: 100%; font-size: 8px; margin-top: 5px;">
                    <tr>
                        <td style="padding: 2px;">
                            <span class="checkbox @if($rapport->taux && $rapport->taux->tva_deductible) checked @endif"></span> TVA Récup.
                        </td>
                        <td style="padding: 2px;">
                            <span class="checkbox @if($dossier->mode_id == 2) checked @endif"></span> Réforme Éco.
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 2px;">
                            <span class="checkbox @if($dossier->type_expertise_id == 10) checked @endif"></span> Prise en Charge
                        </td>
                        <td style="padding: 2px;">
                            <span class="checkbox @if($dossier->mode_id == 3) checked @endif"></span> Réforme Tech.
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

    <!-- FINANCIAL SUMMARY -->
    <div class="section-header">RÉCAPITULATIF FINANCIER</div>
    <table class="two-col-table">
        <tr>
            <td>
                <table class="finance-table">
                    <tr>
                        <th colspan="2">DÉTAIL DES COÛTS</th>
                    </tr>
                    <tr>
                        <td class="label-cell">Devis Initial</td>
                        <td>@if ($devis){{ number_format($devis->montant_devis, 2, ',', ' ') }}@else 0,00 @endif {{ $dossier->currency->symbole ?? 'MAD' }}</td>
                    </tr>
                    <tr>
                        <td class="label-cell">Pièces Récup. HT</td>
                        <td>{{ number_format($recup, 2, ',', ' ') }} {{ $dossier->currency->symbole ?? 'MAD' }}</td>
                    </tr>
                    <tr>
                        <td class="label-cell">Pièces Origine HT</td>
                        <td>{{ number_format($org, 2, ',', ' ') }} {{ $dossier->currency->symbole ?? 'MAD' }}</td>
                    </tr>
                    <tr>
                        <td class="label-cell">Pièces Adaptables HT</td>
                        <td>{{ number_format($adpt, 2, ',', ' ') }} {{ $dossier->currency->symbole ?? 'MAD' }}</td>
                    </tr>
                    <tr>
                        <td class="label-cell">Ingrédients</td>
                        <td>{{ number_format($ingr, 2, ',', ' ') }} {{ $dossier->currency->symbole ?? 'MAD' }}</td>
                    </tr>
                    <tr class="total-row">
                        <td class="label-cell">Total HT</td>
                        <td>{{ number_format($ht, 2, ',', ' ') }} {{ $dossier->currency->symbole ?? 'MAD' }}</td>
                    </tr>
                </table>
            </td>
            <td>
                <table class="finance-table">
                    <tr>
                        <th colspan="2">MONTANTS FINAUX</th>
                    </tr>
                    <tr>
                        <td class="label-cell">Montant TVA</td>
                        <td>{{ number_format($tva, 2, ',', ' ') }} {{ $dossier->currency->symbole ?? 'MAD' }}</td>
                    </tr>
                    <tr>
                        <td class="label-cell">Total TTC</td>
                        <td>{{ number_format($ttl, 2, ',', ' ') }} {{ $dossier->currency->symbole ?? 'MAD' }}</td>
                    </tr>
                    <tr>
                        <td class="label-cell">Vétusté</td>
                        <td>{{ number_format($vet, 2, ',', ' ') }} {{ $dossier->currency->symbole ?? 'MAD' }}</td>
                    </tr>
                    <tr>
                        <td class="label-cell">Franchise</td>
                        <td>{{ number_format($fr, 2, ',', ' ') }} {{ $dossier->currency->symbole ?? 'MAD' }}</td>
                    </tr>
                    <tr>
                        <td class="label-cell">Remise</td>
                        <td>{{ number_format($remise, 2, ',', ' ') }} {{ $dossier->currency->symbole ?? 'MAD' }}</td>
                    </tr>
                    <tr class="highlight-row">
                        <td class="label-cell">Montant Compagnie</td>
                        <td>{{ number_format($montantcompany, 2, ',', ' ') }} {{ $dossier->currency->symbole ?? 'MAD' }}</td>
                    </tr>
                    <tr>
                        <td class="label-cell">Montant Client</td>
                        <td>{{ number_format($montantclient, 2, ',', ' ') }} {{ $dossier->currency->symbole ?? 'MAD' }}</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

    <!-- DETAILS EN % / RÉPARTITION -->
    <table class="two-col-table" style="margin-top: 8px;">
        <tr>
            <td>
                @php
                    // Calculate total Main d'œuvre (all main0X values)
                    $totalMainOeuvre = $main01 + $main02 + $main03 + $main04 + $main05 + $main06 + $main07;
                    $totalIngredient = $ingr;
                    $totalPieces = $montantpieces;
                    $grandTotal = $totalMainOeuvre + $totalIngredient + $totalPieces;
                    
                    // Calculate percentages
                    $pctMainOeuvre = $grandTotal > 0 ? round(($totalMainOeuvre / $grandTotal) * 100, 1) : 0;
                    $pctIngredient = $grandTotal > 0 ? round(($totalIngredient / $grandTotal) * 100, 1) : 0;
                    $pctPieces = $grandTotal > 0 ? round(($totalPieces / $grandTotal) * 100, 1) : 0;
                @endphp
                <div style="border: 1px solid #718096; padding: 8px; background: #f7fafc;">
                    <div style="background-color: #1a365d; color: white; font-size: 9px; font-weight: bold; padding: 5px; margin-bottom: 8px; text-align: center;">RÉPARTITION DES COÛTS</div>
                    
                    <!-- Stacked Bar Chart (simulates pie chart) -->
                    <div style="width: 100%; height: 30px; border: 1px solid #718096; overflow: hidden; margin-bottom: 8px;">
                        @if($pctMainOeuvre > 0)
                            <div style="display: inline-block; width: {{ $pctMainOeuvre }}%; height: 100%; background: #2b6cb0; float: left;"></div>
                        @endif
                        @if($pctIngredient > 0)
                            <div style="display: inline-block; width: {{ $pctIngredient }}%; height: 100%; background: #38a169; float: left;"></div>
                        @endif
                        @if($pctPieces > 0)
                            <div style="display: inline-block; width: {{ $pctPieces }}%; height: 100%; background: #ed8936; float: left;"></div>
                        @endif
                    </div>
                    
                    <!-- Legend with bars -->
                    <table style="width: 100%; font-size: 7px; border-collapse: collapse;">
                        <tr>
                            <td style="padding: 3px; width: 35%;">
                                <span style="display: inline-block; width: 12px; height: 12px; background: #2b6cb0; vertical-align: middle; margin-right: 3px;"></span>
                                <strong>Main d'œuvre</strong>
                            </td>
                            <td style="padding: 3px; text-align: right; width: 30%;">{{ number_format($totalMainOeuvre, 0, ',', ' ') }} {{ $dossier->currency->symbole ?? 'MAD' }}</td>
                            <td style="padding: 3px; text-align: right; width: 15%; font-weight: bold; color: #2b6cb0;">{{ $pctMainOeuvre }}%</td>
                        </tr>
                        <tr>
                            <td style="padding: 3px;">
                                <span style="display: inline-block; width: 12px; height: 12px; background: #38a169; vertical-align: middle; margin-right: 3px;"></span>
                                <strong>Ingrédient</strong>
                            </td>
                            <td style="padding: 3px; text-align: right;">{{ number_format($totalIngredient, 0, ',', ' ') }} {{ $dossier->currency->symbole ?? 'MAD' }}</td>
                            <td style="padding: 3px; text-align: right; font-weight: bold; color: #38a169;">{{ $pctIngredient }}%</td>
                        </tr>
                        <tr>
                            <td style="padding: 3px;">
                                <span style="display: inline-block; width: 12px; height: 12px; background: #ed8936; vertical-align: middle; margin-right: 3px;"></span>
                                <strong>Pièces</strong>
                            </td>
                            <td style="padding: 3px; text-align: right;">{{ number_format($totalPieces, 0, ',', ' ') }} {{ $dossier->currency->symbole ?? 'MAD' }}</td>
                            <td style="padding: 3px; text-align: right; font-weight: bold; color: #ed8936;">{{ $pctPieces }}%</td>
                        </tr>
                        <tr style="border-top: 1px solid #718096; background: #e2e8f0;">
                            <td style="padding: 4px; font-weight: bold;">TOTAL</td>
                            <td style="padding: 4px; text-align: right; font-weight: bold;">{{ number_format($grandTotal, 0, ',', ' ') }} {{ $dossier->currency->symbole ?? 'MAD' }}</td>
                            <td style="padding: 4px; text-align: right; font-weight: bold;">100%</td>
                        </tr>
                    </table>
                </div>
            </td>
            <td>
                <!-- SHOCK POINT -->
                @if ($chock)
                <div class="shock-box">
                    <div class="shock-title">POINT DE CHOC</div>
                    <img class="shock-image" src="{{ Storage::disk('s3')->temporaryUrl($chock->path, now()->addMinutes(30)) }}" alt="Point de Choc">
                    <div class="shock-points">
                        <strong>Points:</strong>
                        @foreach ($dossier->shockpoint as $point)
                            {{ $point->point }}@if(!$loop->last), @endif
                        @endforeach
                    </div>
                </div>
                @endif
            </td>
        </tr>
    </table>

    <!-- OBSERVATIONS -->
    <table class="two-col-table" style="margin-top: 8px;">
        <tr>
            <td colspan="2">
                <div class="obs-box">
                    <div class="obs-title">OBSERVATIONS</div>
                    @if(count($observations) > 0)
                        @foreach ($observations as $observation)
                            <div class="obs-item">{{ $observation->observation }}</div>
                        @endforeach
                    @else
                        <div style="font-size: 8px; color: #999; font-style: italic;">Aucune observation</div>
                    @endif
                </div>
            </td>
        </tr>
    </table>

    <!-- SIGNATURE SECTION -->
    @if ($sign > 0)
        <table class="signature-table">
            <tr>
                <td class="signature-cell">
                    <img src="img/sign.png" style="height: 50px; width: auto;">
                    <div class="signature-label">L'EXPERT</div>
                </td>
                <td class="signature-cell">
                    <div class="signature-line"></div>
                    <div class="signature-label">
                        @if ($dossier->contradictoire)
                            {{ $dossier->contradictoire->adverse->name ?? 'EXPERT ADVERSE' }}
                        @else
                            EXPERT ADVERSE
                        @endif
                    </div>
                </td>
            </tr>
        </table>
    @endif

    <!-- FOOTER -->
    <div class="page-footer">
        <div class="company-info">
            <strong>AMEA - Cabinet d'Expertise Automobile Agréé</strong><br>
            Parc Plaza Bd. Yaakoub Al Mansour Imm.G2 28800 - Mohammedia<br>
            Tél: 052330564 - Fax: 0523305672 - Email: amea.maroc@gmail.com<br>
            RC: 12583 | TP: 39570820 | IF: 14392431 | CNSS: 4472213 | ICE: 001376800000001
        </div>
    </div>

    <!-- ======================== PAGE 2: PIECES DETAIL ======================== -->
    <div class="page-break"></div>
    
    <table class="header-container" style="width: 100%;">
        <tr>
            <td class="logo-cell">
                <img src="img/amea2.png" style="height: 40px; width: auto;" alt="AMEA">
            </td>
            <td class="title-cell">
                <div style="font-size: 12px; font-weight: bold; color: #1a365d;">DÉTAIL DES PIÈCES ET OPÉRATIONS</div>
            </td>
            <td class="ref-cell">
                <div style="font-size: 9px; font-weight: bold;">Réf: {{ $dossier->ref ?? 'N/A' }}</div>
            </td>
        </tr>
    </table>

    <div class="section-header">LISTE DES PIÈCES</div>
    <table class="pieces-table">
        <tr>
            <th style="width: 20%;">Désignation</th>
            <th style="width: 8%;">Qté</th>
            <th style="width: 15%;">Opération</th>
            <th style="width: 10%;">Type</th>
            <th style="width: 10%;">Remise</th>
            <th style="width: 10%;">Vétusté</th>
            <th style="width: 12%;">Prix U.</th>
            <th style="width: 15%;">Montant</th>
        </tr>
        @if ($rapport->piece)
            @foreach ($rapport->piece as $piece)
                <tr>
                    <td style="text-align: left;">{{ $piece->piece ?? '-' }}</td>
                    <td>{{ $piece->pivot->qte ?? '-' }}</td>
                    <td>{{ $piece->pivot->operation->operation ?? '-' }}</td>
                    <td>{{ $piece->pivot->typereparation->type ?? '-' }}</td>
                    <td>{{ $piece->pivot->remise ?? 0 }}%</td>
                    <td>{{ $piece->pivot->vetuste ?? 0 }}%</td>
                    <td>{{ number_format($piece->pivot->prix_unitaire ?? 0, 2, ',', ' ') }}</td>
                    <td>
                        @if ($piece->pivot->type_reparation_id == 1)
                            @php
                                $rem = $piece->pivot->qte * $piece->pivot->prix_unitaire * ($piece->pivot->remise / 100);
                                $montantpieces = $piece->pivot->prix_unitaire * $piece->pivot->qte - $rem;
                                $vet = $montantpieces * ($piece->pivot->vetuste / 100);
                                $montantpieces = $montantpieces - $vet;
                            @endphp
                        @else
                            @php
                                $rem = $piece->pivot->qte * $piece->pivot->prix_unitaire * ($piece->pivot->remise / 100);
                                $tvaa = ($piece->pivot->prix_unitaire * $piece->pivot->qte - $rem) * 0.2;
                                $montantpieces = $piece->pivot->prix_unitaire * $piece->pivot->qte - $rem + $tvaa;
                                if ($rapport->taux && $rapport->taux->tva_deductible) {
                                    $vet = ($piece->pivot->qte * $piece->pivot->prix_unitaire - $rem) * ($piece->pivot->vetuste / 100);
                                } else {
                                    $vet = ($piece->pivot->qte * $piece->pivot->prix_unitaire - $rem + $tvaa) * ($piece->pivot->vetuste / 100);
                                }
                                $montantpieces = $montantpieces - $vet;
                            @endphp
                        @endif
                        {{ number_format($montantpieces, 2, ',', ' ') }}
                    </td>
                </tr>
            @endforeach
        @endif
    </table>

    <!-- CONTRADICTOIRE SECTION -->
    <div style="margin-top: 15px; font-size: 8px; border: 1px solid #718096; padding: 8px; background: #f7fafc;">
        <strong>Examen Contradictoire effectué en présence de:</strong> {{ $dossier->insured->civility ?? '' }} {{ $dossier->insured->name ?? '-' }}<br>
        <em>Visé après accord sur les dégâts apparents constatés</em>
    </div>

    <!-- WARNING -->
    <div class="warning-box">
        ⚠️ CECI N'EST PAS UN BON DE PRISE EN CHARGE NI UN ORDRE DE PAIEMENT
    </div>

    <div style="font-size: 7px; text-align: center; margin-top: 10px;">
        POUR FAIRE VALOIR LE PRÉSENT DOCUMENT, IL DOIT ÊTRE COSIGNÉ DES DEUX PARTIES
    </div>

    <!-- SIGNATURE SECTION PAGE 2 -->
    <table class="signature-table">
        <tr>
            <td class="signature-cell">
                @if ($sign > 0)
                    <img src="img/sign.png" style="height: 40px; width: auto;">
                @else
                    <div class="signature-line"></div>
                @endif
                <div class="signature-label">L'EXPERT</div>
            </td>
            <td class="signature-cell">
                <div class="signature-line"></div>
                <div class="signature-label">
                    @if ($dossier->contradictoire)
                        {{ $dossier->contradictoire->adverse->name ?? 'EXPERT ADVERSE' }}
                    @else
                        EXPERT ADVERSE
                    @endif
                </div>
            </td>
        </tr>
    </table>

    <!-- FOOTER PAGE 2 -->
    <div class="page-footer">
        <div class="company-info">
            AMEA - Parc Plaza Bd. Yaakoub Al Mansour Imm.G2 28800 Mohammedia | Tél: 052330564 | ICE: 001376800000001
        </div>
    </div>

    <!-- ======================== PAGE 3: PHOTO GALLERY ======================== -->
    @if ($rapport->documents_count > 0)
        <div class="page-break"></div>
        
        <table class="header-container" style="width: 100%;">
            <tr>
                <td class="logo-cell">
                    <img src="img/amea2.png" style="height: 40px; width: auto;" alt="AMEA">
                </td>
                <td class="title-cell">
                    <div style="font-size: 12px; font-weight: bold; color: #1a365d;">DOCUMENTATION PHOTOGRAPHIQUE</div>
                </td>
                <td class="ref-cell">
                    <div style="font-size: 9px; font-weight: bold;">Réf: {{ $dossier->ref ?? 'N/A' }}</div>
                </td>
            </tr>
        </table>

        <table class="gallery-table">
            @foreach ($rapport->documents->chunk(3) as $row)
                <tr>
                    @foreach ($row as $doc)
                        <td class="gallery-cell">
                            <img class="gallery-img" src="{{ Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30)) }}" alt="Photo {{ $loop->parent->index * 3 + $loop->index + 1 }}">
                            <div class="gallery-label">{{ $doc->typedocument->type ?? 'Photo' }} #{{ $loop->parent->index * 3 + $loop->index + 1 }}</div>
                        </td>
                    @endforeach
                    @for ($i = $row->count(); $i < 3; $i++)
                        <td class="gallery-cell" style="background: transparent; border: none;"></td>
                    @endfor
                </tr>
            @endforeach
        </table>

        <div class="page-footer">
            <div class="company-info">
                AMEA - Cabinet d'Expertise Automobile Agréé | ICE: 001376800000001
            </div>
        </div>
    @endif

    <script type="text/php">
        if (isset($pdf)) {
            $pageText = "Page {PAGE_NUM} / {PAGE_COUNT}";
            $font = $fontMetrics->get_font("DejaVu Sans", "normal");
            $size = 8;
            $color = array(0.4, 0.4, 0.4);
            $x = 270;
            $y = 820;
            $pdf->page_text($x, $y, $pageText, $font, $size, $color);
        }
    </script>
</body>

</html>
