@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid ">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <h4 class="page-title">Liste des Devises </h4>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="d-flex ">
                                <div class="col-md-6">
                                    <a style="float: left" href="{{ route('Currency.create') }}"
                                        class="btn btn-success rounded-pill"> Créer</a>
                                </div>

                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Devise</th>
                                        <th>Symbole</th>
                                        <th>Modifier</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($currencies as $currency)
                                        <tr>
                                            <td>{{ $currency->id }}</td>
                                            <td>{{ $currency->name }}</td>
                                            <td>{{ $currency->symbole ?? null }}</td>

                                            <td> <a class="btn btn-sm btn-primary rounded-pill"
                                                    href="{{ route('Currency.edit', [$currency->id]) }}"><i
                                                        class="uil uil-pen fs-5"></i>
                                                 </a>
                                            </td>

                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
