<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('table_carb_pfs', function (Blueprint $table) {
            $table->id();
            $table->bigInteger("carburant_id")->unsigned();
            $table->foreign("carburant_id")->references("id")->on("carburants");
            $table->bigInteger("pf_id")->unsigned();
            $table->foreign("pf_id")->references("id")->on("pfs");
            $table->string("kms");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('table_carb_pfs');
    }
};
