<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->string('ref')->unique()->nullable();
            $table->foreignId('dossier_id')->constrained()->onDelete(null);
            $table->foreignId('note_honoraire_id')->onDelete(null);
            $table->foreignId('note_honoraire_status_id')->onDelete(null);
            $table->decimal('frais_deplacement',10,2)->nullable();
            $table->decimal('frais_sejour',10,2)->nullable();
            $table->decimal('frais_divers',10,2)->nullable();
            $table->decimal('montant',10,2);
           


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payments');
    }
};
