<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('step_dossier', function (Blueprint $table) {
            $table->id();
            $table->foreignId('step_id')->constrained()->onDelete(null);
            $table->foreignId('dossier_id')->constrained()->onDelete(null);
            $table->foreignId('user_id')->constrained()->onDelete(null);
            $table->integer('delai')->nullable();
            $table->integer('etat')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('step_dossier');
    }
};
