<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('devis', function (Blueprint $table) {

            $table->id();
            $table->foreignId('dossier_id')->constrained()->onDelete(null);
            $table->foreignId('devis_status_id')->constrained()->onDelete(null);
            $table->foreignId('taux_id')->nullable()->constrained()->onDelete(null);

            $table->decimal('montant_devis',10,2)->nullable();
            $table->integer('devis');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('devis');
    }
};
