<?php

namespace App\Policies;

use App\Models\Sms;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class SmsPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user)
    {
        if( $user->role_id === 4 || $user->hasPermission('naviguer_sms') || $user->hasRolePermission('naviguer_sms') ){
            return true;
        }
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Sms  $sms
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function view(User $user)
    {
        if( $user->role_id === 4 || $user->hasPermission('afficher_sms') || $user->hasRolePermission('afficher_sms') ){
            return true;
        }
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user)
    {
        if( $user->role_id === 4 || $user->hasPermission('ajouter_sms') || $user->hasRolePermission('ajouter_sms') ){
            return true;
        }
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Sms  $sms
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user)
    {
        if( $user->role_id === 4 || $user->hasPermission('modifier_sms') || $user->hasRolePermission('modifier_sms') ){
            return true;
        }
    }

    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Sms  $sms
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function delete(User $user)
    {
        if( $user->role_id === 4  ){
            return true;
        }
    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Sms  $sms
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function restore(User $user)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Sms  $sms
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function forceDelete(User $user)
    {
        //
    }
}
