<?php

namespace App\Policies;

use App\Models\Demande;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class DemandePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user )
    {
        if ($user->role_id === 4)
        {
            return true;
        }
        if ($user->hasPermission('naviguer_demandes') || $user->hasRolePermission('naviguer_demandes'))
        {
            return true;
        }
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Demande  $demande
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function view(User $user)
    {
        if ($user->role_id === 4)
        {
            return true;
        }
        if ($user->hasPermission('afficher_demandes') || $user->hasRolePermission('afficher_demandes')) {
            return true;
        }
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user)
    {
        if ($user->role_id === 4)
        {
            return true;
        }
        if ($user->hasPermission('ajouter_demandes') || $user->hasRolePermission('ajouter_demandes')) {
            return true;
        }
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Demande  $demande
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('modifier_demandes') || $user->hasRolePermission('modifier_demandes')) {
            return true;
        }
    }

    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Demande  $demande
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function delete(User $user, Demande $demande)
    {
        //
    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Demande  $demande
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function restore(User $user, Demande $demande)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Demande  $demande
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function forceDelete(User $user, Demande $demande)
    {
        //
    }
}
