<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Seuil extends Model
{
    use HasFactory,SoftDeletes;

    protected $fillable = ['accord', 'max', 'min','user_id','company_id'];

    public function user()
    {
        return $this->belongsTo(User::class)->withTrashed();
    }
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

}
