<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Intermidiaire extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['company','email','phone','address'];

    public function opponent()
    {
        return $this->hasMany(Opponent::class)->withTrashed();
    }
    public function dossier()
    {
        return $this->hasMany(Dossier::class)->withTrashed();
    }

}
