<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Email extends Model
{
    use HasFactory;
    protected $fillable =[
        'content',
        'delai',
        'subject',
        'step_id'
    ];

    public function step()
    {
        return $this->belongsTo(Step::class,'step_id');
    }

    public function typedocument()
    {
        return $this->belongsToMany(TypeDocument::class,'typedocument_email');
    }

    public function hasType($type)
    {
        return $this->typedocument->contains('type', $type);
    }

}
