@extends('layouts.dashboard.app')

@section('content')

    <form action="{{ route('Dossier.update', $dossier->id) }}" method="post">
        @csrf
        @method('PUT')
        <div class="row">
            <div class="page-title-left ">
                <a href="{{ route('Dossier.show', $dossier->id) }}" class="mt-2 btn btn-outline-dark">Dossier</a>
            </div>
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title mb-3">Dossier {{ $dossier->ref }}</h4>

                        <div class="table-responsive">
                            <table class="table mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Matricule WW</th>
                                        <th>Matricule </th>
                                        <th>Date Sinistre</th>
                                        <th>Date Reception</th>
                                        <th>Mode</th>
                                        <th>Type Expertise</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>

                                        <td>
                                            <input type="text" name="new_matricule"
                                                class="form-control @error('new_matricule') is-invalid @enderror"
                                                value="{{ $dossier->new_matricule }}" id="new_matricule">
                                            @error('new_matricule')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td>
                                            <input type="text" name="matricule"
                                                class="form-control @error('matricule') is-invalid @enderror"
                                                value="{{ $dossier->matricule }}" id="matricule">
                                            @error('matricule')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>

                                        <td>
                                            <input type="date" name="date_sinistre"
                                                class="form-control @error('date_sinistre') is-invalid @enderror"
                                                value="{{ $dossier->date_sinistre ?? null }}" id="date_sinistre">
                                            @error('date_sinistre')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td>
                                            <input type="date" name="date_reception"
                                                class="form-control @error('date_reception') is-invalid @enderror"
                                                value="{{ $dossier->date_reception ?? null }}" id="date_reception">
                                            @error('date_reception')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>

                                        <td>
                                            <select name="mode" class="form-control @error('mode') is-invalid @enderror"
                                                id="">
                                                @if (!empty($dossier->mode->id))
                                                    <option selected value="{{ $dossier->mode->id }}">
                                                        {{ $dossier->mode->mode ?? null }}</option>
                                                @endif
                                                @foreach ($modes as $mode)
                                                    <option value="{{ $mode->id ?? null }}">
                                                        {{ $mode->mode ?? null }}</option>
                                                @endforeach
                                            </select>
                                            @error('mode')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror

                                        </td>
                                        <td>
                                            <select name="typeexpertise"
                                                class="form-control @error('typeexpertise') is-invalid @enderror"
                                                id="">
                                                <option selected value="{{ $dossier->typeexpertise->id ?? null }}">
                                                    {{ $dossier->typeexpertise->type ?? 'Selectioner Un Type' }}</option>
                                                @foreach ($typeexpertises as $type)
                                                    <option value="{{ $type->id }}">
                                                        {{ $type->type }}</option>
                                                @endforeach
                                            </select>
                                            @error('typeexpertise')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <!-- end table-responsive -->
                    </div>
                </div>
            </div> <!-- end col -->


        </div>
        <div class="row mt-2">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">

                        <h4 class="header-title mb-3">Assuré</h4>

                        <div class="table-responsive">
                            <table class="table mb-0 ">
                                <thead class="table-light">
                                    <tr>
                                        <th>Civilité</th>
                                        <th>Nom </th>
                                        <th>Telephone</th>
                                        <th>Garage</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <select name="civility"
                                                class="form-control @error('civility') is-invalid @enderror" id="">
                                                @if (!empty($dossier->insured->civility))
                                                    <option value="{{ $dossier->insured->civility }}">
                                                        {{ $dossier->insured->civility }}</option>
                                                    @if ($dossier->insured->civility == 'Mr')
                                                        <option value="Mme">Mme</option>
                                                        <option value="Sociéte">Sociéte</option>
                                                    @elseif($dossier->insured->civility == 'Mme')
                                                        <option value="Mr">Mr</option>
                                                        <option value="Sociéte">Sociéte</option>
                                                    @else
                                                        <option value="Mr">Mr</option>
                                                        <option value="Mme">Mme</option>
                                                    @endif
                                                @else
                                                    <option value="Mr">Mr</option>
                                                    <option value="Mme">Mme</option>
                                                    <option value="Sociéte">Sociéte</option>
                                                @endif

                                                <option value="Sociéte">Sociéte</option>

                                            </select>
                                             @error('civility')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td> <input type="text" name="name"
                                                class="form-control @error('name') is-invalid @enderror "
                                                value="{{ $dossier->insured->name ?? null }}" id="name">
                                            @error('name')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td>
                                            <input type="text" name="telephone"
                                                class="form-control @error('telephone') is-invalid @enderror"
                                                placeholder="0666666666" value="{{ $dossier->insured->telephone ?? null }}"
                                                id="telephone">
                                            @error('telephone')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td class="col-4">
                                            <select id="garage_id" name="garage_id"
                                                class="selectGarage form-control @error('garage_id') is-invalid @enderror">

                                                <option value="{{ $dossier->garage->id ?? null }}" selected>
                                                    {{ $dossier->garage->libelle ?? 'Selectionner le Garage' }}</option>
                                                @foreach ($garages as $garage)
                                                    <option value="{{ $garage->id }}">{{ $garage->libelle }}</option>
                                                @endforeach

                                            </select>

                                            @error('garage_id')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>

                                    </tr>

                                </tbody>
                            </table>
                        </div>
                        <!-- end table-responsive -->
                        <!-- end col -->
                    </div>
                </div>
            </div>

        </div> <!-- end col -->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Compagnie</th>
                                        <th>Intermidiaire</th>
                                        <th>Garantie</th>
                                        <th>Type Vehicule</th>
                                        <th>Marque</th>
                                        <th>Modéle</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <select name="company"
                                                class="form-control @error('company') is-invalid @enderror"
                                                id="">
                                                <option selected value="{{ $dossier->company->id ?? null }}">
                                                    {{ $dossier->company->company ?? null }}</option>
                                                @foreach ($companies as $company)
                                                    <option value="{{ $company->id }}">
                                                        {{ $company->company }}</option>
                                                @endforeach
                                            </select>
                                            @error('company')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror

                                        </td>
                                        <td>
                                            <select name="intermidiaire_id" id="mySelect"
                                                class=" @error('intermidiaire_id') is-invalid @enderror">
                                                <option value="{{ $dossier->intermidiaire->id ?? null }}" selected>
                                                    {{ $dossier->intermidiaire->company ?? 'Selectionner Intermidiaire' }}
                                                </option>
                                                @foreach ($intermidiaires as $intermidiaire)
                                                    <option value="{{ $intermidiaire->id }}">
                                                        {{ $intermidiaire->company }}
                                                    </option>
                                                @endforeach

                                            </select>

                                            @error('intermidiaire_id')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td>
                                            <select name="guarantee"
                                                class="form-control @error('guarantee') is-invalid @enderror"
                                                id="">
                                                <option selected value="{{ $dossier->guarantee->id ?? null }}">
                                                    {{ $dossier->guarantee->guarantee ?? null }}</option>
                                                @foreach ($guarantees as $guarantee)
                                                    <option value="{{ $guarantee->id }}">
                                                        {{ $guarantee->guarantee }}</option>
                                                @endforeach
                                            </select>
                                            @error('guarantee')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td>
                                            <select name="typevehicule"
                                                class="form-control @error('typevehicule') is-invalid @enderror"
                                                id="">
                                                <option selected value="{{ $dossier->typevehicule->id ?? null }}">
                                                    {{ $dossier->typevehicule->type ?? null }}</option>
                                                @foreach ($typevehicules as $typevehicule)
                                                    <option value="{{ $typevehicule->id }}">
                                                        {{ $typevehicule->type }}</option>
                                                @endforeach
                                            </select>
                                            @error('typevehicule')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td>

                                            <select name="brand_id" id="brand_id"
                                                class="form-control @error('brand_id') is-invalid @enderror">
                                                <option value="{{ $dossier->vehiculemodel->brand->id ?? null }}" selected>
                                                    {{ $dossier->vehiculemodel->brand->brand ?? 'Selectionner une Marque' }}
                                                </option>
                                                @foreach ($brands as $brand)
                                                    <option data-brand-id='{{ $brand->id }}'
                                                        value="{{ $brand->id }}">{{ $brand->brand }}</option>
                                                @endforeach
                                            </select>
                                            @error('brand_id')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td class="col-md-2">
                                            <select name="vehicule_model_id" id="vehicule_model_id"
                                                class="form-control @error('vehicule_model_id') is-invalid @enderror">
                                                <option value="{{ $dossier->vehiculemodel->id ?? null }}" selected>
                                                    {{ $dossier->vehiculemodel->name ?? 'Selectionner un model' }}</option>
                                            </select>
                                            @error('vehicule_model_id')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror

                                        </td>

                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <!-- end table-responsive -->

                    </div>
                </div>
            </div> <!-- end col -->


        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Devises</th>
                                        <th>Ville</th>
                                        <th>Numero Sinistre</th>
                                        <th>Numero Attsetation</th>
                                        <th>Numero Police</th>
                                        <th>Numero Chassis</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>

                                            <select name="currency_id" id="currency_id"
                                                class="form-control @error('currency_id') is-invalid @enderror">
                                                <option value="{{ $dossier->currency->id ?? null }}" selected>
                                                    {{ $dossier->currency->name ?? 'Selectionner un Devise' }}
                                                </option>
                                                @foreach ($currencies as $currency)
                                                    <option data-brand-id='{{ $currency->id }}'
                                                        value="{{ $currency->id }}">{{ $currency->name }}</option>
                                                @endforeach
                                            </select>
                                            @error('currency_id')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td>

                                            <select name="city_id" id="city_id"
                                                class="form-control @error('city_id') is-invalid @enderror">
                                                <option value="{{ $dossier->city->id ?? null }}" selected>
                                                    {{ $dossier->city->city ?? 'Selectionner une Ville' }}
                                                </option>
                                                @foreach ($cities as $city)
                                                    <option data-brand-id='{{ $city->id }}'
                                                        value="{{ $city->id }}">{{ $city->city }}</option>
                                                @endforeach
                                            </select>
                                            @error('city_id')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td>
                                            <input type="text" name="numero_sinistre"
                                                value="{{ $dossier->numero_sinistre ?? null }}"
                                                class="form-control @error('numero_sinistre') is-invalid @enderror"
                                                placeholder="Entrer le numero de sinistre">

                                            @error('numero_sinistre')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td>
                                            <input type="text" name="numero_attestation"
                                                value="{{ $dossier->numero_attestation ?? null }}"
                                                class="form-control @error('numero_attestation') is-invalid @enderror"
                                                placeholder="Entrer le numero de attestation">

                                            @error('numero_attestation')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td>
                                            <input type="text" name="numero_police"
                                                value="{{ $dossier->numero_police ?? null }}"
                                                class="form-control @error('numero_police') is-invalid @enderror"
                                                placeholder="Entrer le numero de police">

                                            @error('numero_police')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td>
                                            <input type="text" name="numero_chassis"
                                                value="{{ $dossier->numero_chassis ?? null }}"
                                                class="form-control @error('numero_chassis') is-invalid @enderror"
                                                placeholder="Entrer le numero de chassis" wire:model="numero_chassis">

                                            @error('numero_chassis')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <!-- end table-responsive -->

                    </div>
                </div>
            </div> <!-- end col -->


        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Montant Accord Adverse</th>
                                        <th>Kilométrage</th>
                                        <th>Puissance Fiscale</th>
                                        <th>Carburant</th>
                                        <th>DMC</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <input type="text" name="montant_accord_adverse"
                                                class="form-control @error('montant_accord_adverse') is-invalid @enderror"
                                                value="{{ $dossier->montant_accord_adverse ?? null }}" id="montant_accord_adverse">
                                            @error('montant_accord_adverse')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td>
                                            <input type="text" name="kilometrage"
                                                class="form-control @error('kilometrage') is-invalid @enderror"
                                                value="{{ $dossier->kilometrage ?? null }}" id="kilometrage">
                                            @error('kilometrage')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td>
                                            <input type="text" name="puissance_fiscale"
                                                class="form-control @error('puissance_fiscale') is-invalid @enderror"
                                                value="{{ $dossier->puissance_fiscale ?? null }}" id="puissance_fiscale">
                                            @error('puissance_fiscale')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td>
                                            <select id="carburant" name="carburant"
                                                class="form-control @error('carburant') is-invalid @enderror"
                                                wire:model="carburant">
                                                <option value="{{ $dossier->carburant->id ?? null }}" selected>
                                                    {{ $dossier->carburant->name ?? 'Selectionner Carburant' }}
                                                </option>
                                                @foreach ($carburants as $carb)
                                                    <option value="{{ $carb->id }}">{{ $carb->name }}</option>
                                                @endforeach

                                            </select>

                                            @error('carburant')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror

                                        </td>
                                        <td>
                                            <input type="date" name="date_circulation"
                                                value="{{ $dossier->date_circulation ?? null }}"
                                                class="form-control @error('date_circulation') is-invalid @enderror"
                                                placeholder="Entrer la date de mise en Circulation">

                                            @error('date_circulation')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <!-- end table-responsive -->
                    </div>
                </div>
            </div> <!-- end col -->


        </div>
        <div class="row mt-2">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title mb-3">Adversaire</h4>
                        <div class="table-responsive">
                            <table class="table mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Civilité</th>
                                        <th>Nom Complet</th>
                                        <th>Matricule</th>
                                        <th>Telephone</th>
                                        <th>Marque</th>
                                        <th>Vehicule</th>
                                        <th>Compagnie</th>
                                        <th>Numero Police</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <select name="civilityop"
                                                class="form-control @error('civilityop') is-invalid @enderror"
                                                id="">
                                                @if (!empty($dossier->opponent->civility))
                                                    <option value="{{ $dossier->opponent->civility }}">
                                                        {{ $dossier->opponent->civility }}</option>
                                                    @if ($dossier->opponent->civility == 'Mr')
                                                        <option value="Mme">Mme</option>
                                                        <option value="Sociéte">Sociéte</option>
                                                    @elseif($dossier->opponent->civility == 'Mme')
                                                        <option value="Mr">Mr</option>
                                                        <option value="Sociéte">Sociéte</option>
                                                    @else
                                                        <option value="Mr">Mr</option>
                                                        <option value="Mme">Mme</option>
                                                    @endif
                                                @else
                                                    <option value="Mr">Mr</option>
                                                    <option value="Mme">Mme</option>
                                                    <option value="Sociéte">Sociéte</option>
                                                @endif

                                            </select>
                                            @error('civilityop')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td>
                                            <input type="text" name="nameop"
                                                class="form-control @error('nameop') is-invalid @enderror"
                                                value="{{ $dossier->opponent->name ?? null }}" id="nameop">
                                            @error('nameop')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td>
                                            <input type="text" name="matriculeop"
                                                class="form-control @error('matriculeop') is-invalid @enderror"
                                                value="{{ $dossier->opponent->matricule ?? null }}" id="matriculeop">
                                            @error('matriculeop')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td>
                                            <input type="text" name="telephoneop"
                                                class="form-control @error('telephoneop') is-invalid @enderror"
                                                placeholder="0666666666"
                                                value="{{ $dossier->opponent->telephone ?? null }}" id="telephoneop">
                                            @error('telephoneop')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td>
                                            <select name="brandop_id" id="filter_orders"
                                                class="form-control @error('brandop_id') is-invalid @enderror">
                                                <option
                                                    value="{{ $dossier->opponent->vehiculemodel->brand->id ?? null }}"
                                                    selected>
                                                    {{ $dossier->opponent->vehiculemodel->brand->brand ?? 'Selectionner une marque' }}
                                                </option>
                                                @foreach ($brands as $brand)
                                                    <option data-brandop-id='{{ $brand->id }}'
                                                        value="{{ $brand->id }}">{{ $brand->brand }}</option>
                                                @endforeach
                                            </select>
                                            @error('brandop_id')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td class="col-md-2">
                                            <select name="vehicule_modelop_id" id="vehicule_modelop_id"
                                                class="form-control @error('vehicule_modelop_id') is-invalid @enderror">
                                                <option value="{{ $dossier->opponent->vehiculemodel->id ?? null }}"
                                                    selected>
                                                    {{ $dossier->opponent->vehiculemodel->name ?? 'Selectionner un model' }}
                                                </option>
                                            </select>

                                            @error('vehicule_modelop_id')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td class="col-md-2">
                                            <select name="company_op" id="company_op"
                                                class="form-control @error('company_op') is-invalid @enderror">
                                                <option value="{{ $dossier->opponent->company->id ?? null }}" selected>
                                                    {{ $dossier->opponent->company->company ?? 'Selectionner une Compagnie' }}
                                                </option>
                                                @foreach ($companiesop as $comp)
                                                    <option value="{{ $comp->id }}">{{ $comp->company }}</option>
                                                @endforeach
                                            </select>

                                            @error('company_op')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td class="col-md-2">
                                            <input type="text" name="numero_attestationop"
                                                class="form-control @error('numero_attestationop') is-invalid @enderror"
                                                value="{{ $dossier->opponent->numero_attestation ?? null }}"
                                                id="numero_attestationop">
                                            @error('numero_attestationop')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>


            <div class="row mt-2">

                <div class="col-lg-12">
                    <button style="float: right" class=" mr-2 btn btn-success">Modifier Dossier</button>
                </div>
            </div>
    </form>

    <form method="POST" action="{{ route('Devis.updatedossier',$dossier->id) }}">
        @csrf
        @method('PUT')
        <div class="row mt-2">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">

                        <h4 class="header-title mb-3">Valeurs :</h4>

                        <div class="table-responsive">
                            <table class="table mb-0 ">
                                <thead class="table-light">
                                    <tr>
                                        <th>Type</th>
                                        <th>Valeur Neuf</th>
                                        <th>Valeur Epave </th>
                                        <th>Hors Sinitre</th>
                                        {{-- <th>Valeur A Dire</th> --}}
                                        <th>Valeur Vénale</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            HT
                                        </td>
                                        <td>
                                            <input type="number" name="valeurneuf"
                                                class="form-control @error('valeurneuf') is-invalid @enderror " step="0.01" placeholder="Valeur Neuf HT"
                                                value="{{ $dossier->valeurneuf ?? null }}" id="valeurneuf">
                                            @error('valeurneuf')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td>
                                            <input type="number" name="valeurepave"
                                                class="form-control @error('valeurepave') is-invalid @enderror " step="0.01" placeholder="Valeur Epave HT"
                                                value="{{ $dossier->valeurepave ?? null }}" id="valeurepave">
                                            @error('valeurepave')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td>
                                            <input type="number" name="horssinistre"
                                                class="form-control @error('horssinistre') is-invalid @enderror " step="0.01" placeholder="Hors Sinistre HT"
                                                value="{{ $dossier->horssinistre ?? null }}" id="horssinistre">
                                            @error('horssinistre')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        {{-- <td>
                                            <input type="number" name="valeuradire"
                                                class="form-control @error('valeuradire') is-invalid @enderror "
                                                value="{{ $dossier->valeuradire ?? null }}" id="valeuradire">
                                            @error('valeuradire')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td> --}}
                                        <td>
                                            <input type="number" name="valeurvenale"
                                                class="form-control @error('valeurvenale') is-invalid @enderror " step="0.01" placeholder="Valeur Vénale HT"
                                                value="{{ $dossier->valeurvenale ?? null }}" id="valeurvenale">
                                            @error('valeurvenale')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>

                                    </tr>
                                    <tr>
                                        <td>
                                            TTC
                                        </td>
                                        <td>
                                            <input type="number" name="valeurneuf_ttc"
                                                class="form-control @error('valeurneuf_ttc') is-invalid @enderror " step="0.01" placeholder="Valeur Neuf TTC"
                                                value="{{ $dossier->valeurneuf_ttc ?? null }}" id="valeurneuf_ttc">
                                            @error('valeurneuf')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td>
                                            <input type="number" name="valeurepave_ttc"
                                                class="form-control @error('valeurepave_ttc') is-invalid @enderror " step="0.01" placeholder="Valeur Epave TTC"
                                                value="{{ $dossier->valeurepave_ttc ?? null }}" id="valeurepave_ttc">
                                            @error('valeurepave_ttc')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td>
                                            <input type="number" name="horssinistre_ttc"
                                                class="form-control @error('horssinistre_ttc') is-invalid @enderror " step="0.01" placeholder="Hors Sinistre TTC"
                                                value="{{ $dossier->horssinistre_ttc ?? null }}" id="horssinistre_ttc">
                                            @error('horssinistre_ttc')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        {{-- <td>
                                            <input type="number" name="valeuradire"
                                                class="form-control @error('valeuradire') is-invalid @enderror "
                                                value="{{ $dossier->valeuradire ?? null }}" id="valeuradire">
                                            @error('valeuradire')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td> --}}
                                        <td>
                                            <input type="number" name="valeurvenale_ttc"
                                                class="form-control @error('valeurvenale_ttc') is-invalid @enderror " step="0.01" placeholder="Valeur Vénale TTC"
                                                value="{{ $dossier->valeurvenale_ttc ?? null }}" id="valeurvenale_ttc">
                                            @error('valeurvenale_ttc')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>

                                    </tr>
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <div class="row mt-2">

            <div class="col-lg-12">
                <button style="float: right" type="submit" class=" mr-2 btn btn-info">Modifier Valeurs</button>
            </div>
        </div>
    </form>

@endsection
@section('script')
<script>
    $(document).ready(function () {
        $('#mySelect').select2();
        $('.selectGarage').select2();
        
    });
</script>

    <script>

        $(document).ready(function() {


            $('#filter_orders').on('change', function() {
                var brand_id = this.value;
                // $("#state-dd").html('');
                $.ajax({
                    url: '/Vehicule/' + brand_id,
                    type: 'get',
                    success: function(result) {
                        $('#vehicule_modelop_id').html(
                            '<option value="">Selectionner Modele </option>');
                        $.each(result, function(key, value) {

                            $("#vehicule_modelop_id").append('<option value="' + value
                                .id + '">' + value.name + '</option>');
                        });
                    }
                });
            });

            $('#brand_id').on('change', function() {
                var brand_id = this.value;
                // $("#state-dd").html('');
                $.ajax({
                    url: '/Vehicule/' + brand_id,
                    type: 'get',
                    success: function(result) {
                        $('#vehicule_model_id').html(
                            '<option  value="">Selectionner Modele </option>');
                        $.each(result, function(key, value) {

                            $("#vehicule_model_id").append('<option  value="' + value
                                .id + '">' + value.name + '</option>');
                        });
                    }
                });
            });

            // $('#filter_orders').on('change',function(){
            //     var value = this.value;
            //     var brand_id = $(this).find(':selected').attr('data-brandop-id');

            //     $.ajax({
            //         url:'/Vehicule/' + brand_id,
            //         type:'get',
            //         data:{filter:value},
            //         success:function(response){

            //             $('#vehicule_modelop_id').html('<option value="">Selectionner </option>');
            //                     $.each(response.models, function (key, value) {
            //                         $("#vehicule_modelop_id").append('<option value="' + value
            //                             .id + '">' + value.name + '</option>');
            //                     });            },
            //         error: function(error){
            //             console.log(error);
            //         }
            //     })});



        })
    </script>
@endsection
